/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

public class MathUtil {
    public static final int MAX_PRIME_INTEGER = 2147482661;

    private MathUtil() {
    }

    public static int findNextPrime(int number) {
        if (number <= 2) {
            return 2;
        }
        if (MathUtil.isEven(number)) {
            ++number;
        }
        if (number > 2147482661) {
            return number;
        }
        for (int next = number; next < number + 1000; next += 2) {
            if (!MathUtil.isPrime(next)) continue;
            return next;
        }
        return number;
    }

    public static boolean isPrime(int number) {
        if (number == 2 || number == 3 || number == 5 || number == 7 || number == 11 || number == 13 || number == 17 || number == 19) {
            return true;
        }
        if (number % 2 == 0 || number % 3 == 0 || number % 5 == 0 || number % 7 == 0 || number % 11 == 0 || number % 13 == 0 || number % 17 == 0 || number % 19 == 0) {
            return false;
        }
        long numberMinusOne = number - 1;
        long s = 0L;
        long d = numberMinusOne;
        while (MathUtil.isEven(d)) {
            d /= 2L;
            ++s;
        }
        long d1 = d;
        for (int a = 2; a <= 5; ++a) {
            if (a == 4) continue;
            long prod = 1L;
            long a2j = a;
            for (d = d1; d > 0L; d /= 2L) {
                if (MathUtil.isOdd(d)) {
                    prod = prod * a2j % (long)number;
                }
                a2j = a2j * a2j % (long)number;
            }
            if (prod == 1L || prod == numberMinusOne) continue;
            for (long i = 1L; i <= s && (prod = prod * prod % (long)number) != numberMinusOne; ++i) {
            }
            if (prod == numberMinusOne) continue;
            return false;
        }
        return number != 25326001 && number != 161304001 && number != 960946321 && number != 1157839381;
    }

    public static boolean isOdd(int number) {
        return MathUtil.isOdd((long)number);
    }

    public static boolean isOdd(long number) {
        return number % 2L != 0L;
    }

    public static boolean isEven(int number) {
        return MathUtil.isEven((long)number);
    }

    public static boolean isEven(long number) {
        return number % 2L == 0L;
    }
}

