/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerReadyStatus;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.update.RuntimeUpdateListener;
import com.ibm.ws.runtime.update.RuntimeUpdateManager;
import com.ibm.ws.runtime.update.RuntimeUpdateNotification;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import io.openliberty.checkpoint.internal.CheckpointTransformer;
import io.openliberty.checkpoint.internal.criu.CheckpointFailedException;
import io.openliberty.checkpoint.internal.criu.ExecuteCRIU;
import io.openliberty.checkpoint.internal.openj9.J9CRIUSupport;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.condition.Condition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(reference={@Reference(name="hooksMultiThread", service=CheckpointHook.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(io.openliberty.checkpoint.hook.multi.threaded=true)"), @Reference(name="hooksSingleThread", service=CheckpointHook.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(|(!(io.openliberty.checkpoint.hook.multi.threaded=*))(io.openliberty.checkpoint.hook.multi.threaded=false))"), @Reference(name="io.openliberty.checkpoint.beta", service=Condition.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(osgi.condition.id=io.openliberty.checkpoint.feature)")}, property={"service.ranking:Integer=-10000"}, immediate=true)
public class CheckpointImpl
implements RuntimeUpdateListener,
ServerReadyStatus {
    private static final Set<String> SUPPORTED_FEATURES;
    private static final String CHECKPOINT_STUB_CRIU = "io.openliberty.checkpoint.stub.criu";
    private static final String CHECKPOINT_CRIU_UNPRIVILEGED = "io.openliberty.checkpoint.criu.unprivileged";
    private static final String CHECKPOINT_ALLOWED_FEATURES = "io.openliberty.checkpoint.allowed.features";
    private static final String CHECKPOINT_ALLOWED_FEATURES_ALL = "ALL_FEATURES";
    static final String CHECKPOINT_PAUSE_RESTORE = "io.openliberty.checkpoint.pause.restore";
    static final String HOOKS_REF_NAME_SINGLE_THREAD = "hooksSingleThread";
    static final String HOOKS_REF_NAME_MULTI_THREAD = "hooksMultiThread";
    static final String BETA_FEATURE_CONITION_REF = "io.openliberty.checkpoint.beta";
    private static final String DIR_CHECKPOINT = "checkpoint/";
    private static final String FILE_RESTORE_MARKER = "checkpoint/.restoreMarker";
    private static final String FILE_RESTORE_FAILED_MARKER = "checkpoint/.restoreFailedMarker";
    private static final String FILE_ENV_PROPERTIES = "checkpoint/.env.properties";
    private static final String DIR_CHECKPOINT_IMAGE = "checkpoint/image/";
    private static final String CHECKPOINT_LOG_FILE = "checkpoint.log";
    private static final TraceComponent tc;
    private final Set<String> allowedFeatures;
    private final ComponentContext cc;
    private final CheckpointPhase checkpointAt;
    private final WsLocationAdmin locAdmin;
    private final AtomicBoolean checkpointCalled = new AtomicBoolean(false);
    private final ServiceRegistration<ClassFileTransformer> transformerReg;
    private final AtomicBoolean jvmRestore = new AtomicBoolean(false);
    private final AtomicReference<CountDownLatch> waitForConfig = new AtomicReference();
    private final ExecuteCRIU criu;
    private final long pauseRestore;
    private static volatile CheckpointImpl INSTANCE;
    static final long serialVersionUID = -1314624925196128192L;

    @Activate
    public CheckpointImpl(ComponentContext cc, @Reference WsLocationAdmin locAdmin, @Reference(target="(!(io.openliberty.checkpoint=INACTIVE))") CheckpointPhase phase) {
        this(cc, null, locAdmin, phase);
    }

    CheckpointImpl(ComponentContext cc, ExecuteCRIU criu, WsLocationAdmin locAdmin, CheckpointPhase phase) {
        this.cc = cc;
        this.allowedFeatures = CheckpointImpl.getAllowedFeatures(cc);
        this.criu = Boolean.valueOf(cc.getBundleContext().getProperty(CHECKPOINT_STUB_CRIU)) != false ? new ExecuteCRIU(){
            static final long serialVersionUID = -8758089940751541600L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void dump(Runnable prepare, Runnable restore, File imageDir, String logFileName, File workDir, File envProps, boolean unprivileged) throws CheckpointFailedException {
                prepare.run();
                restore.run();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointImpl$1", 1.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
            }
        } : (criu == null ? J9CRIUSupport.create(this) : criu);
        this.locAdmin = locAdmin;
        this.checkpointAt = phase;
        this.pauseRestore = this.getPauseTime(cc.getBundleContext().getProperty(CHECKPOINT_PAUSE_RESTORE));
        if (this.checkpointAt == CheckpointPhase.DEPLOYMENT) {
            this.transformerReg = cc.getBundleContext().registerService(ClassFileTransformer.class, (Object)new CheckpointTransformer(), FrameworkUtil.asDictionary(Collections.singletonMap("io.openliberty.classloading.system.transformer", true)));
            INSTANCE = this;
        } else {
            this.transformerReg = null;
            INSTANCE = null;
        }
    }

    private long getPauseTime(String pauseRestoreTime) {
        if (pauseRestoreTime == null) {
            return 0L;
        }
        try {
            long result = Long.parseLong(pauseRestoreTime);
            return result < 0L ? 0L : result;
        }
        catch (NumberFormatException result) {
            FFDCFilter.processException((Throwable)result, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"273", (Object)this, (Object[])new Object[]{pauseRestoreTime});
            return 0L;
        }
    }

    private static Set<String> getAllowedFeatures(ComponentContext cc) {
        String allowedProp = cc.getBundleContext().getProperty(CHECKPOINT_ALLOWED_FEATURES);
        if (allowedProp == null) {
            return Collections.emptySet();
        }
        String[] allowedFeatures = allowedProp.split(",");
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(allowedFeatures)));
    }

    @Deactivate
    void deactivate() {
        if (INSTANCE == this) {
            INSTANCE = null;
        }
    }

    public void notificationCreated(RuntimeUpdateManager updateManager, RuntimeUpdateNotification notification) {
        if (this.checkpointAt == CheckpointPhase.FEATURES && "ApplicationsStarting".equals(notification.getName())) {
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = 4279765502656027232L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    if (result.booleanValue()) {
                        CheckpointImpl.this.checkpointOrExitOnFailure();
                    }
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointImpl$2", 2.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
                }
            });
        } else if (this.jvmRestore.compareAndSet(true, false) && "ConfigUpdatesDelivered".equals(notification.getName())) {
            CheckpointImpl.debug(tc, () -> "Processing config on restore.");
            final CountDownLatch localLatch = new CountDownLatch(1);
            this.waitForConfig.set(localLatch);
            notification.onCompletion((CompletionListener)new CompletionListener<Boolean>(){
                static final long serialVersionUID = -4537401228162802140L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public void successfulCompletion(Future<Boolean> future, Boolean result) {
                    CheckpointImpl.debug(tc, () -> "Config has been successfully processed on restore.");
                    localLatch.countDown();
                }

                public void failedCompletion(Future<Boolean> future, Throwable t) {
                    CheckpointImpl.debug(tc, () -> "Failed to process config on restore");
                    localLatch.countDown();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointImpl$3", 3.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
                }
            });
        }
    }

    public void check() {
        this.checkpointOrExitOnFailure();
    }

    /*
     * WARNING - void declaration
     */
    void checkpointOrExitOnFailure() {
        try {
            this.checkpoint();
        }
        catch (CheckpointFailedException checkpointFailedException) {
            void e;
            FFDCFilter.processException((Throwable)checkpointFailedException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"347", (Object)this, (Object[])new Object[0]);
            if (e.isRestore()) {
                this.createRestoreFailedMarker((CheckpointFailedException)e);
            }
            Tr.error((TraceComponent)tc, (String)e.getErrorMsgKey(), (Object[])new Object[]{e.getMessage()});
            new Thread(() -> CheckpointImpl.lambda$checkpointOrExitOnFailure$1((CheckpointFailedException)e), "Checkpoint failed, exiting...").start();
        }
    }

    @FFDCIgnore(value={IllegalStateException.class, Exception.class, CheckpointFailedException.class})
    void checkpoint() throws CheckpointFailedException {
        CheckpointImpl.debug(tc, () -> "Checkpoint for : " + this.checkpointAt);
        Condition betaFeature = (Condition)this.cc.locateService(BETA_FEATURE_CONITION_REF);
        if (betaFeature == null) {
            throw new CheckpointFailedException(CheckpointFailedException.Type.UNKNOWN_CHECKPOINT, "CWWKC0460E: The server command specified the checkpoint action. A checkpoint cannot be taken because the checkpoint-1.0 feature is not configured in the server.xml file.", null);
        }
        if (this.checkpointCalledAlready()) {
            CheckpointImpl.debug(tc, () -> "Trying to checkpoint a second time" + this.checkpointAt);
            return;
        }
        if (this.transformerReg != null) {
            try {
                this.transformerReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.checkSupportedFeatures();
        List<CheckpointHook> multiThreadPrepareHooks = this.getHooks(this.cc.locateServices(HOOKS_REF_NAME_MULTI_THREAD));
        List<CheckpointHook> singleThreadPrepareHooks = this.getHooks(this.cc.locateServices(HOOKS_REF_NAME_SINGLE_THREAD));
        ArrayList<CheckpointHook> multiThreadRestoreHooks = new ArrayList<CheckpointHook>(multiThreadPrepareHooks);
        Collections.reverse(multiThreadRestoreHooks);
        ArrayList<CheckpointHook> singleThreadRestoreHooks = new ArrayList<CheckpointHook>(singleThreadPrepareHooks);
        Collections.reverse(singleThreadRestoreHooks);
        Tr.audit((TraceComponent)tc, (String)"CHECKPOINT_DUMP_INITIATED_CWWKC0451", (Object[])new Object[0]);
        this.prepare(multiThreadPrepareHooks);
        try {
            try {
                this.criu.checkpointSupported();
            }
            catch (CheckpointFailedException cpfe) {
                CheckpointImpl.debug(tc, () -> "ExecuteCRIU service does not support checkpoint: " + cpfe.getMessage());
                throw cpfe;
            }
            boolean unprivileged = Boolean.valueOf(this.cc.getBundleContext().getProperty(CHECKPOINT_CRIU_UNPRIVILEGED));
            File imageDir = this.getImageDir();
            CheckpointImpl.debug(tc, () -> "criu attempt dump to '" + imageDir + "' and exit process.");
            this.criu.dump(() -> this.prepare(singleThreadPrepareHooks), () -> this.restore(singleThreadRestoreHooks), imageDir, CHECKPOINT_LOG_FILE, this.getLogsCheckpoint(), this.getEnvProperties(), unprivileged);
            CheckpointImpl.debug(tc, () -> "criu dumped to " + imageDir + ", now in recovered process.");
        }
        catch (Exception e) {
            if (e instanceof CheckpointFailedException) {
                if (!((CheckpointFailedException)e).isRestore()) {
                    Map<String, String> configMap = Collections.singletonMap("RESTORE_ENABLED", "true");
                    TrConfigurator.update(configMap);
                }
                throw (CheckpointFailedException)e;
            }
            throw new CheckpointFailedException(this.getUnknownType(), Tr.formatMessage((TraceComponent)tc, (String)"UKNOWN_FAILURE_CWWKC0455E", (Object[])new Object[]{e.getMessage()}), e);
        }
        if (this.pauseRestore > 0L) {
            try {
                Thread.sleep(this.pauseRestore);
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"439", (Object)this, (Object[])new Object[0]);
                Thread.currentThread().isInterrupted();
            }
        }
        this.restore(multiThreadRestoreHooks);
        this.registerRunningCondition();
        this.waitForConfig();
        Tr.audit((TraceComponent)tc, (String)"CHECKPOINT_RESTORE_CWWKC0452I", (Object[])new Object[]{TimestampUtils.getElapsedTime()});
        this.createRestoreMarker();
    }

    /*
     * WARNING - void declaration
     */
    private void checkSupportedFeatures() {
        if (this.allowedFeatures.contains(CHECKPOINT_ALLOWED_FEATURES_ALL)) {
            return;
        }
        try {
            ServiceReference[] features = this.cc.getBundleContext().getServiceReferences("com.ibm.wsspi.kernel.feature.LibertyFeature", null);
            if (features != null) {
                ArrayList<Object> unsupported = new ArrayList<Object>(0);
                for (ServiceReference feature : features) {
                    Object featureName = feature.getProperty("ibm.featureName");
                    if (SUPPORTED_FEATURES.contains(featureName) || this.allowedFeatures.contains(featureName)) continue;
                    unsupported.add(featureName);
                }
                if (!unsupported.isEmpty()) {
                    throw new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_PREPARE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"CHECKPOINT_FAILED_UNSUPPORTED_FEATURE_CWWKC0456E", (Object[])new Object[]{unsupported}), null);
                }
            }
        }
        catch (InvalidSyntaxException features) {
            void e;
            FFDCFilter.processException((Throwable)features, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"475", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
    }

    public CheckpointFailedException.Type getUnknownType() {
        return this.getEnvProperties().exists() ? CheckpointFailedException.Type.UNKNOWN_RESTORE : CheckpointFailedException.Type.UNKNOWN_CHECKPOINT;
    }

    public String getMessage(String msgKey, Object ... args) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])args);
    }

    private void registerRunningCondition() {
        BundleContext bc = this.cc.getBundleContext();
        Hashtable<String, String> conditionProps = new Hashtable<String, String>();
        conditionProps.put("osgi.condition.id", "io.openliberty.process.running");
        conditionProps.put("io.openliberty.checkpoint", (String)this.checkpointAt);
        bc.registerService(Condition.class, (Object)Condition.INSTANCE, conditionProps);
    }

    private void waitForConfig() {
        CountDownLatch l = this.waitForConfig.getAndSet(null);
        if (l != null) {
            CheckpointImpl.debug(tc, () -> "Waiting for config to be processed on restore.");
            try {
                l.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"503", (Object)this, (Object[])new Object[0]);
                Thread.currentThread().interrupt();
            }
            CheckpointImpl.debug(tc, () -> "Config to is done being processed on restore.");
        }
    }

    private File getImageDir() {
        File imageDir = this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/image/").asFile();
        imageDir.mkdirs();
        return imageDir;
    }

    private File getLogsCheckpoint() {
        WsResource logsCheckpoint = this.locAdmin.resolveResource("${server.logs.dir}/checkpoint/");
        logsCheckpoint.create();
        return logsCheckpoint.asFile();
    }

    private void createRestoreMarker() {
        this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.restoreMarker").create();
    }

    private void createRestoreFailedMarker(CheckpointFailedException e) {
        WsResource failedMarker = this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.restoreFailedMarker");
        try {
            PrintStream ps = new PrintStream(failedMarker.putStream());
            try {
                ps.print(String.valueOf(e.getErrorCode()));
                ps.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"533", (Object)this, (Object[])new Object[]{e});
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"533", (Object)this, (Object[])new Object[]{e});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"535", (Object)this, (Object[])new Object[]{e});
        }
    }

    private File getEnvProperties() {
        return this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.env.properties").asFile();
    }

    List<CheckpointHook> getHooks(Object[] hooks) {
        if (hooks == null) {
            CheckpointImpl.debug(tc, () -> "No checkpoint hooks.");
            return Collections.emptyList();
        }
        CheckpointImpl.debug(tc, () -> "Found checkpoint hooks: " + hooks);
        ArrayList<CheckpointHook> hookList = new ArrayList<CheckpointHook>(hooks.length);
        for (Object o : hooks) {
            CheckpointHook hook = (CheckpointHook)o;
            hookList.add(hook);
        }
        return hookList;
    }

    @FFDCIgnore(value={Exception.class})
    private void callHooks(String operation, List<CheckpointHook> checkpointHooks, Consumer<CheckpointHook> perform, Function<Exception, CheckpointFailedException> failed) throws CheckpointFailedException {
        for (CheckpointHook checkpointHook : checkpointHooks) {
            try {
                CheckpointImpl.debug(tc, () -> operation + " operation on hook: " + checkpointHook);
                perform.accept(checkpointHook);
            }
            catch (Exception abortCause) {
                CheckpointImpl.debug(tc, () -> operation + " failed on hook: " + checkpointHook);
                throw failed.apply(abortCause);
            }
        }
    }

    private void prepare(List<CheckpointHook> checkpointHooks) throws CheckpointFailedException {
        this.callHooks("prepare", checkpointHooks, CheckpointHook::prepare, CheckpointImpl::failedPrepare);
    }

    private static CheckpointFailedException failedPrepare(Exception cause) {
        return new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_PREPARE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"CHECKPOINT_FAILED_PREPARE_EXCEPTION_CWWKC0457E", (Object[])new Object[]{cause.getMessage()}), cause);
    }

    private void restore(List<CheckpointHook> checkpointHooks) throws CheckpointFailedException {
        this.jvmRestore.set(true);
        this.callHooks("restore", checkpointHooks, CheckpointHook::restore, CheckpointImpl::failedRestore);
    }

    private static CheckpointFailedException failedRestore(Exception cause) {
        return new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_RESTORE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"RESTORE_FAILED_RESTORE_EXCEPTION_CWWKC0458E", (Object[])new Object[]{cause.getMessage()}), cause);
    }

    boolean checkpointCalledAlready() {
        return !this.checkpointCalled.compareAndSet(false, true);
    }

    void resetCheckpointCalled() {
        this.checkpointCalled.set(false);
    }

    public static void deployCheckpoint() {
        CheckpointImpl current = INSTANCE;
        if (current != null && current.checkpointAt == CheckpointPhase.DEPLOYMENT) {
            current.checkpointOrExitOnFailure();
        }
    }

    @Trivial
    static void debug(TraceComponent trace, Supplier<String> message) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            Tr.debug((TraceComponent)trace, (String)message.get(), (Object[])new Object[0]);
        }
    }

    private static /* synthetic */ void lambda$checkpointOrExitOnFailure$1(CheckpointFailedException e) {
        System.exit(e.getErrorCode());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        String[] supported = new String[]{"checkpoint-1.0", "osgiConsole-1.0", "appSecurity-2.0", "appSecurity-3.0", "beanValidation-2.0", "cdi-2.0", "distributedMap-1.0", "ejbLite-3.2", "el-3.0", "jaspic-1.1", "jaxrs-2.1", "jaxrsClient-2.1", "jdbc-4.2", "jndi-1.0", "jpa-2.2", "jpaContainer-2.2", "jsf-2.3", "json-1.0", "jsonb-1.0", "jsonp-1.1", "jsp-2.3", "jwt-1.0", "managedBeans-1.0", "microProfile-4.1", "monitor-1.0", "mpConfig-2.0", "mpFaultTolerance-3.0", "mpHealth-3.1", "mpJwt-1.2", "mpMetrics-3.0", "mpOpenAPI-2.0", "mpOpenTracing-2.0", "mpRestClient-2.0", "opentracing-2.0", "servlet-4.0", "ssl-1.0", "webProfile-8.0", "websocket-1.1", "appAuthentication-2.0", "appSecurity-4.0", "beanValidation-3.0", "cdi-3.0", "concurrent-2.0", "distributedMap-1.0", "enterpriseBeansLite-4.0", "expressionLanguage-4.0", "faces-3.0", "jdbc-4.2", "jndi-1.0", "json-1.0", "jsonb-2.0", "jsonp-2.0", "jwt-1.0", "managedBeans-2.0", "microProfile-5.0", "monitor-1.0", "mpConfig-3.0", "mpFaultTolerance-4.0", "mpHealth-4.0", "mpJwt-2.0", "mpMetrics-4.0", "mpOpenAPI-3.0", "mpOpenTracing-3.0", "mpRestClient-3.0", "pages-3.0", "persistence-3.0", "persistenceContainer-3.0", "restfulWS-3.0", "restfulWSClient-3.0", "servlet-5.0", "ssl-1.0", "transportSecurity-1.0", "webProfile-9.1", "websocket-2.0", "xmlBinding-3.0"};
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(supported));
        SUPPORTED_FEATURES = Collections.unmodifiableSet(result);
        tc = Tr.register(CheckpointImpl.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
        INSTANCE = null;
    }
}

