/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.internal.util.EventLock;
import com.ibm.ws.classloading.internal.util.EventLockCumulativeTimeout;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class EventReadWriteLock
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    private final EventLock eventLock;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    EventReadWriteLock() {
        this.eventLock = new EventLock();
    }

    EventReadWriteLock(long nanoTimeout) {
        this.eventLock = nanoTimeout == 0L ? new EventLock() : new EventLockCumulativeTimeout(nanoTimeout);
    }

    boolean canTimeOut() {
        return this.eventLock.canTimeOut();
    }

    boolean hasTimedOut() {
        return this.eventLock.hasTimedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean waitForEvent() throws InterruptedException {
        int oldEventCount = this.eventLock.getEventCount();
        int readLockCount = this.releaseReadLocks();
        if (readLockCount == 0) {
            throw new IllegalStateException("Must hold read lock");
        }
        if (this.getWriteHoldCount() > 0) {
            throw new IllegalStateException("Must not hold write lock");
        }
        try {
            boolean bl = this.eventLock.wait(oldEventCount);
            return bl;
        }
        finally {
            this.acquireReadLocks(readLockCount);
        }
    }

    void postEvent() {
        this.eventLock.postEvent();
    }

    private int releaseReadLocks() {
        int readHoldCount = this.getReadHoldCount();
        for (int i = 0; i < readHoldCount; ++i) {
            this.readLock().unlock();
        }
        return readHoldCount;
    }

    private void acquireReadLocks(int lockCount) {
        for (int i = 0; i < lockCount; ++i) {
            this.readLock().lock();
        }
    }

    public int releaseWriteLocks() {
        int writeHoldCount = this.getWriteHoldCount();
        for (int i = 0; i < writeHoldCount; ++i) {
            this.writeLock().unlock();
        }
        return writeHoldCount;
    }

    public void acquireWriteLocks(int lockCount) {
        for (int i = 0; i < lockCount; ++i) {
            this.writeLock().lock();
        }
    }

    public int releaseReadLocksAndAcquireWriteLock() {
        int lockCount = this.releaseReadLocks();
        this.writeLock().lock();
        return lockCount;
    }

    public void downgradeWriteLockToReadLocks(int lockCount) {
        this.acquireReadLocks(lockCount);
        this.writeLock().unlock();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.util.EventReadWriteLock", EventReadWriteLock.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    }
}

