/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.servercontainer;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.EndpointHelper;
import com.ibm.ws.wsoc.EndpointManager;
import com.ibm.ws.wsoc.WebSocketVersionServiceManager;
import com.ibm.ws.wsoc.external.WebSocketContainerExt;
import com.ibm.ws.wsoc.external.WsocHandlerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ServerContainerExt
extends WebSocketContainerExt {
    private static final TraceComponent tc = Tr.register(ServerContainerExt.class, null, null);
    EndpointManager endpointManager = new EndpointManager();
    private boolean noMoreAdds = false;
    protected final WsocHandlerImpl wsocUpgradeHandler = new WsocHandlerImpl();
    static final long serialVersionUID = -4878292537863438770L;

    public void initialize() {
    }

    /*
     * WARNING - void declaration
     */
    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (this.noMoreAdds) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"endpoint.addsclosed", (Object[])new Object[0]);
            throw new IllegalStateException(msg);
        }
        EndpointHelper helper = this.getAnnotatedEndpointClass(endpointClass);
        String path = helper.getInvocationPath();
        if (this.endpointManager.isURIExists(path)) {
            ServerEndpointConfig serverConfig = this.endpointManager.getServerEndpointConfig(path);
            if (serverConfig.getEndpointClass().equals(endpointClass)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Endpoint class:" + endpointClass + " with URI: " + path + " has already been processed during webapp startup."), (Object[])new Object[0]);
                }
                return;
            }
            this.cleanupEndpoints();
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"duplicate.uri", (Object[])new Object[]{serverConfig.getPath()});
            Tr.error((TraceComponent)tc, (String)"duplicate.uri", (Object[])new Object[]{serverConfig.getPath()});
            throw new IllegalStateException(msg);
        }
        try {
            this.addEndpoint(this.findOrBuildServerConfig(helper));
        }
        catch (IllegalAccessException serverConfig) {
            void e;
            FFDCFilter.processException((Throwable)serverConfig, (String)"com.ibm.ws.wsoc.servercontainer.ServerContainerExt", (String)"86", (Object)this, (Object[])new Object[]{endpointClass});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"endpoint.creation.error", (Object[])new Object[]{endpointClass, e});
            throw new DeploymentException(msg);
        }
        catch (InstantiationException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wsoc.servercontainer.ServerContainerExt", (String)"90", (Object)this, (Object[])new Object[]{endpointClass});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"endpoint.creation.error", (Object[])new Object[]{endpointClass, e});
            throw new DeploymentException(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addEndpoint(ServerEndpointConfig serverConfig) throws DeploymentException {
        if (this.noMoreAdds) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"endpoint.addsclosed", (Object[])new Object[0]);
            throw new IllegalStateException(msg);
        }
        if (this.endpointManager.isURIExists(serverConfig.getPath())) {
            this.cleanupEndpoints();
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"duplicate.uri", (Object[])new Object[]{serverConfig.getPath()});
            Tr.error((TraceComponent)tc, (String)"duplicate.uri", (Object[])new Object[]{serverConfig.getPath()});
            throw new DeploymentException(msg);
        }
        try {
            this.createAnnotatedEndpoint(serverConfig);
        }
        catch (DeploymentException msg) {
            void e;
            FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.wsoc.servercontainer.ServerContainerExt", (String)"119", (Object)this, (Object[])new Object[]{serverConfig});
            this.cleanupEndpoints();
            throw e;
        }
        this.endpointManager.addServerEndpointConfig(serverConfig);
    }

    public void addEndpoint(EndpointHelper helper) throws DeploymentException, IllegalAccessException, InstantiationException {
        this.addEndpoint(this.findOrBuildServerConfig(helper));
    }

    private void cleanupEndpoints() {
        this.endpointManager.clear();
    }

    private String addWildCard(String path) {
        String delimiter = "/";
        String[] tockenizedPath = path.split(delimiter);
        StringBuffer buffer = new StringBuffer();
        for (String part : tockenizedPath) {
            if (part.isEmpty()) continue;
            if (part.startsWith("{") && part.endsWith("}")) {
                buffer.append(delimiter + "*");
                break;
            }
            buffer.append(delimiter + part);
        }
        return buffer.toString();
    }

    public ServerEndpointConfig getServerEndpointConfig(String _path) {
        ServerEndpointConfig config = this.endpointManager.getServerEndpointConfig(_path);
        return config;
    }

    public EndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public void setNoMoreAddEndpointsAllowed() {
        if (!WebSocketVersionServiceManager.isWsoc21OrHigher()) {
            this.noMoreAdds = true;
        }
    }

    @FFDCIgnore(value={IllegalStateException.class})
    public ServerEndpointConfig findOrBuildServerConfig(EndpointHelper helper) throws IllegalAccessException, InstantiationException, DeploymentException {
        if (helper.getServerEndpointConfig() == null) {
            String mapping = helper.getInvocationPath();
            ServerEndpointConfig.Builder builder = null;
            try {
                builder = ServerEndpointConfig.Builder.create(helper.getEndpointClass(), (String)mapping);
            }
            catch (IllegalStateException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"missingslashornull.uri", (Object[])new Object[]{helper.getEndpointClass(), helper.getInvocationPath()});
                Tr.error((TraceComponent)tc, (String)"missingslashornull.uri", (Object[])new Object[]{helper.getEndpointClass(), helper.getInvocationPath()});
                throw new DeploymentException(msg);
            }
            if (helper.getDecoders() != null) {
                builder.decoders(helper.getDecoders());
            }
            if (helper.getEncoders() != null) {
                builder.encoders(helper.getEncoders());
            }
            if (helper.getServerEndpointConfigurator() != null) {
                builder.configurator(helper.getServerEndpointConfigurator().newInstance());
            }
            if (helper.getSubprotocols() != null) {
                builder.subprotocols(Arrays.asList(helper.getSubprotocols()));
            }
            return builder.build();
        }
        return helper.getServerEndpointConfig();
    }

    public EndpointHelper getAnnotatedEndpointClass(Class<?> c) {
        ServerEndpoint se = c.getAnnotation(ServerEndpoint.class);
        EndpointHelper helper = null;
        if (se != null) {
            String[] subprotocols;
            Class configurator;
            Class[] encoders;
            helper = new EndpointHelper();
            helper.setEndpointClass(c);
            helper.setInvocationPath(se.value());
            Class[] decoders = se.decoders();
            if (decoders != null && decoders.length > 0) {
                ArrayList<Class<? extends Decoder>> list = new ArrayList<Class<? extends Decoder>>();
                for (int i = 0; i < decoders.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found decoder of: " + decoders[i]), (Object[])new Object[0]);
                    }
                    list.add(decoders[i]);
                }
                helper.setDecoders(list);
            }
            if ((encoders = se.encoders()) != null && encoders.length > 0) {
                ArrayList<Class<? extends Encoder>> list = new ArrayList<Class<? extends Encoder>>();
                for (int i = 0; i < encoders.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found encoder of: " + encoders[i]), (Object[])new Object[0]);
                    }
                    list.add(encoders[i]);
                }
                helper.setEncoders(list);
            }
            if ((configurator = se.configurator()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("found configurator of: " + configurator), (Object[])new Object[0]);
                }
                helper.setServerEndpointConfigurator(configurator);
            }
            if ((subprotocols = se.subprotocols()) != null) {
                if (tc.isDebugEnabled()) {
                    for (String protocol : subprotocols) {
                        Tr.debug((TraceComponent)tc, (String)("found a subprotocol " + protocol), (Object[])new Object[0]);
                    }
                }
                helper.setSubprotocols(subprotocols);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("possible annotated endpoint of: " + c), (Object[])new Object[0]);
            }
        }
        return helper;
    }

    private AnnotatedEndpoint createAnnotatedEndpoint(ServerEndpointConfig serverConfig) throws DeploymentException {
        AnnotatedEndpoint annotatedEP = null;
        if (serverConfig.getEndpointClass().isAnnotationPresent(ServerEndpoint.class)) {
            annotatedEP = new AnnotatedEndpoint();
            annotatedEP.initialize(serverConfig.getEndpointClass(), (EndpointConfig)serverConfig);
            this.endpointManager.addAnnotatedEndpoint(annotatedEP);
        }
        return annotatedEP;
    }
}

