/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.HandshakeProcessor;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.WebSocketContainerManager;
import com.ibm.ws.wsoc.external.HandshakeResponseExt;
import com.ibm.ws.wsoc.outbound.ClientTransportAccess;
import com.ibm.ws.wsoc.outbound.HttpRequestor;
import com.ibm.ws.wsoc.outbound.WsocAddress;
import com.ibm.ws.wsoc.outbound.WsocOutboundChain;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.GenericKeys;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpRequestorWsoc10
implements HttpRequestor {
    private static final TraceComponent tc = Tr.register(HttpRequestorWsoc10.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    protected ClientTransportAccess access = null;
    protected WsocAddress endpointAddress = null;
    protected OutboundVirtualConnection vc = null;
    private HttpOutboundServiceContext httpOutboundSC = null;
    private String websocketKey = "";
    private final Map<String, List<String>> requestHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> responseHeaders = null;
    protected final ClientEndpointConfig config;
    private final ParametersOfInterest things;
    private final Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();
    static final long serialVersionUID = -6155467209745109417L;

    public HttpRequestorWsoc10(WsocAddress endpointAddress, ClientEndpointConfig config, ParametersOfInterest things) {
        this.endpointAddress = endpointAddress;
        this.config = config;
        this.things = things;
    }

    @Override
    public ClientTransportAccess getClientTransportAccess() {
        return this.access;
    }

    @Override
    public void connect() throws Exception {
        this.access = new ClientTransportAccess();
        this.vc = (OutboundVirtualConnection)WsocOutboundChain.getVCFactory(this.endpointAddress);
        this.access.setVirtualConnection((VirtualConnection)this.vc);
        this.vc.connect((Object)this.endpointAddress);
    }

    @Override
    public void sendRequest() throws IOException, MessageSentException {
        this.sendRequest(null);
    }

    @Override
    public void sendRequest(ParametersOfInterest poi) throws IOException, MessageSentException {
        this.httpOutboundSC = (HttpOutboundServiceContext)this.vc.getChannelAccessor();
        this.access.setTCPConnectionContext(this.httpOutboundSC.getTSC());
        this.access.setDeviceConnLink((ConnectionLink)this.httpOutboundSC.getLink());
        HttpRequestMessage hrm = this.httpOutboundSC.getRequest();
        hrm.setRequestURI(this.endpointAddress.getPath());
        hrm.setQueryString(this.endpointAddress.getURI().getQuery());
        hrm.setVersion(VersionValues.V11);
        hrm.setMethod(MethodValues.GET);
        this.requestHeaders.put(HttpHeaderKeys.HDR_CONNECTION.getName(), Arrays.asList("Upgrade"));
        this.requestHeaders.put(HttpHeaderKeys.HDR_UPGRADE.getName(), Arrays.asList("websocket"));
        this.requestHeaders.put("Sec-WebSocket-Version", Arrays.asList("13"));
        this.websocketKey = WebSocketContainerManager.getRef().generateWebsocketKey();
        this.requestHeaders.put("Sec-WebSocket-Key", Arrays.asList(this.websocketKey));
        if (this.config != null) {
            List extensions;
            List subprotocols = this.config.getPreferredSubprotocols();
            if (subprotocols != null && subprotocols.size() > 0) {
                String subprotocolValue = "";
                for (int x = 0; x < subprotocols.size(); ++x) {
                    subprotocolValue = x == 0 ? ((String)subprotocols.get(0)).trim() : subprotocolValue + "," + ((String)subprotocols.get(x)).trim();
                }
                this.requestHeaders.put("Sec-WebSocket-Protocol", Arrays.asList(subprotocolValue));
            }
            if ((extensions = this.config.getExtensions()) != null && extensions.size() > 0) {
                StringBuffer buf = new StringBuffer();
                boolean first = true;
                for (Extension ext : extensions) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(ext.getName());
                    List li = ext.getParameters();
                    if (li == null || li.size() <= 0) continue;
                    for (Extension.Parameter p : li) {
                        buf.append("; " + p.getName() + "=" + p.getValue());
                    }
                }
                this.requestHeaders.put("Sec-WebSocket-Extensions", Arrays.asList(buf.toString()));
            }
            if (this.config.getConfigurator() != null) {
                this.config.getConfigurator().beforeRequest(this.requestHeaders);
            }
        }
        for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) {
                hrm.setHeader(entry.getKey(), "");
                continue;
            }
            if (list.size() == 0) {
                hrm.setHeader(entry.getKey(), "");
            }
            for (int x = 0; x < list.size(); ++x) {
                if (x == 0) {
                    hrm.setHeader(entry.getKey(), list.get(x));
                    continue;
                }
                hrm.appendHeader(entry.getKey(), list.get(x));
            }
        }
        this.httpOutboundSC.enableImmediateResponseRead();
        this.httpOutboundSC.sendRequestHeaders();
        if (poi != null) {
            Tr.debug((TraceComponent)tc, (String)("set query parms to " + this.endpointAddress.getURI().getQuery()), (Object[])new Object[0]);
            poi.setQueryString(this.endpointAddress.getURI().getQuery());
            if (hrm != null) {
                Map paramMap = hrm.getParameterMap();
                for (Map.Entry entry : paramMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] value = (String[])entry.getValue();
                    List<String> list = Arrays.asList(value);
                    this.parameterMap.put(key, list);
                }
                poi.setParameterMap(this.parameterMap);
                Tr.debug((TraceComponent)tc, (String)("set ParameterMap " + this.parameterMap), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WsByteBuffer completeResponse() throws IOException {
        String acceptKey;
        HttpResponseMessage hrm = this.httpOutboundSC.getResponse();
        if (!StatusCodes.SWITCHING_PROTOCOLS.equals((GenericKeys)hrm.getStatusCode())) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.returncode", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
            Tr.error((TraceComponent)tc, (String)"client.invalid.returncode", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
            throw new IOException(msg);
        }
        try {
            acceptKey = Utils.makeAcceptResponseHeaderValue(this.websocketKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.wsoc.outbound.HttpRequestorWsoc10", (String)"231", (Object)this, (Object[])new Object[0]);
            throw new IOException((Throwable)e);
        }
        String key = hrm.getHeader("Sec-WebSocket-Accept").asString();
        if (key != null) {
            if (!key.equals(acceptKey)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
                Tr.error((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
                throw new IOException(msg);
            }
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
            Tr.error((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{hrm.getStatusCode(), this.endpointAddress.getURI().toString()});
            throw new IOException(msg);
        }
        if (this.config != null) {
            List names = hrm.getAllHeaderNames();
            this.responseHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (String name : names) {
                List hdrs = hrm.getHeaders(name);
                ArrayList<String> values = new ArrayList<String>(hdrs.size());
                for (HeaderField header : hdrs) {
                    values.add(header.asString());
                }
                if (name.equalsIgnoreCase("Sec-WebSocket-Protocol") && values != null && values.size() >= 1) {
                    this.things.setAgreedSubProtocol((String)values.get(0));
                }
                if (name.equalsIgnoreCase("Sec-WebSocket-Extensions") && values != null && values.size() >= 1) {
                    this.things.setNegotiatedExtensions(HandshakeProcessor.parseClientExtensions(values));
                }
                this.responseHeaders.put(name, values);
            }
            if (this.config.getConfigurator() != null) {
                HandshakeResponseExt handshakeResponse = new HandshakeResponseExt(this.responseHeaders);
                this.config.getConfigurator().afterResponse((HandshakeResponse)handshakeResponse);
            }
        }
        WsByteBuffer retBuf = this.httpOutboundSC.getRemainingData();
        this.things.setURI(this.endpointAddress.getURI());
        if (this.config != null) {
            this.things.setLocalSubProtocols(this.config.getPreferredSubprotocols());
        }
        this.things.setWsocProtocolVersion("13");
        this.things.setSecure(this.endpointAddress.isSecure());
        return retBuf;
    }

    @Override
    public void closeConnection(IOException ioe) {
        if (this.access != null && this.access.getDeviceConnLink() != null) {
            this.access.getDeviceConnLink().close((VirtualConnection)this.vc, (Exception)ioe);
        }
    }
}

