/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.ValidationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.TokenManager;
import com.ibm.ws.security.token.internal.ValidationResultImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.ValidationResult;
import java.security.Permission;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSSecurityPropagationHelper {
    private static final TraceComponent tc = Tr.register(WSSecurityPropagationHelper.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
    private static final AtomicServiceReference<TokenManager> tokenManagerRef = new AtomicServiceReference("tokenManager");
    private static final WebSphereRuntimePermission VALIDATE_TOKEN = new WebSphereRuntimePermission("validateLTPAToken");
    static final long serialVersionUID = -6170239023559202366L;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ValidationResult validateToken(byte[] token) throws ValidationFailedException {
        ValidationResultImpl validationResult = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + VALIDATE_TOKEN.toString()), (Object[])new Object[0]);
            }
            sm.checkPermission((Permission)VALIDATE_TOKEN);
        }
        if (token == null) throw new ValidationFailedException("Invalid token, token returned from validation is null.");
        try {
            Token recreatedToken = WSSecurityPropagationHelper.recreateTokenFromBytes(token);
            if (recreatedToken == null) return validationResult;
            String accessId = recreatedToken.getAttributes("u")[0];
            String[] realms = recreatedToken.getAttributes("com.ibm.wsspi.security.cred.realm");
            String realm = null;
            if (realms == null) return new ValidationResultImpl(accessId, realm);
            realm = realms[0];
            return new ValidationResultImpl(accessId, realm);
        }
        catch (WSSecurityException recreatedToken) {
            void e;
            FFDCFilter.processException((Throwable)recreatedToken, (String)"com.ibm.wsspi.security.token.WSSecurityPropagationHelper", (String)"89", null, (Object[])new Object[]{token});
            if (!tc.isDebugEnabled()) throw new ValidationFailedException(e.getLocalizedMessage());
            Tr.debug((TraceComponent)tc, (String)("validateLTPAToken caught exception: " + e.getMessage()), (Object[])new Object[0]);
            throw new ValidationFailedException(e.getLocalizedMessage());
        }
    }

    private static Token recreateTokenFromBytes(byte[] ssoToken) throws InvalidTokenException, TokenExpiredException {
        Token token = null;
        TokenManager tokenManager = (TokenManager)tokenManagerRef.getService();
        if (tokenManager != null) {
            byte[] credToken = WSSecurityPropagationHelper.copyCredToken(ssoToken);
            token = tokenManager.recreateTokenFromBytes(credToken, new String[0]);
        }
        return token;
    }

    private static byte[] copyCredToken(byte[] credToken) {
        if (credToken == null) {
            return null;
        }
        int LEN = credToken.length;
        if (LEN == 0) {
            return new byte[LEN];
        }
        byte[] newCredToken = new byte[LEN];
        System.arraycopy(credToken, 0, newCredToken, 0, LEN);
        return newCredToken;
    }

    protected void setTokenManager(ServiceReference<TokenManager> ref) {
        tokenManagerRef.setReference(ref);
    }

    protected void unsetTokenManager(ServiceReference<TokenManager> ref) {
        tokenManagerRef.unsetReference(ref);
    }

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        tokenManagerRef.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        tokenManagerRef.deactivate(cc);
    }
}

