/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.actions;

import com.ibm.ws.bluemix.utility.BluemixUtilityAction;
import com.ibm.ws.bluemix.utility.TaskErrorException;
import com.ibm.ws.bluemix.utility.utils.Arguments;
import com.ibm.ws.bluemix.utility.utils.ConsoleHandler;
import com.ibm.ws.bluemix.utility.utils.ConsoleWrapper;
import com.ibm.ws.bluemix.utility.utils.NLS;
import com.ibm.ws.bluemix.utility.utils.Option;
import com.ibm.ws.bluemix.utility.utils.ReturnCode;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;

public abstract class BaseAction
implements BluemixUtilityAction {
    static final String NL = System.getProperty("line.separator");
    private static final Option DEBUG_OPT = new Option("debug", false, false, true);
    protected static final String SCRIPT_NAME = "bluemixUtility";
    protected ConsoleWrapper stdin;
    protected PrintStream stdout;
    protected PrintStream stderr;
    private final Map<String, Option> options = new LinkedHashMap<String, Option>();
    private List<String> arguments;

    protected BaseAction() {
        this.registerOption(DEBUG_OPT);
    }

    @Override
    public String getActionDescription() {
        return NLS.getOption(this.getActionName() + ".desc", new Object[0]);
    }

    private String getActionUsage() {
        List<String> arguments;
        StringBuilder builder = new StringBuilder();
        builder.append(SCRIPT_NAME);
        builder.append(' ');
        builder.append(this.getActionName());
        if (this.hasOptions()) {
            builder.append(" [");
            builder.append(NLS.getOption("global.options.lower", new Object[0]));
            builder.append("]");
        }
        if ((arguments = this.getActionArguments()) != null) {
            for (String argumentName : arguments) {
                builder.append(' ');
                builder.append(argumentName);
            }
        }
        return builder.toString();
    }

    @Override
    public String getActionHelp() {
        StringBuilder verboseHelp = new StringBuilder();
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.discontinue.warning", "20.0.0.8"));
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.usage", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append('\t');
        verboseHelp.append(this.getActionUsage());
        verboseHelp.append(NL);
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption("global.description", new Object[0]));
        verboseHelp.append(NL);
        verboseHelp.append(this.getActionDescription());
        verboseHelp.append(NL);
        List<String> arguments = this.getActionArguments();
        if (this.hasOptions() || arguments != null) {
            verboseHelp.append(NL);
            verboseHelp.append(NLS.getOption("global.options", new Object[0]));
            verboseHelp.append(NL);
        }
        for (Map.Entry<String, Option> optionEntry : this.options.entrySet()) {
            Option option = optionEntry.getValue();
            if (option.isInternal()) continue;
            String optionName = option.getName();
            this.generateParameterHelp(verboseHelp, "--" + optionName);
        }
        if (arguments != null) {
            for (String argument : arguments) {
                this.generateParameterHelp(verboseHelp, argument);
            }
        }
        verboseHelp.append(NL);
        return verboseHelp.toString();
    }

    private void generateParameterHelp(StringBuilder verboseHelp, String optionName) {
        String optionKey;
        String task = this.getActionName();
        try {
            optionKey = NLS.getOption(task + ".option-key." + optionName, new Object[0]);
        }
        catch (MissingResourceException e) {
            optionKey = "    " + optionName;
        }
        verboseHelp.append(NL);
        verboseHelp.append(optionKey);
        verboseHelp.append(NL);
        verboseHelp.append(NLS.getOption(task + ".option-desc." + optionName, new Object[0]));
        verboseHelp.append(NL);
    }

    private List<String> getActionArguments() {
        return this.arguments;
    }

    protected void registerArguments(String ... args) {
        this.arguments = Arrays.asList(args);
    }

    protected void registerOption(Option option) {
        this.options.put(option.getName(), option);
    }

    private boolean hasOptions() {
        for (Option option : this.options.values()) {
            if (option.isInternal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ReturnCode handleAction(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        Arguments arguments = new Arguments(args);
        if (arguments.getOption("help") != null) {
            stdout.println(this.getActionHelp());
            return ReturnCode.OK;
        }
        String debug = arguments.getOption("debug");
        Level logLevel = debug == null ? Level.INFO : Level.FINEST;
        ConsoleHandler.enableConsoleLogging(logLevel);
        this.validateArguments(arguments);
        this.validateOptions(arguments);
        return this.handleAction(arguments);
    }

    public abstract ReturnCode handleAction(Arguments var1) throws Exception;

    protected void validateOptions(Arguments arguments) {
        Collection<String> invalidOptions = arguments.findInvalidOptions(this.options.values());
        if (!invalidOptions.isEmpty()) {
            throw new IllegalArgumentException(NLS.getOption("invalidOptions", this.getActionName(), invalidOptions));
        }
        for (Option option : this.options.values()) {
            if (option.supportsParameters()) {
                this.validateParameterOption(arguments, option);
                continue;
            }
            this.validateSimpleOption(arguments, option);
        }
    }

    protected void validateSimpleOption(Arguments arguments, Option option) {
        String value = arguments.getOption(option);
        if (value == null) {
            return;
        }
        if (option.isValueRequired()) {
            if ("".equals(value)) {
                throw new IllegalArgumentException(NLS.getOption("missingValue", option.getName()));
            }
        } else if (!"".equals(value)) {
            throw new IllegalArgumentException(NLS.getOption("extraValue", option.getName()));
        }
    }

    protected void validateParameterOption(Arguments arguments, Option option) {
        Map<String, String> values = arguments.getParameterOption(option);
        if (values == null) {
            return;
        }
    }

    protected void validateArguments(Arguments arguments) throws TaskErrorException {
        List<String> requiredArguments = this.getActionArguments();
        if (requiredArguments == null || requiredArguments.isEmpty()) {
            return;
        }
        int requiredSize = requiredArguments.size();
        int specifiedSize = arguments.getPositionalArguments().size();
        if (specifiedSize < requiredSize) {
            throw new IllegalArgumentException(NLS.getOption("insufficientArgs", new Object[0]));
        }
    }

    public boolean getResponse(String promptString, String yes, String no, String defaultValue) {
        promptString = promptString + " ";
        String input = null;
        while (true) {
            if ((input = this.stdin.readText(promptString)).length() == 0) {
                if (defaultValue != null) {
                    input = defaultValue;
                } else {
                    if (yes.length() == 0) {
                        return true;
                    }
                    if (no.length() == 0) {
                        return false;
                    }
                }
            }
            if (input.length() != 1) continue;
            if (yes.indexOf(input.charAt(0)) > -1) {
                return true;
            }
            if (no.indexOf(input.charAt(0)) > -1) break;
        }
        return false;
    }

    public String getResponse(String promptString) {
        String input = null;
        while ((input = this.stdin.readText(promptString)) == null || input.trim().isEmpty()) {
        }
        return input;
    }
}

