/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.Invocation;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/mbeans/{objectName}/operations/{operation}"})
public class MBeanOperationHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(MBeanOperationHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    static final long serialVersionUID = -7011227460676555540L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (!RESTHelper.isPostMethod(method)) {
            throw new RESTHandlerMethodNotAllowedError("POST");
        }
        this.invocation(request, response);
    }

    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void invocation(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String operation = RESTHelper.getRequiredParam(request, "operation");
        InputStream is = RESTHelper.getInputStream(request);
        JSONConverter converter = JSONConverter.getConverter();
        Invocation invocation = null;
        try {
            invocation = converter.readInvocation(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, converter);
        Object pojo = MBeanServerHelper.invoke(objectNameObj, operation, invocation.params, invocation.signature, converter);
        OutputHelper.writePOJOOutput(response, pojo, converter);
    }
}

