/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.statemachine;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.ApplicationStateCoordinator;
import com.ibm.ws.app.manager.NotificationHelper;
import com.ibm.ws.app.manager.internal.ApplicationConfig;
import com.ibm.ws.app.manager.internal.ApplicationConfigurator;
import com.ibm.ws.app.manager.internal.ApplicationInstallInfo;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitor;
import com.ibm.ws.app.manager.internal.statemachine.Action;
import com.ibm.ws.app.manager.internal.statemachine.StateChangeCallback;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class StartAction
implements Action {
    private static final TraceComponent _tc = Tr.register(StartAction.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.statemachine.StartAction");
    private final ApplicationConfig _config;
    private final ApplicationInstallInfo _aii;
    private final AtomicReference<StateChangeCallback> _callback = new AtomicReference();
    private final FutureMonitor _monitor;
    private final AtomicLong _startTime = new AtomicLong();
    private final ApplicationMonitor _appMonitor;
    private final boolean _update;
    private volatile boolean cancelled = false;
    private final AtomicReference<Future<?>> _slowMessageAction = new AtomicReference();
    private final ApplicationConfigurator _configurator;
    private final CompletionListener<Boolean> _listener = new CompletionListener<Boolean>(){
        static final long serialVersionUID = 276196939532533882L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void successfulCompletion(Future<Boolean> future, Boolean result) {
            StateChangeCallback callback = StartAction.this._callback.getAndSet(null);
            if (callback != null) {
                StartAction.this.stopSlowStartMessage();
                if (result.booleanValue()) {
                    String key = StartAction.this._update ? "APPLICATION_UPDATE_SUCCESSFUL" : "APPLICATION_START_SUCCESSFUL";
                    NotificationHelper.broadcastChange(StartAction.this._config.getMBeanNotifier(), StartAction.this._config.getMBeanName(), StartAction.this._update ? "application.update" : "application.start", Boolean.TRUE, AppMessageHelper.get(StartAction.this._aii.getHandler()).formatMessage(key, StartAction.this._config.getName(), TimestampUtils.getElapsedTimeNanos((long)StartAction.this._startTime.get())));
                    AppMessageHelper.get(StartAction.this._aii.getHandler()).audit(key, StartAction.this._config.getName(), TimestampUtils.getElapsedTimeNanos((long)StartAction.this._startTime.get()));
                    StartAction.this._configurator.restoreMessage(() -> AppMessageHelper.get(StartAction.this._aii.getHandler()).audit(key, StartAction.this._config.getName(), TimestampUtils.getElapsedTime()));
                    callback.changed();
                } else {
                    if (!StartAction.this.cancelled) {
                        String key = StartAction.this._update ? "APPLICATION_NOT_UPDATED" : "APPLICATION_NOT_STARTED";
                        NotificationHelper.broadcastChange(StartAction.this._config.getMBeanNotifier(), StartAction.this._config.getMBeanName(), StartAction.this._update ? "application.update" : "application.start", Boolean.FALSE, AppMessageHelper.get(StartAction.this._aii.getHandler()).formatMessage(key, StartAction.this._config.getName()));
                        AppMessageHelper.get(StartAction.this._aii.getHandler()).audit(key, StartAction.this._config.getName());
                        StartAction.this._configurator.restoreMessage(() -> AppMessageHelper.get(StartAction.this._aii.getHandler()).audit(key, StartAction.this._config.getName()));
                    }
                    callback.failed(null);
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        }

        public void failedCompletion(Future<Boolean> future, Throwable t) {
            StateChangeCallback callback = StartAction.this._callback.getAndSet(null);
            if (callback != null) {
                StartAction.this.stopSlowStartMessage();
                String key = StartAction.this._update ? "APPLICATION_UPDATE_FAILED" : "APPLICATION_START_FAILED";
                NotificationHelper.broadcastChange(StartAction.this._config.getMBeanNotifier(), StartAction.this._config.getMBeanName(), StartAction.this._update ? "application.update" : "application.start", Boolean.FALSE, AppMessageHelper.get(StartAction.this._aii.getHandler()).formatMessage(key, StartAction.this._config.getName(), t.toString()));
                AppMessageHelper.get(StartAction.this._aii.getHandler()).error(key, StartAction.this._config.getName(), t.toString());
                StartAction.this._configurator.restoreMessage(() -> AppMessageHelper.get(StartAction.this._aii.getHandler()).error(key, StartAction.this._config.getName(), t.toString()));
                callback.failed(t);
            } else if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"attempted to reuse callback", (Object[])new Object[0]);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.statemachine.StartAction$1");
        }
    };
    static final long serialVersionUID = 8806718870402707757L;

    public StartAction(ApplicationConfig config, boolean update, ApplicationMonitor appMonitor, ApplicationInstallInfo appInstallInfo, StateChangeCallback scc, FutureMonitor fm, ApplicationConfigurator configurator) {
        this._config = config;
        this._aii = appInstallInfo;
        this._callback.set(scc);
        this._monitor = fm;
        this._appMonitor = appMonitor;
        this._update = update;
        this._configurator = configurator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(ExecutorService executor) {
        this._startTime.set(System.nanoTime());
        final ApplicationHandler<?> handler = this._aii.getHandler();
        if (handler == null) {
            this._listener.failedCompletion(null, (Throwable)new IllegalArgumentException("The application handler is not available"));
            return;
        }
        if (_tc.isInfoEnabled()) {
            AppMessageHelper.get(handler).info("STARTING_APPLICATION", this._config.getName());
        }
        long maxWait = ApplicationStateCoordinator.getApplicationStartTimeout();
        this._slowMessageAction.set(((ScheduledExecutorService)executor).schedule(new Runnable(){
            static final long serialVersionUID = 336861434535175113L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                AppMessageHelper.get(handler).audit("APPLICATION_SLOW_STARTUP", StartAction.this._config.getName(), TimestampUtils.getElapsedTimeNanos((long)StartAction.this._startTime.get()));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.statemachine.StartAction$2");
            }
        }, maxWait, TimeUnit.SECONDS));
        try {
            ApplicationMonitoringInformation ami = handler.setUpApplicationMonitoring(this._aii);
            this._aii.setApplicationMonitoringInformation(ami);
            this._appMonitor.addApplication(this._aii);
            Future<Boolean> result = handler.install(this._aii);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Handler install called, result: " + result), (Object[])new Object[0]);
            }
            this._monitor.onCompletion(result, this._listener);
        }
        catch (Throwable ami) {
            void t;
            FFDCFilter.processException((Throwable)ami, (String)"com.ibm.ws.app.manager.internal.statemachine.StartAction", (String)"167", (Object)this, (Object[])new Object[]{executor});
            this._listener.failedCompletion(null, (Throwable)t);
        }
    }

    private void stopSlowStartMessage() {
        Future slow = this._slowMessageAction.getAndSet(null);
        if (slow != null) {
            slow.cancel(false);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.stopSlowStartMessage();
    }

    @Override
    public void resetStartTime() {
        this._startTime.set(System.nanoTime());
    }
}

