/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

public final class NotificationTargetInformation {
    private ObjectName name;
    private final String nameAsString;
    private final Map<String, Object> routingInfo;

    public NotificationTargetInformation(ObjectName name) {
        this(name.getCanonicalName());
        this.name = name;
    }

    public NotificationTargetInformation(String name) {
        this.nameAsString = name;
        this.routingInfo = null;
    }

    public NotificationTargetInformation(ObjectName name, String hostName, String serverName, String serverUserDir) {
        this(name.getCanonicalName(), hostName, serverName, serverUserDir);
        this.name = name;
    }

    public NotificationTargetInformation(String name, String hostName, String serverName, String serverUserDir) {
        HashMap<String, String> routingInfo = new HashMap<String, String>();
        routingInfo.put("com.ibm.websphere.jmx.connector.rest.routing.hostName", hostName);
        routingInfo.put("com.ibm.websphere.jmx.connector.rest.routing.serverName", serverName);
        routingInfo.put("com.ibm.websphere.jmx.connector.rest.routing.serverUserDir", serverUserDir);
        this.nameAsString = name;
        this.routingInfo = Collections.unmodifiableMap(routingInfo);
    }

    public NotificationTargetInformation(ObjectName name, Map<String, Object> routingInfo) {
        this(name.getCanonicalName(), routingInfo);
        this.name = name;
    }

    public NotificationTargetInformation(String name, Map<String, Object> routingInfo) {
        this.nameAsString = name;
        this.routingInfo = routingInfo != null ? Collections.unmodifiableMap(new HashMap<String, Object>(routingInfo)) : null;
    }

    public ObjectName getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.nameAsString;
    }

    public Map<String, Object> getRoutingInformation() {
        return this.routingInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NotificationTargetInformation)) {
            return false;
        }
        NotificationTargetInformation other = (NotificationTargetInformation)obj;
        return (this.nameAsString == other.nameAsString || this.nameAsString != null && this.nameAsString.equals(other.nameAsString)) && (this.routingInfo == other.routingInfo || this.routingInfo != null && this.routingInfo.equals(other.routingInfo));
    }

    public int hashCode() {
        if (this.routingInfo != null) {
            int hash = this.routingInfo.hashCode() * 37;
            if (this.nameAsString != null) {
                hash += this.nameAsString.hashCode();
            }
            return hash;
        }
        if (this.nameAsString != null) {
            return this.nameAsString.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ObjectName: ");
        sb.append(this.nameAsString);
        if (this.routingInfo != null) {
            sb.append(", RoutingInfo: ");
            sb.append(this.routingInfo);
        }
        sb.append(']');
        return sb.toString();
    }
}

