/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.internal.WorkProxy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class WorkManagerImpl
implements WorkManager {
    private static final TraceComponent tc = Tr.register(WorkManagerImpl.class);
    private static final int FUTURE_PURGE_INTERVAL = 20;
    private final BootstrapContextImpl bootstrapContext;
    private final ConcurrentLinkedQueue<Future<Void>> futures = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Work> runningWork = new ConcurrentLinkedQueue();
    private volatile boolean stopped;
    static final long serialVersionUID = 7636364744695828632L;

    public WorkManagerImpl(BootstrapContextImpl bootstrapContext) {
        this.bootstrapContext = bootstrapContext;
    }

    @Trivial
    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        try {
            this.beforeRunCheck(work, workListener, startTimeout);
            new WorkProxy(work, startTimeout, execContext, workListener, this.bootstrapContext, this.runningWork, false).call();
        }
        catch (WorkException workException) {
            void ex;
            FFDCFilter.processException((Throwable)workException, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"114", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            throw ex;
        }
        catch (Throwable ex) {
            void t;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"116", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            WorkRejectedException wrex = new WorkRejectedException((Throwable)t);
            wrex.setErrorCode("-1");
            if (workListener != null) {
                workListener.workRejected(new WorkEvent((Object)work, 2, work, (WorkException)wrex));
            }
            throw wrex;
        }
    }

    @Trivial
    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        try {
            Long startupDuration;
            this.beforeRunCheck(work, workListener, startTimeout);
            WorkProxy workProxy = new WorkProxy(work, startTimeout, execContext, workListener, this.bootstrapContext, this.runningWork, true);
            FutureTask<Void> futureTask = new FutureTask<Void>(workProxy);
            this.bootstrapContext.execSvc.executeGlobal(futureTask);
            if (this.futures.add(futureTask) && this.futures.size() % 20 == 0) {
                this.purgeFutures();
            }
            if ((startupDuration = workProxy.waitForStart()) == null) {
                futureTask.cancel(true);
                WorkRejectedException wrex = new WorkRejectedException(Utils.getMessage("J2CA8600.work.start.timeout", work, this.bootstrapContext.resourceAdapterID, startTimeout), "1");
                if (workListener != null) {
                    workListener.workRejected(new WorkEvent((Object)work, 2, work, (WorkException)wrex));
                }
                throw wrex;
            }
            if (futureTask.isDone()) {
                try {
                    futureTask.get();
                }
                catch (ExecutionException wrex) {
                    void x;
                    FFDCFilter.processException((Throwable)wrex, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"189", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
                    throw x.getCause();
                }
            }
            return startupDuration;
        }
        catch (WorkException workProxy) {
            void ex;
            FFDCFilter.processException((Throwable)workProxy, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"195", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            throw ex;
        }
        catch (Throwable ex) {
            void t;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"197", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            WorkRejectedException wrex = new WorkRejectedException((Throwable)t);
            wrex.setErrorCode("-1");
            if (workListener != null) {
                workListener.workRejected(new WorkEvent((Object)work, 2, work, (WorkException)wrex));
            }
            throw wrex;
        }
    }

    @Trivial
    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        try {
            this.beforeRunCheck(work, workListener, startTimeout);
            WorkProxy workProxy = new WorkProxy(work, startTimeout, execContext, workListener, this.bootstrapContext, this.runningWork, true);
            FutureTask<Void> futureTask = new FutureTask<Void>(workProxy);
            this.bootstrapContext.execSvc.executeGlobal(futureTask);
            if (this.futures.add(futureTask) && this.futures.size() % 20 == 0) {
                this.purgeFutures();
            }
        }
        catch (WorkException workProxy) {
            void ex;
            FFDCFilter.processException((Throwable)workProxy, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"254", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            throw ex;
        }
        catch (Throwable ex) {
            void t;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jca.internal.WorkManagerImpl", (String)"256", (Object)this, (Object[])new Object[]{work, startTimeout, execContext, workListener});
            WorkRejectedException wrex = new WorkRejectedException((Throwable)t);
            wrex.setErrorCode("-1");
            if (workListener != null) {
                workListener.workRejected(new WorkEvent((Object)work, 2, work, (WorkException)wrex));
            }
            throw wrex;
        }
    }

    @Trivial
    private void beforeRunCheck(Work work, WorkListener workListener, long startTimeout) throws WorkRejectedException {
        WorkRejectedException wrex = null;
        if (work == null) {
            wrex = new WorkRejectedException((Throwable)new NullPointerException("work"));
            wrex.setErrorCode("0");
        } else if (startTimeout < 0L) {
            wrex = new WorkRejectedException("startTimeout=" + startTimeout, "1");
        } else if (this.stopped) {
            wrex = new WorkRejectedException((Throwable)new UnavailableException(this.bootstrapContext.resourceAdapterID));
        }
        if (wrex != null) {
            if (workListener != null) {
                WorkEvent event = new WorkEvent((Object)(work == null ? this : work), 2, work, (WorkException)wrex);
                workListener.workRejected(event);
            }
            throw wrex;
        }
    }

    @Trivial
    private final void purgeFutures() {
        Iterator<Future<Void>> it = this.futures.iterator();
        while (it.hasNext()) {
            if (!it.next().isDone()) continue;
            it.remove();
        }
    }

    public void stop() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.stopped = true;
        Future<Void> future = this.futures.poll();
        while (future != null) {
            if (!future.isDone() && future.cancel(true) && trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"canceled", (Object[])new Object[]{future});
            }
            future = this.futures.poll();
        }
        Work work = this.runningWork.poll();
        while (work != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"release", (Object[])new Object[]{work});
            }
            work.release();
            work = this.runningWork.poll();
        }
    }
}

