/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.ClassProvider;
import com.ibm.ws.classloading.LibertyClassLoader;
import com.ibm.ws.jca.internal.DeferredService;
import com.ibm.ws.jca.internal.ResourceAdapterMetaData;
import com.ibm.ws.jca.rar.ResourceAdapterBundleService;
import com.ibm.ws.jca.utils.xml.metatype.Metatype;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceAdapterService
extends DeferredService
implements ClassProvider,
MetaTypeProvider {
    private static final TraceComponent tc = Tr.register(ResourceAdapterService.class);
    private ClassLoader classloader;
    private ClassLoadingService classloadingSvc;
    private volatile String id;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private ClassLoaderIdentity rarClassLoaderId;
    private String rarFilePath;
    private volatile BundleContext bundleContext;
    private Bundle bundle;
    private ArtifactContainerFactory _acf;
    private AdaptableModuleFactory _amf;
    private Metatype metatype;
    private ResourceAdapterMetaData ramd;
    private ResourceAdapterBundleService raBundleSvc;
    static final long serialVersionUID = -5101901714633873532L;

    @ManualTrace
    protected void activate(ComponentContext context) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context.getProperties()});
        }
        this.id = (String)context.getProperties().get("id");
        this.rarFilePath = (String)context.getProperties().get("location");
        this.bundleContext = PrivHelper.getBundleContext((ComponentContext)context);
        this.bundle = this.bundleContext.getBundle();
        this.getClassLoader();
        this.raBundleSvc.setClassLoaderID(this.rarClassLoaderId);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"activate");
        }
    }

    protected void deactivate(ComponentContext context) throws BundleException {
        this.deregisterDeferredService();
    }

    public boolean rarFileExists() {
        final File zipFile = new File(this.rarFilePath);
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 4974525191203323783L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return zipFile.exists();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public ClassLoader getClassLoader() {
        this.lock.readLock().lock();
        try {
            if (this.classloader != null) {
                ClassLoader classLoader = this.classloader;
                return classLoader;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (!this.rarFileExists()) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            if (this.classloader == null) {
                this.classloader = this.createRarClassLoader();
            }
            ClassLoader classLoader = this.classloader;
            return classLoader;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ClassLoader createRarClassLoader() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        File bundleWorkareaRoot = this.bundle.getDataFile("");
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("bundleWorkareaRoot " + bundleWorkareaRoot), (Object[])new Object[0]);
        }
        final Bundle theBundle = this.bundle;
        File[] cacheFiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){
            static final long serialVersionUID = -3561484488384833396L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public File[] run() {
                return theBundle.getDataFile("").listFiles();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        String cacheSuffix = "-.-." + this.id + "--.-";
        String cacheSuffixMod = cacheSuffix + Long.valueOf(FileUtils.fileLastModified((File)new File(this.rarFilePath))).toString();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("cacheSuffixMod " + cacheSuffixMod), (Object[])new Object[0]);
        }
        for (File f : cacheFiles) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("bundle file path: " + f.getPath()), (Object[])new Object[0]);
            }
            if (f.getPath().contains(cacheSuffixMod)) {
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"This is a good cache dir for the rar file, keep it", (Object[])new Object[0]);
                continue;
            }
            if (f.getPath().contains(cacheSuffix)) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("This is a cache dir for " + cacheSuffix + " but the modification date is not a match, delete it"), (Object[])new Object[0]);
                }
                if (this.deleteBundleCacheDir(f) || !trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Delete failed for ", (Object[])new Object[]{f, " check previous debug messages"});
                continue;
            }
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("This is NOT a cache dir for " + cacheSuffix + " leave it alone"), (Object[])new Object[0]);
        }
        File rarCacheDir = this.bundle.getDataFile("rarCache" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarCacheDir " + rarCacheDir), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarCacheDir) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache failed!!!", (Object[])new Object[0]);
        }
        File rarOverlayDirectory = this.bundle.getDataFile("rarOverlayDirectory" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarOverlayDirectory " + rarOverlayDirectory), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarOverlayDirectory) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Overlay failed!!!", (Object[])new Object[0]);
        }
        File rarCacheDirForOverlayContent = this.bundle.getDataFile("rarCacheDirForOverlayContent" + cacheSuffixMod);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getDataFile rarCacheDirForOverlayContent " + rarCacheDirForOverlayContent), (Object[])new Object[0]);
        }
        if (!FileUtils.ensureDirExists((File)rarCacheDirForOverlayContent) && trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Cache for overlay failed!!!", (Object[])new Object[0]);
        }
        ArtifactContainer c = null;
        ArrayList<ArtifactContainer> rarContainers = new ArrayList<ArtifactContainer>();
        c = this._acf.getContainer(rarCacheDir, (Object)new File(this.rarFilePath));
        rarContainers.add(c);
        for (ArtifactEntry ae : c) {
            if (!ae.getPath().toLowerCase().endsWith(".jar")) continue;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Artifact entry [ " + ae.getPath() + " ]"), (Object[])new Object[0]);
            }
            ArtifactContainer jarEntry = ae.convertToContainer();
            rarContainers.add(jarEntry);
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Jar entry [ " + jarEntry.getPath() + " ]"), (Object[])new Object[0]);
        }
        ArrayList<Container> classLoaderContainers = new ArrayList<Container>();
        for (ArtifactContainer ac : rarContainers) {
            classLoaderContainers.add(this._amf.getContainer(rarOverlayDirectory, rarCacheDirForOverlayContent, ac));
        }
        GatewayConfiguration gwCfg = this.classloadingSvc.createGatewayConfiguration().setApiTypeVisibility(new ApiType[]{ApiType.SPEC, ApiType.API, ApiType.IBMAPI, ApiType.THIRDPARTY}).setDynamicImportPackage(new String[]{"*"}).setDelegateToSystem(true);
        this.rarClassLoaderId = this.classloadingSvc.createIdentity("Resource Adapter", this.id);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Resource adapter [ " + this.rarFilePath + " ]: Class loader ID [ " + this.rarClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderConfiguration clCfg = this.classloadingSvc.createClassLoaderConfiguration().setId(this.rarClassLoaderId);
        ClassLoader rarClassLoader = this.classloadingSvc.createTopLevelClassLoader(classLoaderContainers, gwCfg, clCfg);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Resource adapter [ " + this.rarFilePath + " ]: Class loader [ " + rarClassLoader + " ]"), (Object[])new Object[0]);
        }
        return rarClassLoader;
    }

    private boolean deleteBundleCacheDir(File path) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (FileUtils.fileExists((File)path)) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Path specified exists: " + path.getPath()), (Object[])new Object[0]);
            }
        } else {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Path specified does not exist: " + path.getPath()), (Object[])new Object[0]);
            }
            return true;
        }
        boolean deleteWorked = true;
        for (File file : FileUtils.listFiles((File)path)) {
            if (FileUtils.fileIsDirectory((File)file)) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete directory contents: " + file.toString()), (Object[])new Object[0]);
                }
                deleteWorked &= this.deleteBundleCacheDir(file);
                continue;
            }
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete file: " + file.toString()), (Object[])new Object[0]);
            }
            if (FileUtils.fileDelete((File)file)) continue;
            deleteWorked = false;
            if (!trace || !tc.isDebugEnabled()) continue;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Directory or file not deleted", (Object[])new Object[0]);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Delete path: " + path), (Object[])new Object[0]);
        }
        if (!FileUtils.fileDelete((File)path)) {
            deleteWorked = false;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Path not deleted", (Object[])new Object[0]);
            }
        }
        return deleteWorked;
    }

    public LibertyClassLoader getDelegateLoader() {
        return (LibertyClassLoader)this.classloader;
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        if (this.metatype != null) {
            return this.metatype.getOcdById(pid).getObjectClassDefinition();
        }
        return null;
    }

    protected void setClassLoadingService(ClassLoadingService svc) {
        this.classloadingSvc = svc;
    }

    void setMetatype(Metatype metatype) {
        this.metatype = metatype;
    }

    protected void unsetClassLoadingService(ClassLoadingService svc) {
        this.classloadingSvc = null;
    }

    protected void setArtifactContainerFactory(ArtifactContainerFactory svc) {
        this._acf = svc;
    }

    protected void unsetArtifactContainerFactory(ArtifactContainerFactory svc) {
        if (svc == this._acf) {
            this._acf = null;
        }
    }

    protected void setAdaptableModuleFactory(AdaptableModuleFactory svc) {
        this._amf = svc;
    }

    protected void unsetAdaptableModuleFactory(AdaptableModuleFactory svc) {
        if (svc == this._amf) {
            this._amf = null;
        }
    }

    protected void setResourceAdapterBundleService(ResourceAdapterBundleService svc) {
        this.raBundleSvc = svc;
    }

    protected void unsetResourceAdapterBundleService(ResourceAdapterBundleService svc) {
        if (svc == this.raBundleSvc) {
            this.raBundleSvc = null;
        }
    }

    protected void setClassLoader(ClassLoader cl) {
        this.classloader = cl;
    }

    public ResourceAdapterMetaData getResourceAdapterMetaData() {
        return this.ramd;
    }

    public void setResourceAdapterMetaData(ResourceAdapterMetaData ramd) {
        this.ramd = ramd;
    }
}

