/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBeanIdentifier;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class ManagedBean<T>
extends AbstractClassBean<T> {
    private final boolean proxiable;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;
    private boolean hasPostConstructCallback;

    public static <T> ManagedBean<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> clazz, BeanManagerImpl beanManager) {
        return new ManagedBean<T>(attributes, clazz, ManagedBean.createId(attributes, clazz), beanManager);
    }

    private static BeanIdentifier createId(BeanAttributes<?> attributes, EnhancedAnnotatedType<?> clazz) {
        if (Dependent.class.equals((Object)attributes.getScope()) || ApplicationScoped.class.equals((Object)attributes.getScope())) {
            return new ManagedBeanIdentifier((AnnotatedTypeIdentifier)clazz.slim().getIdentifier());
        }
        return new StringBeanIdentifier(BeanIdentifiers.forManagedBean(clazz));
    }

    protected ManagedBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, BeanIdentifier identifier, BeanManagerImpl beanManager) {
        super(attributes, type, identifier, beanManager);
        this.proxiable = Proxies.isTypesProxyable(this.getTypes(), beanManager.getServices());
        this.setProducer(beanManager.getLocalInjectionTargetFactory(this.getEnhancedAnnotated()).createInjectionTarget(this.getEnhancedAnnotated(), this, false));
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.initPassivationCapable();
    }

    private void initPassivationCapable() {
        this.passivationCapableBean = this.getEnhancedAnnotated().isSerializable();
        this.passivationCapableDependency = this.isNormalScoped() || this.isDependent() && this.passivationCapableBean;
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        if (this.passivationCapableBean && this.hasDecorators() && !this.allDecoratorsArePassivationCapable()) {
            this.passivationCapableBean = false;
        }
        if (this.passivationCapableBean && this.hasInterceptors() && !this.allInterceptorsArePassivationCapable()) {
            this.passivationCapableBean = false;
        }
        super.initializeAfterBeanDiscovery();
    }

    private boolean allDecoratorsArePassivationCapable() {
        return this.getFirstNonPassivationCapableDecorator() == null;
    }

    private Decorator<?> getFirstNonPassivationCapableDecorator() {
        for (Decorator<?> decorator : this.getDecorators()) {
            if (Decorators.isPassivationCapable(decorator)) continue;
            return decorator;
        }
        return null;
    }

    private boolean allInterceptorsArePassivationCapable() {
        return this.getFirstNonPassivationCapableInterceptor() == null;
    }

    private InterceptorClassMetadata<?> getFirstNonPassivationCapableInterceptor() {
        for (InterceptorClassMetadata<?> interceptorMetadata : ((InterceptionModel)this.getBeanManager().getInterceptorModelRegistry().get(this.getAnnotated())).getAllInterceptors()) {
            if (Reflections.isSerializable(interceptorMetadata.getJavaClass())) continue;
            return interceptorMetadata;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create(CreationalContext<T> creationalContext) {
        Object instance = this.getProducer().produce(creationalContext);
        this.getProducer().inject(instance, creationalContext);
        if (!this.hasPostConstructCallback || this.beanManager.isContextActive(RequestScoped.class)) {
            this.getProducer().postConstruct(instance);
        } else {
            RequestContext context = this.getUnboundRequestContext();
            try {
                context.activate();
                this.getProducer().postConstruct(instance);
            }
            finally {
                context.invalidate();
                context.deactivate();
            }
        }
        return (T)instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        super.destroy(instance, creationalContext);
        try {
            this.getProducer().preDestroy(instance);
            if (creationalContext instanceof CreationalContextImpl) {
                ((CreationalContextImpl)creationalContext).release(this, instance);
            } else {
                creationalContext.release();
            }
        }
        catch (Exception e) {
            BeanLogger.LOG.errorDestroying(instance, this);
            BeanLogger.LOG.catchingDebug(e);
        }
    }

    @Override
    protected void checkType() {
        if (!this.isDependent() && this.getEnhancedAnnotated().isParameterizedType()) {
            throw BeanLogger.LOG.managedBeanWithParameterizedBeanClassMustBeDependent(this.type);
        }
        boolean passivating = this.beanManager.isPassivatingScope(this.getScope());
        if (passivating && !this.isPassivationCapableBean()) {
            if (!this.getEnhancedAnnotated().isSerializable()) {
                throw BeanLogger.LOG.passivatingBeanNeedsSerializableImpl(this);
            }
            if (this.hasDecorators() && !this.allDecoratorsArePassivationCapable()) {
                throw BeanLogger.LOG.passivatingBeanHasNonPassivationCapableDecorator(this, this.getFirstNonPassivationCapableDecorator());
            }
            if (this.hasInterceptors() && !this.allInterceptorsArePassivationCapable()) {
                throw BeanLogger.LOG.passivatingBeanHasNonPassivationCapableInterceptor(this, this.getFirstNonPassivationCapableInterceptor());
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (this.isNormalScoped()) {
            for (EnhancedAnnotatedField field : this.getEnhancedAnnotated().getEnhancedFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw BeanLogger.LOG.publicFieldOnNormalScopedBeanNotAllowed(field);
            }
        }
    }

    @Override
    protected void specialize() {
        Set<AbstractBean<?, ?>> specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw BeanLogger.LOG.specializingBeanMustExtendABean(this);
        }
        for (AbstractBean<?, ?> specializedBean : specializedBeans) {
            if (specializedBean instanceof ManagedBean) continue;
            throw BeanLogger.LOG.specializingManagedBeanCanExtendOnlyManagedBeans(this, specializedBean);
        }
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return !(this instanceof InterceptorImpl) && !(this instanceof DecoratorImpl);
    }

    @Override
    public String toString() {
        return "Managed Bean [" + this.getBeanClass().toString() + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    private RequestContext getUnboundRequestContext() {
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans((Type)((Object)RequestContext.class), UnboundLiteral.INSTANCE));
        WeldCreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (RequestContext)this.beanManager.getReference(bean, (Type)((Object)RequestContext.class), (CreationalContext<?>)ctx);
    }

    @Override
    public void setProducer(InjectionTarget<T> producer) {
        super.setProducer(producer);
        this.hasPostConstructCallback = this.initHasPostConstructCallback(producer);
    }

    private boolean initHasPostConstructCallback(InjectionTarget<T> producer) {
        if (producer instanceof BasicInjectionTarget) {
            BasicInjectionTarget weldProducer = (BasicInjectionTarget)producer;
            InterceptionModel interceptors = this.getInterceptors();
            if ((interceptors == null || interceptors.getInterceptors(InterceptionType.POST_CONSTRUCT, null).isEmpty()) && !weldProducer.getLifecycleCallbackInvoker().hasPostConstructMethods()) {
                return false;
            }
        }
        return true;
    }
}

