/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.authentication.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.MessagingSecurityConstants;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationService;
import com.ibm.ws.messaging.security.authentication.actions.MessagingLoginAction;
import com.ibm.ws.messaging.security.internal.MessagingSecurityServiceImpl;
import com.ibm.ws.messaging.security.utility.MessagingSecurityUtility;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.security.cert.Certificate;
import javax.security.auth.Subject;

public class MessagingAuthenticationServiceImpl
implements MessagingAuthenticationService,
MessagingSecurityConstants {
    private static TraceComponent tc = SibTr.register(MessagingAuthenticationServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpl";
    private MessagingSecurityServiceImpl _messagingSecurityService = null;
    private final AuthenticationData authenticationDataForSubject = new WSAuthenticationData();

    public MessagingAuthenticationServiceImpl(MessagingSecurityServiceImpl messagingSecurityService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImplconstructor", (Object)messagingSecurityService);
        }
        this._messagingSecurityService = messagingSecurityService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImplconstructor");
        }
    }

    public Subject login(Subject subj) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)subj);
        }
        Subject result = null;
        result = AccessController.doPrivileged(new MessagingLoginAction(this.authenticationDataForSubject, "SUBJECT", this._messagingSecurityService.getSecurityService(), subj));
        if (result == null) {
            String userName = null;
            try {
                userName = this._messagingSecurityService.getUniqueUserName(subj);
            }
            catch (MessagingSecurityException messagingSecurityException) {
                // empty catch block
            }
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)result);
        }
        return result;
    }

    public Subject login(String userName, String password) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)new Object[]{userName, "Password Not Traced"});
        }
        Subject result = null;
        AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(userName, password);
        result = AccessController.doPrivileged(new MessagingLoginAction(authData, "USERID", this._messagingSecurityService.getSecurityService()));
        if (result == null) {
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)result);
        }
        return result;
    }

    public Subject login(byte[] securityToken, String securityTokenType) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)new Object[]{securityToken, securityTokenType});
        }
        Subject result = null;
        boolean doLogin = "LTPA".equals(securityTokenType);
        if (doLogin) {
            AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(securityToken);
            result = AccessController.doPrivileged(new MessagingLoginAction(authData, "LTPA", this._messagingSecurityService.getSecurityService()));
            if (result == null) {
                String userName = null;
                try {
                    userName = this._messagingSecurityService.getUniqueUserName(result);
                }
                catch (MessagingSecurityException messagingSecurityException) {
                    // empty catch block
                }
                this.throwAuthenticationException(userName);
            }
        } else {
            SibTr.error((TraceComponent)tc, (String)"SECURITY_TOKEN_TYPE_NOT_SUPPORTED_MSE1002", (Object)securityTokenType);
            result = null;
            throw new MessagingAuthenticationException(Tr.formatMessage((TraceComponent)tc, (String)"SECURITY_TOKEN_TYPE_NOT_SUPPORTED_MSE1002", (Object[])new Object[0]));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)result);
        }
        return result;
    }

    public Subject login(String userName) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)userName);
        }
        Subject result = null;
        AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(userName, this._messagingSecurityService.getUserRegistry());
        result = AccessController.doPrivileged(new MessagingLoginAction(authData, "IDASSERTION", this._messagingSecurityService.getSecurityService()));
        if (result == null) {
            this.throwAuthenticationException(userName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)result);
        }
        return result;
    }

    public Subject login(Certificate[] certificates) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", (Object)certificates);
        }
        Subject result = null;
        if (certificates == null) {
            result = null;
        } else {
            AuthenticationData authData = MessagingSecurityUtility.createAuthenticationData(certificates, this._messagingSecurityService.getUserRegistry());
            result = AccessController.doPrivileged(new MessagingLoginAction(authData, "CLIENTSSL", this._messagingSecurityService.getSecurityService()));
            if (result == null) {
                String userName = null;
                try {
                    userName = this._messagingSecurityService.getUniqueUserName(result);
                }
                catch (MessagingSecurityException messagingSecurityException) {
                    // empty catch block
                }
                this.throwAuthenticationException(userName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogin", result);
        }
        return result;
    }

    public void logout(Subject subj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogout", (Object)subj);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.authentication.internal.MessagingAuthenticationServiceImpllogout");
        }
    }

    private void throwAuthenticationException(String userName) throws MessagingAuthenticationException {
        throw new MessagingAuthenticationException(Tr.formatMessage((TraceComponent)tc, (String)"USER_NOT_AUTHENTICATED_MSE1009", (Object[])new Object[]{userName}));
    }
}

