/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletContext;
import org.apache.myfaces.cdi.dependent.BeanEntry;
import org.apache.myfaces.config.FacesConfigValidator;
import org.apache.myfaces.config.FacesConfigurator;
import org.apache.myfaces.config.ManagedBeanBuilder;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.StartupFacesContextImpl;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.shared.context.ExceptionHandlerImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.StateUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.ViewScopeProviderFactory;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.ViewPoolProcessor;
import org.apache.myfaces.view.facelets.tag.MetaRulesetImpl;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.ManagedBeanDestroyerListener;
import org.apache.myfaces.webapp.WebConfigParamsLogger;

public abstract class AbstractFacesInitializer
implements FacesInitializer {
    private static final Logger log = Logger.getLogger(AbstractFacesInitializer.class.getName());
    private static final String FACES_SERVLET_ADDED_ATTRIBUTE = "org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET";
    protected static final String EXPRESSION_FACTORY = "org.apache.myfaces.EXPRESSION_FACTORY";
    protected static final String INITIALIZE_ALWAYS_STANDALONE = "org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE";
    public static final String INIT_PARAM_LOG_WEB_CONTEXT_PARAMS = "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS";
    public static final String INIT_PARAM_LOG_WEB_CONTEXT_PARAMS_DEFAULT = "auto";
    public static final String CDI_BEAN_MANAGER_INSTANCE = "oam.cdi.BEAN_MANAGER_INSTANCE";
    private static final String CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE = "javax.enterprise.inject.spi.BeanManager";
    private static final String INJECTED_BEAN_STORAGE_KEY = "org.apache.myfaces.spi.BEAN_ENTRY_STORAGE";

    @Override
    public void initFaces(ServletContext servletContext) {
        try {
            FacesContext facesContext;
            ExternalContext externalContext;
            ServiceProviderFinder spf;
            Map<String, List<String>> spfConfig;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Initializing MyFaces");
            }
            if ((spfConfig = (spf = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext = (facesContext = FacesContext.getCurrentInstance()).getExternalContext())).calculateKnownServiceProviderMapInfo(externalContext, ServiceProviderFinder.KNOWN_SERVICES)) != null) {
                spf.initKnownServiceProviderMapInfo(externalContext, spfConfig);
            }
            this.initCDIIntegration(servletContext, externalContext);
            this.initContainerIntegration(servletContext, externalContext);
            ViewScopeProviderFactory factory = ViewScopeProviderFactory.getViewScopeHandlerFactory(externalContext);
            ViewScopeProvider viewScopeHandler = factory.getViewScopeHandler(externalContext);
            ManagedBeanDestroyerListener listener = (ManagedBeanDestroyerListener)externalContext.getApplicationMap().get("org.apache.myfaces.ManagedBeanDestroyerListener");
            listener.setViewScopeHandler(viewScopeHandler);
            String useEncryption = servletContext.getInitParameter("org.apache.myfaces.USE_ENCRYPTION");
            if (!"false".equals(useEncryption)) {
                StateUtils.initSecret(servletContext);
            }
            this._createEagerBeans(facesContext);
            this._dispatchApplicationEvent(servletContext, PostConstructApplicationEvent.class);
            if ((facesContext.isProjectStage(ProjectStage.Development) || facesContext.isProjectStage(ProjectStage.Production)) && log.isLoggable(Level.INFO)) {
                log.info("ServletContext initialized.");
            }
            WebConfigParamsLogger.logWebContextParams(facesContext);
            ExternalSpecifications.isUnifiedELAvailable();
            ExternalSpecifications.isBeanValidationAvailable();
            ViewPoolProcessor.initialize(facesContext);
            if (!facesContext.isProjectStage(ProjectStage.Production) && !facesContext.isProjectStage(ProjectStage.UnitTest)) {
                int i;
                ProjectStage projectStage = facesContext.getApplication().getProjectStage();
                StringBuilder message = new StringBuilder("\n\n");
                message.append("*******************************************************************\n");
                message.append("*** WARNING: Apache MyFaces-2 is running in ");
                message.append(projectStage.name().toUpperCase());
                message.append(" mode.");
                int length = projectStage.name().length();
                for (i = 0; i < 11 - length; ++i) {
                    message.append(" ");
                }
                message.append("   ***\n");
                message.append("***                                         ");
                for (i = 0; i < length; ++i) {
                    message.append("^");
                }
                for (i = 0; i < 20 - length; ++i) {
                    message.append(" ");
                }
                message.append("***\n");
                message.append("*** Do NOT deploy to your live server(s) without changing this. ***\n");
                message.append("*** See Application#getProjectStage() for more information.     ***\n");
                message.append("*******************************************************************\n");
                log.log(Level.WARNING, message.toString());
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "An error occured while initializing MyFaces: " + ex.getMessage(), ex);
        }
    }

    private void _createEagerBeans(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        ArrayList<ManagedBean> eagerBeans = new ArrayList<ManagedBean>();
        for (ManagedBean bean : runtimeConfig.getManagedBeans().values()) {
            String eager = bean.getEager();
            if (eager == null || !"true".equals(eager)) continue;
            if ("application".equals(bean.getManagedBeanScope())) {
                eagerBeans.add(bean);
                continue;
            }
            log.log(Level.WARNING, "The managed-bean with name " + bean.getManagedBeanName() + " must be application scoped to support eager=true.");
        }
        if (!eagerBeans.isEmpty()) {
            ManagedBeanBuilder managedBeanBuilder = new ManagedBeanBuilder();
            Map applicationMap = externalContext.getApplicationMap();
            for (ManagedBean bean : eagerBeans) {
                if (applicationMap.containsKey(bean.getManagedBeanName())) continue;
                Object beanInstance = managedBeanBuilder.buildManagedBean(facesContext, bean);
                applicationMap.put(bean.getManagedBeanName(), beanInstance);
            }
        }
    }

    private void _dispatchApplicationEvent(ServletContext servletContext, Class<? extends SystemEvent> eventClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        application.publishEvent(facesContext, eventClass, Application.class, (Object)application);
    }

    @Override
    public void destroyFaces(ServletContext servletContext) {
        Boolean mappingAdded;
        WebConfigProvider webConfigProvider;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!(WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INITIALIZE_ALWAYS_STANDALONE, false) || !(webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext())).getFacesServletMappings(facesContext.getExternalContext()).isEmpty() || (mappingAdded = (Boolean)servletContext.getAttribute(FACES_SERVLET_ADDED_ATTRIBUTE)) != null && mappingAdded.booleanValue())) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("No mappings of FacesServlet found. Abort destroy MyFaces.");
            }
            return;
        }
        this._dispatchApplicationEvent(servletContext, PreDestroyApplicationEvent.class);
        this._callPreDestroyOnInjectedJSFArtifacts(facesContext);
        MetaRulesetImpl.clearMetadataTargetCache();
        try {
            Class<?> c = Class.forName("javax.faces.component.UIViewParameter");
            Method m = c.getDeclaredMethod("releaseRenderer", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected RuntimeConfig buildConfiguration(ServletContext servletContext, ExternalContext externalContext, ExpressionFactory expressionFactory) {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        runtimeConfig.setExpressionFactory(expressionFactory);
        new FacesConfigurator(externalContext).configure();
        this.validateFacesConfig(servletContext, externalContext);
        return runtimeConfig;
    }

    protected void validateFacesConfig(ServletContext servletContext, ExternalContext externalContext) {
        String validate = servletContext.getInitParameter("org.apache.myfaces.VALIDATE");
        if ("true".equals(validate) && log.isLoggable(Level.WARNING)) {
            List<String> warnings = FacesConfigValidator.validate(externalContext);
            for (String warning : warnings) {
                log.warning(warning);
            }
        }
    }

    protected static ExpressionFactory getUserDefinedExpressionFactory(ExternalContext externalContext) {
        String expressionFactoryClassName = WebConfigParamUtils.getStringInitParameter(externalContext, EXPRESSION_FACTORY);
        if (expressionFactoryClassName != null && expressionFactoryClassName.trim().length() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Attempting to load the ExpressionFactory implementation you've specified: '" + expressionFactoryClassName + "'.");
            }
            return AbstractFacesInitializer.loadExpressionFactory(expressionFactoryClassName);
        }
        return null;
    }

    protected static ExpressionFactory loadExpressionFactory(String expressionFactoryClassName) {
        try {
            Class<?> expressionFactoryClass = Class.forName(expressionFactoryClassName);
            return (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "An error occured while instantiating a new ExpressionFactory. Attempted to load class '" + expressionFactoryClassName + "'.", ex);
            }
            return null;
        }
    }

    @Override
    public FacesContext initStartupFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, true);
    }

    @Override
    public void destroyStartupFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    @Override
    public FacesContext initShutdownFacesContext(ServletContext servletContext) {
        return this._createFacesContext(servletContext, false);
    }

    @Override
    public void destroyShutdownFacesContext(FacesContext facesContext) {
        this._releaseFacesContext(facesContext);
    }

    private FacesContext _createFacesContext(ServletContext servletContext, boolean startup) {
        StartupServletExternalContextImpl externalContext = new StartupServletExternalContextImpl(servletContext, startup);
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl();
        StartupFacesContextImpl facesContext = new StartupFacesContextImpl((ExternalContext)externalContext, (ReleaseableExternalContext)externalContext, exceptionHandler, startup);
        UIViewRoot startupViewRoot = new UIViewRoot();
        startupViewRoot.setLocale(Locale.getDefault());
        facesContext.setViewRoot(startupViewRoot);
        return facesContext;
    }

    private void _releaseFacesContext(FacesContext facesContext) {
        if (facesContext != null) {
            facesContext.release();
        }
    }

    protected abstract void initContainerIntegration(ServletContext var1, ExternalContext var2);

    protected void initCDIIntegration(ServletContext servletContext, ExternalContext externalContext) {
        Object beanManager = servletContext.getAttribute(CDI_SERVLET_CONTEXT_BEAN_MANAGER_ATTRIBUTE);
        if (beanManager == null) {
            Class icclazz = null;
            Method lookupMethod = null;
            try {
                icclazz = ClassUtils.simpleClassForName("javax.naming.InitialContext");
                if (icclazz != null) {
                    lookupMethod = icclazz.getMethod("doLookup", String.class);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (lookupMethod != null) {
                try {
                    beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/BeanManager");
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (beanManager == null) {
                    try {
                        beanManager = lookupMethod.invoke((Object)icclazz, "java:comp/env/BeanManager");
                    }
                    catch (Exception exception) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                }
            }
        }
        if (beanManager != null) {
            externalContext.getApplicationMap().put(CDI_BEAN_MANAGER_INSTANCE, beanManager);
        }
    }

    public void _callPreDestroyOnInjectedJSFArtifacts(FacesContext facesContext) {
        InjectionProvider injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(facesContext.getExternalContext()).getInjectionProvider(facesContext.getExternalContext());
        List injectedBeanStorage = (List)facesContext.getExternalContext().getApplicationMap().get(INJECTED_BEAN_STORAGE_KEY);
        if (injectedBeanStorage != null) {
            for (BeanEntry entry : injectedBeanStorage) {
                try {
                    injectionProvider.preDestroy(entry.getInstance(), entry.getCreationMetaData());
                }
                catch (InjectionProviderException ex) {
                    log.log(Level.INFO, "Exception on PreDestroy", ex);
                }
            }
            injectedBeanStorage.clear();
        }
    }
}

