/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.location.internal.FileLocator;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.LocalFileResource;
import com.ibm.ws.kernel.service.location.internal.RemoteResource;
import com.ibm.ws.kernel.service.location.internal.SymbolRegistry;
import com.ibm.ws.kernel.service.location.internal.SymbolicRootResource;
import com.ibm.ws.kernel.service.location.internal.VirtualRootResource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WsLocationAdminImpl
implements WsLocationAdmin {
    private static final TraceComponent tc = Tr.register(WsLocationAdminImpl.class);
    private static final String LOC_INTERNAL_LIB_DIR = "wlp.lib.dir";
    private static final String LOC_AREA_NAME_APPS = "shared/apps/";
    private static final String LOC_AREA_NAME_CONFIG = "shared/config/";
    private static final String LOC_AREA_NAME_RESC = "shared/resources/";
    private static final String LOC_AREA_NAME_STATE = "logs/state/";
    private static final String LOC_AREA_NAME_SERVERS = "servers/";
    private static final String LOC_AREA_NAME_CLIENTS = "clients/";
    private static final String LOC_AREA_NAME_WORKING = "workarea/";
    private static final String LOC_AREA_NAME_EXTENSION = "extension/";
    private static WsLocationAdminImpl instance;
    protected final SymbolicRootResource installRoot;
    protected final SymbolicRootResource installParentRoot;
    protected final SymbolicRootResource userRoot;
    protected final SymbolicRootResource usrExtensionRoot;
    protected final SymbolicRootResource serverConfigDir;
    protected final SymbolicRootResource serverOutputDir;
    protected final InternalWsResource bootstrapLib;
    protected final InternalWsResource serverWorkarea;
    protected final InternalWsResource serverState;
    protected final SymbolicRootResource sharedAppsRoot;
    protected final SymbolicRootResource sharedConfigRoot;
    protected final SymbolicRootResource sharedResourceRoot;
    protected final SymbolicRootResource tmpRoot;
    protected final String serverName;
    protected final List<File> resourcePaths = new ArrayList<File>(3);
    protected final HashMap<String, List<File>> resourceGroups = new HashMap();
    protected final VirtualRootResource commonRoot;
    static final long serialVersionUID = 7766352982799267432L;

    public static WsLocationAdminImpl createLocations(Map<String, Object> initProps) {
        if (instance == null) {
            SymbolRegistry.getRegistry().clear();
            instance = new WsLocationAdminImpl(initProps);
        }
        return instance;
    }

    public static WsLocationAdminImpl createLocations(BundleContext ctx) {
        if (instance == null) {
            SymbolRegistry.getRegistry().clear();
            instance = new WsLocationAdminImpl(new BundleContextMap(ctx));
        }
        return instance;
    }

    public static WsLocationAdminImpl getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Location manager not initialized");
        }
        return instance;
    }

    protected WsLocationAdminImpl(Map<String, Object> config) {
        String userRootStr = (String)config.get("wlp.user.dir");
        String serverCfgDirStr = (String)config.get("server.config.dir");
        String serverOutDirStr = (String)config.get("server.output.dir");
        String bootstrapLibStr = (String)config.get(LOC_INTERNAL_LIB_DIR);
        String processType = (String)config.get("wlp.process.type");
        boolean isClient = "client".equals(processType);
        this.serverName = (String)config.get("wlp.server.name");
        if (this.serverName == null || this.serverName.length() == 0) {
            this.throwInitializationException(new IllegalStateException("The server name must be specified"));
        }
        if (userRootStr == null || userRootStr.length() == 0) {
            this.throwInitializationException(new IllegalStateException("The location of the server instance must be specified"));
        }
        if (bootstrapLibStr == null || bootstrapLibStr.length() == 0) {
            this.throwInitializationException(new IllegalStateException("The location of bootstrap libraries must be specified"));
        }
        this.commonRoot = new VirtualRootResource();
        File bootstrapFile = new File(bootstrapLibStr);
        this.userRoot = new SymbolicRootResource(userRootStr, "wlp.user.dir", this.commonRoot);
        String bootstrapFileParentDir = bootstrapFile.getParent();
        this.installRoot = new SymbolicRootResource(bootstrapFileParentDir, "wlp.install.dir", this.commonRoot);
        File installFile = new File(bootstrapFileParentDir);
        String installFileParentDir = installFile.getParent();
        this.installParentRoot = new SymbolicRootResource(installFileParentDir, "wlp.parent.dir", this.commonRoot);
        this.bootstrapLib = this.resolveResource(bootstrapFile.getAbsolutePath() + File.separatorChar);
        if (!bootstrapFile.exists() || !this.userRoot.exists()) {
            this.throwInitializationException(new IllegalStateException("The locations for the bootstrap libraries and the server instance must exist"));
        }
        this.usrExtensionRoot = new SymbolicRootResource(this.userRoot.getNormalizedPath() + "/" + LOC_AREA_NAME_EXTENSION, "usr.extension.dir", this.commonRoot);
        String serversRootStr = this.userRoot.getNormalizedPath() + "/" + (isClient ? LOC_AREA_NAME_CLIENTS : LOC_AREA_NAME_SERVERS);
        if (serverCfgDirStr == null) {
            serverCfgDirStr = serversRootStr + "/" + this.serverName;
        }
        this.serverConfigDir = new SymbolicRootResource(serverCfgDirStr, "server.config.dir", this.commonRoot);
        if (serverOutDirStr == null || serverOutDirStr.equals(serverCfgDirStr)) {
            this.serverOutputDir = this.serverConfigDir;
            SymbolRegistry.getRegistry().addRootSymbol("server.output.dir", this.serverConfigDir);
        } else {
            this.serverOutputDir = new SymbolicRootResource(serverOutDirStr, "server.output.dir", this.commonRoot);
        }
        SymbolRegistry.getRegistry().addStringSymbol("wlp.process.type", processType);
        this.serverWorkarea = this.serverOutputDir.createDescendantResource(LOC_AREA_NAME_WORKING);
        SymbolRegistry.getRegistry().addResourceSymbol("server.workarea.dir", this.serverWorkarea);
        this.serverState = this.serverOutputDir.createDescendantResource(LOC_AREA_NAME_STATE);
        SymbolRegistry.getRegistry().addResourceSymbol("server.state.dir", this.serverState);
        String sharedAppsStr = this.userRoot.getNormalizedPath() + LOC_AREA_NAME_APPS;
        this.sharedAppsRoot = new SymbolicRootResource(sharedAppsStr, "shared.app.dir", this.commonRoot);
        String sharedConfigStr = this.userRoot.getNormalizedPath() + LOC_AREA_NAME_CONFIG;
        this.sharedConfigRoot = new SymbolicRootResource(sharedConfigStr, "shared.config.dir", this.commonRoot);
        String sharedResourceStr = this.userRoot.getNormalizedPath() + LOC_AREA_NAME_RESC;
        this.sharedResourceRoot = new SymbolicRootResource(sharedResourceStr, "shared.resource.dir", this.commonRoot);
        String dirProp = PathUtils.normalize((String)(System.getProperty("java.io.tmpdir") + '/'));
        this.tmpRoot = new SymbolicRootResource(dirProp, "tmp", this.commonRoot);
        if (!this.tmpRoot.exists()) {
            if (!this.tmpRoot.create()) {
                Tr.error((TraceComponent)tc, (String)"missingTmpDir", (Object[])new Object[]{this.tmpRoot.getNormalizedPath()});
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Created tmp directory", (Object[])new Object[]{this.tmpRoot.getNormalizedPath()});
            }
        }
        if (this.tmpRoot.exists() && !PathUtils.pathIsAbsolute((String)dirProp) && tc.isAuditEnabled()) {
            Tr.audit((TraceComponent)tc, (String)"relativeTmpDir", (Object[])new Object[]{this.tmpRoot.getNormalizedPath()});
        }
        SymbolRegistry.getRegistry().addStringSymbol("wlp.server.name", this.serverName);
        SymbolRegistry.getRegistry().addStringSymbol("wlp.server.uuid", this.getServerId().toString());
        this.addResourcePath(this.bootstrapLib.getNormalizedPath());
    }

    private final void throwInitializationException(RuntimeException t) {
        if (t != null) {
            Tr.error((TraceComponent)tc, (String)"locationInitializationError", (Object[])new Object[]{t.getMessage()});
            throw t;
        }
    }

    public File getBundleFile(Object caller, String relativeBundlePath) {
        String mockBundlePrivate = "bundle-";
        if (caller == null) {
            throw new NullPointerException("Caller to getBundleFile can not be null (path=" + relativeBundlePath + ")");
        }
        String filePath = PathUtils.normalizeDescendentPath((String)relativeBundlePath);
        File bundleFile = null;
        Bundle b = FrameworkUtil.getBundle(caller.getClass());
        BundleContext bc = null;
        long id = 0L;
        if (b != null) {
            bc = b.getBundleContext();
            id = b.getBundleId();
            if (bc != null) {
                bundleFile = bc.getDataFile(filePath);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BundleContext is null -- the bundle that loaded the class is in an invalid state", (Object[])new Object[]{b});
            }
        }
        if (bundleFile == null) {
            String dir = "bundle-" + id + "/" + filePath;
            bundleFile = new File(this.serverWorkarea.getNormalizedPath(), dir);
        }
        return bundleFile;
    }

    public UUID getServerId() {
        return ServerIdHolder.SERVER_ID;
    }

    public String getServerName() {
        return this.serverName;
    }

    public InternalWsResource getServerResource(String relativeServerPath) {
        return this.serverConfigDir.createDescendantResource(relativeServerPath);
    }

    public InternalWsResource getServerOutputResource(String relativeServerPath) {
        return this.serverOutputDir.createDescendantResource(relativeServerPath);
    }

    public InternalWsResource getServerWorkareaResource(String relativeServerWorkareaPath) {
        String filePath = PathUtils.normalizeDescendentPath((String)relativeServerWorkareaPath);
        String repPath = this.serverWorkarea.toRepositoryPath();
        if (repPath != null) {
            repPath = repPath + filePath;
        }
        return LocalFileResource.newResourceFromResource(this.serverWorkarea.getNormalizedPath() + filePath, repPath, this.serverWorkarea);
    }

    public String printLocations(boolean formatOutput) {
        StringBuilder sb = new StringBuilder();
        if (formatOutput) {
            Formatter f = new Formatter();
            f.format("%26s:  %s%n", "Install root", this.installRoot.getNormalizedPath());
            f.format("%26s:  %s%n", "System libraries", this.bootstrapLib.getNormalizedPath());
            f.format("%26s:  %s%n", "User root", this.userRoot.getNormalizedPath());
            f.format("%26s:  %s%n", "Server config", this.serverConfigDir.getNormalizedPath());
            f.format("%26s:  %s%n", "Server output", this.serverOutputDir.getNormalizedPath());
            sb.append(f.toString());
        } else {
            sb.append("installRoot=").append(this.installRoot.getNormalizedPath()).append(",");
            sb.append("bootstrapLib=").append(this.bootstrapLib.getNormalizedPath()).append(",");
            sb.append("userRoot=").append(this.userRoot.getNormalizedPath()).append(",");
            sb.append("serverConfigDir=").append(this.serverConfigDir.getNormalizedPath()).append(",");
            sb.append("serverOutputDir=").append(this.serverOutputDir.getNormalizedPath()).append(",");
        }
        return sb.toString();
    }

    public Dictionary<String, ?> getServiceProps() {
        Hashtable<String, String> d = new Hashtable<String, String>();
        d.put("wlp.install.dir", this.installRoot.getNormalizedPath());
        d.put("wlp.user.dir", this.userRoot.getNormalizedPath());
        d.put("server.config.dir", this.serverConfigDir.getNormalizedPath());
        d.put("server.output.dir", this.serverOutputDir.getNormalizedPath());
        d.put("shared.app.dir", this.sharedAppsRoot.getNormalizedPath());
        d.put("shared.config.dir", this.sharedConfigRoot.getNormalizedPath());
        d.put("shared.resource.dir", this.sharedResourceRoot.getNormalizedPath());
        d.put(LOC_INTERNAL_LIB_DIR, this.bootstrapLib.getNormalizedPath());
        d.put("wlp.server.name", this.serverName);
        d.put("tmp", this.tmpRoot.getNormalizedPath());
        d.put("service.vendor", "IBM");
        return d;
    }

    protected void addResourcePath(String path) {
        if (PathUtils.containsSymbol((String)path)) {
            InternalWsResource ar = SymbolRegistry.getRegistry().resolveSymbolicResource(path);
            path = ar.toExternalURI().getPath();
        } else {
            path = PathUtils.normalize((String)new File(path).getAbsolutePath());
        }
        File dir = new File(path);
        if (dir.exists()) {
            ArrayList<File> group = new ArrayList<File>();
            group.add(new File(dir, "features"));
            this.resourceGroups.put("feature", group);
            this.resourcePaths.add(dir);
        }
    }

    public Iterator<WsResource> matchResource(String resourceGroupName, String resourceRegex, int limit) {
        if (resourceGroupName == null) {
            throw new NullPointerException("Resource group required");
        }
        List<File> path = null;
        path = this.resourceGroups.get(resourceGroupName);
        if (path == null) {
            String resolveName = "${" + resourceGroupName + "}";
            String resourceListNames = SymbolRegistry.getRegistry().resolveSymbolicString(resolveName);
            if (resourceListNames != null && !resourceListNames.equals(resolveName)) {
                String[] names = resourceListNames.split("\\s*,\\s*");
                path = new ArrayList<File>();
                for (String filePath : names) {
                    path.add(new File(filePath));
                }
                this.resourceGroups.put(resourceGroupName, path);
            } else {
                path = this.resourcePaths;
            }
        }
        List<Object> matches = Collections.emptyList();
        if (path.size() > 1) {
            matches = new ArrayList();
            for (File dir : path) {
                matches.addAll(FileLocator.getMatchingFiles(dir, resourceRegex));
            }
        } else if (path.size() == 1) {
            matches = FileLocator.getMatchingFiles(path.get(0), resourceRegex);
        }
        return new IteratorWrapper(matches.iterator(), this.bootstrapLib, limit);
    }

    /*
     * WARNING - void declaration
     */
    public InternalWsResource resolveResource(String resourceURI) {
        if (resourceURI == null || resourceURI.length() == 0) {
            return null;
        }
        String normalPath = PathUtils.normalize((String)resourceURI);
        if (PathUtils.containsSymbol((String)normalPath)) {
            return SymbolRegistry.getRegistry().resolveSymbolicResource(normalPath);
        }
        if (normalPath.length() >= 1 && normalPath.charAt(0) == '/') {
            SymbolicRootResource root = this.resolveRoot(normalPath);
            return LocalFileResource.newResource(normalPath, null, root);
        }
        if (normalPath.length() > 2 && normalPath.charAt(1) == ':') {
            SymbolicRootResource root = this.resolveRoot(normalPath);
            return LocalFileResource.newResource(normalPath, null, root);
        }
        if (!PathUtils.pathIsAbsolute((String)normalPath)) {
            return this.serverConfigDir.createDescendantResource(normalPath);
        }
        URI uri = null;
        try {
            uri = new URI(normalPath);
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl", (String)"690", (Object)this, (Object[])new Object[]{resourceURI});
            try {
                uri = new URI(null, null, normalPath, null);
            }
            catch (URISyntaxException uRISyntaxException2) {
                void e1;
                FFDCFilter.processException((Throwable)uRISyntaxException2, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl", (String)"695", (Object)this, (Object[])new Object[]{resourceURI});
                MalformedLocationException e3 = new MalformedLocationException("Could not construct URI to resolve resource (path=" + normalPath + ")");
                e3.initCause((Throwable)e1);
                throw e3;
            }
        }
        return this.resolveResource(uri);
    }

    public String resolveString(String resourceURI) {
        if (resourceURI == null || resourceURI.length() == 0) {
            return null;
        }
        String normalPath = PathUtils.containsSymbol((String)resourceURI) ? SymbolRegistry.getRegistry().resolveSymbolicString(resourceURI) : PathUtils.normalize((String)resourceURI);
        if (normalPath.length() >= 1 && normalPath.charAt(0) == '/') {
            return normalPath;
        }
        if (normalPath.length() > 2 && normalPath.charAt(1) == ':') {
            return normalPath;
        }
        return normalPath;
    }

    public InternalWsResource resolveResource(URI resourceURI) {
        if (resourceURI == null) {
            return null;
        }
        String scheme = resourceURI.getScheme();
        if (scheme == null || scheme.equals("file")) {
            String normalPath = PathUtils.normalize((String)resourceURI.getPath());
            SymbolicRootResource root = this.resolveRoot(normalPath);
            return LocalFileResource.newResource(normalPath, null, root);
        }
        try {
            return new RemoteResource(resourceURI.toURL());
        }
        catch (MalformedURLException normalPath) {
            FFDCFilter.processException((Throwable)normalPath, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl", (String)"763", (Object)this, (Object[])new Object[]{resourceURI});
            return null;
        }
    }

    public InternalWsResource asResource(File file, boolean isFile) {
        if (file == null) {
            return null;
        }
        String normalPath = PathUtils.normalize((String)file.getAbsolutePath());
        if (!isFile) {
            normalPath = normalPath + "/";
        }
        SymbolicRootResource root = this.resolveRoot(normalPath);
        return LocalFileResource.newResource(normalPath, null, root);
    }

    SymbolicRootResource resolveRoot(String normalPath) {
        return SymbolRegistry.getRegistry().findRoot(normalPath);
    }

    public WsResource getRuntimeResource(String relativeRuntimePath) {
        return this.installRoot.resolveRelative(relativeRuntimePath);
    }

    public WsResource addLocation(String fileName, String symbolicName) {
        return new SymbolicRootResource(fileName, symbolicName, this.commonRoot);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class IteratorWrapper
    implements Iterator<WsResource> {
        private final Iterator<File> fileIterator;
        private final InternalWsResource related;
        private final int limit;
        private int index;
        static final long serialVersionUID = 1703224612350687998L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        IteratorWrapper(Iterator<File> fileIterator, InternalWsResource related, int limit) {
            this.fileIterator = fileIterator;
            this.related = related;
            this.limit = limit == 0 ? Integer.MAX_VALUE : limit;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.limit && this.fileIterator.hasNext();
        }

        @Override
        public WsResource next() {
            ++this.index;
            File f = this.fileIterator.next();
            String normalPath = PathUtils.normalize((String)f.getAbsolutePath());
            return LocalFileResource.newResourceFromResource(normalPath, null, this.related);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(IteratorWrapper.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class BundleContextMap
    implements Map<String, Object> {
        private final BundleContext wrappedContext;
        static final long serialVersionUID = -1317716319638849863L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        BundleContextMap(BundleContext ctx) {
            this.wrappedContext = ctx;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Can not clear attributes of bundle context");
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wrappedContext.getProperty((String)key) != null;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("Can not iterate over bundle context property values");
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException("Can not obtain entry set for bundle context properties");
        }

        @Override
        public Object get(Object key) {
            return this.wrappedContext.getProperty((String)key);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Can not count bundle context properties");
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("Can not obtain set of bundle context property keys");
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("Can not clear attributes of bundle context");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            throw new UnsupportedOperationException("Can not clear attributes of bundle context");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("Can not clear attributes of bundle context");
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Can not count bundle context properties");
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException("Can not create collection of bundle context property values");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BundleContextMap.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ServerIdHolder {
        static final UUID SERVER_ID;
        static final long serialVersionUID = 5146580496201323469L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ServerIdHolder() {
        }

        private static UUID getServerId() {
            UUID id = ServerIdHolder.readOrWriteId();
            if (id == null) {
                id = UUID.randomUUID();
            }
            return id;
        }

        private static UUID readOrWriteId() {
            final Bundle bundle = FrameworkUtil.getBundle(ServerIdHolder.class);
            if (bundle == null) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<UUID>(){
                static final long serialVersionUID = 2179479181867055102L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public UUID run() {
                    BundleContext bundleContext = bundle.getBundleContext();
                    if (bundleContext == null) {
                        return null;
                    }
                    File file = null;
                    try {
                        file = bundleContext.getDataFile("serverId");
                    }
                    catch (IllegalStateException illegalStateException) {
                        FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl$ServerIdHolder$1", (String)"431", (Object)this, (Object[])new Object[0]);
                    }
                    if (file == null) {
                        return null;
                    }
                    if (file.exists()) {
                        return ServerIdHolder.readId(file);
                    }
                    UUID id = UUID.randomUUID();
                    ServerIdHolder.writeId(file, id);
                    return id;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static UUID readId(File file) {
            BufferedReader in;
            UUID result;
            block4: {
                result = null;
                in = null;
                try {
                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    String id = in.readLine();
                    if (id == null) break block4;
                    result = UUID.fromString(id);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl$ServerIdHolder", (String)"458", null, (Object[])new Object[]{file});
                    ServerIdHolder.tryToClose(in);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl$ServerIdHolder", (String)"460", null, (Object[])new Object[]{file});
                    ServerIdHolder.tryToClose(in);
                }
                catch (Throwable throwable) {
                    ServerIdHolder.tryToClose(in);
                    throw throwable;
                }
            }
            ServerIdHolder.tryToClose(in);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeId(File file, UUID id) {
            BufferedWriter out;
            String idString;
            block5: {
                idString = id.toString();
                out = null;
                if (FileUtils.ensureDirExists((File)file.getParentFile())) break block5;
                ServerIdHolder.tryToClose(out);
                return;
            }
            try {
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8"));
                out.write(idString);
            }
            catch (IOException iOException) {
                block6: {
                    try {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl$ServerIdHolder", (String)"478", null, (Object[])new Object[]{file, id});
                        ServerIdHolder.tryToClose(out);
                        out = null;
                        boolean deleted = file.delete();
                        if (deleted || !tc.isDebugEnabled()) break block6;
                        Tr.debug((TraceComponent)tc, (String)"Failed to delete a file after a write operation failed", (Object[])new Object[]{file});
                    }
                    catch (Throwable throwable) {
                        ServerIdHolder.tryToClose(out);
                        throw throwable;
                    }
                }
                ServerIdHolder.tryToClose(out);
            }
            ServerIdHolder.tryToClose(out);
        }

        private static void tryToClose(Closeable stream) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl$ServerIdHolder", (String)"495", null, (Object[])new Object[]{stream});
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ServerIdHolder.class);
            SERVER_ID = ServerIdHolder.getServerId();
        }
    }
}

