/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.ThreadLocalProxyCopyOnWriteArraySet;
import org.apache.cxf.message.Message;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ClientProviderFactory
extends ProviderFactory {
    private static final TraceComponent tc = Tr.register(ClientProviderFactory.class);
    private final List<ProviderInfo<ClientRequestFilter>> clientRequestFilters;
    private final List<ProviderInfo<ClientResponseFilter>> clientResponseFilters;
    private final List<ProviderInfo<ResponseExceptionMapper<?>>> responseExceptionMappers;
    static final long serialVersionUID = -4694592031354085786L;

    private ClientProviderFactory(Bus bus) {
        super(bus);
        String javaVersion = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 5436750812514947289L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("java.version");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
        String cs = "1.7";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)javaVersion, (Object[])new Object[0]);
        }
        if (javaVersion.contains(cs)) {
            this.clientRequestFilters = new ArrayList<ProviderInfo<ClientRequestFilter>>(1);
            this.clientResponseFilters = new ArrayList<ProviderInfo<ClientResponseFilter>>(1);
            this.responseExceptionMappers = new ArrayList(1);
        } else {
            this.clientRequestFilters = new CopyOnWriteArrayList<ProviderInfo<ClientRequestFilter>>();
            this.clientResponseFilters = new CopyOnWriteArrayList<ProviderInfo<ClientResponseFilter>>();
            this.responseExceptionMappers = new CopyOnWriteArrayList();
        }
    }

    public static ClientProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ClientProviderFactory factory = new ClientProviderFactory(bus);
        ProviderFactory.initFactory(factory);
        factory.setBusProviders();
        return factory;
    }

    public static ClientProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return (ClientProviderFactory)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory");
    }

    public static ClientProviderFactory getInstance(Endpoint e) {
        return (ClientProviderFactory)e.get((Object)"org.apache.cxf.jaxrs.client.ClientProviderFactory");
    }

    @Override
    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        List<ProviderInfo<? extends Object>> theProviders = this.prepareProviders(custom, busGlobal, providers, null);
        super.setCommonProviders(theProviders);
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls;
            if (ClientProviderFactory.filterContractSupported(provider, providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider()), ClientRequestFilter.class)) {
                this.addProviderToList(this.clientRequestFilters, provider);
            }
            if (ClientProviderFactory.filterContractSupported(provider, providerCls, ClientResponseFilter.class)) {
                this.addProviderToList(this.clientResponseFilters, provider);
            }
            if (!ResponseExceptionMapper.class.isAssignableFrom(providerCls)) continue;
            this.addProviderToList(this.responseExceptionMappers, provider);
        }
        Collections.sort(this.clientRequestFilters, new ProviderFactory.BindingPriorityComparator(ClientRequestFilter.class, true));
        Collections.sort(this.clientResponseFilters, new ProviderFactory.BindingPriorityComparator(ClientResponseFilter.class, false));
        this.injectContextProxies(this.responseExceptionMappers, this.clientRequestFilters, this.clientResponseFilters);
    }

    public <T extends Throwable> ResponseExceptionMapper<T> createResponseExceptionMapper(Message m, Class<?> paramType) {
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ResponseExceptionMapper<?>> em : this.responseExceptionMappers) {
            if (!this.handleMapper(em, paramType, m, ResponseExceptionMapper.class, true)) continue;
            candidates.add(em.getProvider());
        }
        if (candidates.size() == 0) {
            return null;
        }
        Collections.sort(candidates, new ProviderFactory.ClassComparator(paramType));
        return (ResponseExceptionMapper)candidates.get(0);
    }

    @Override
    public void clearProviders() {
        super.clearProviders();
        this.responseExceptionMappers.clear();
        this.clientRequestFilters.clear();
        this.clientResponseFilters.clear();
    }

    public List<ProviderInfo<ClientRequestFilter>> getClientRequestFilters() {
        return Collections.unmodifiableList(this.clientRequestFilters);
    }

    public List<ProviderInfo<ClientResponseFilter>> getClientResponseFilters() {
        return Collections.unmodifiableList(this.clientResponseFilters);
    }

    @Override
    public Configuration getConfiguration(Message m) {
        return (Configuration)m.getExchange().getOutMessage().getContextualProperty(Configuration.class.getName());
    }

    @Override
    public void clearThreadLocalProxies() {
        ThreadLocalProxyCopyOnWriteArraySet proxySet = (ThreadLocalProxyCopyOnWriteArraySet)this.getBus().getProperty("proxy-set");
        if (proxySet != null) {
            Object[] proxies;
            for (Object proxy : proxies = proxySet.toArray()) {
                ((ThreadLocalProxy)proxy).remove();
            }
        }
    }
}

