/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility;

import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandUtils;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LicenseUtility {
    private static final int LINE_WRAP_COLUMNS = 72;

    public Object displayLicenseFile(InputStream licenseFile, CommandConsole commandConsole) {
        Object e = LicenseUtility.class;
        if (licenseFile != null) {
            e = this.showLicenseFile(licenseFile, commandConsole);
        }
        if (e != null) {
            commandConsole.printErrorMessage(CommandUtils.getMessage("LICENSE_NOT_FOUND", new Object[0]));
        }
        return e;
    }

    public final File getLicenseFile(File installLicenseDir, String prefix) throws FileNotFoundException {
        if (!prefix.endsWith("_")) {
            prefix = prefix + "_";
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String[] suffixes = new String[]{lang + '_' + country, lang, "en"};
        File[] listOfFiles = installLicenseDir.listFiles();
        File licenseFile = null;
        block0: for (File file : listOfFiles) {
            for (String suffix : suffixes) {
                if (!file.getName().startsWith(prefix) || !file.getName().endsWith(suffix)) continue;
                licenseFile = new File(file.getAbsolutePath());
                break block0;
            }
        }
        return licenseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Exception showLicenseFile(InputStream in, CommandConsole commandConsole) {
        Exception i2;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, "UTF-16"));
            while ((line = reader.readLine()) != null) {
                LicenseUtility.wordWrap(line, lines);
            }
            for (int i2 = 0; i2 < lines.size(); ++i2) {
                commandConsole.printlnInfoMessage((String)lines.get(i2));
            }
            commandConsole.printlnInfoMessage("");
            i2 = null;
            FileUtils.tryToClose((Closeable)reader);
        }
        catch (Exception e) {
            Exception exception = e;
            return exception;
        }
        finally {
            FileUtils.tryToClose(reader);
        }
        return i2;
    }

    static List<String> wordWrap(String line, List<String> lines) {
        if (lines == null) {
            lines = new ArrayList<String>();
        }
        if (line.length() == 0) {
            lines.add("");
            return lines;
        }
        int begin = 0;
        while (begin < line.length()) {
            int tryEnd;
            int end;
            if (begin + 72 >= line.length()) {
                lines.add(line.substring(begin));
                break;
            }
            for (end = tryEnd = Math.min(line.length(), begin + 72); end > begin && !Character.isWhitespace(line.charAt(end - 1)); --end) {
            }
            while (end > begin && Character.isWhitespace(line.charAt(end - 1))) {
                --end;
            }
            if (end == begin) {
                for (end = tryEnd; end < line.length() && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
            }
            lines.add(line.substring(begin, end));
            for (begin = end; begin < line.length() && Character.isWhitespace(line.charAt(begin)); ++begin) {
            }
        }
        return lines;
    }
}

