/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ThroughputDistribution {
    static final double ALPHA = 0.2;
    static final double SINGLE_VALUE_STDDEV = 0.16666666666666666;
    double ewma = 0.0;
    double ewmaVariance = Double.NEGATIVE_INFINITY;
    private static final double[] Z_SCORE_PROBABILITY_LESS_THAN;
    static final long serialVersionUID = -753825587788569519L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ThroughputDistribution() {
    }

    synchronized void reset(double value) {
        this.ewma = value;
        this.ewmaVariance = value * 0.16666666666666666;
        this.ewmaVariance *= this.ewmaVariance;
    }

    synchronized double getVariance() {
        if (this.ewmaVariance == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        return this.ewmaVariance;
    }

    synchronized double getMovingAverage() {
        return this.ewma;
    }

    synchronized void addDataPoint(double value) {
        if (this.ewmaVariance == Double.NEGATIVE_INFINITY) {
            this.reset(value);
            return;
        }
        double delta = value - this.ewma;
        double increment = 0.2 * delta;
        this.ewma += increment;
        this.ewmaVariance = 0.8 * (this.ewmaVariance + delta * increment);
    }

    synchronized double getZScore(double value) {
        if (this.ewmaVariance == Double.NEGATIVE_INFINITY) {
            return Math.random() - 0.5;
        }
        double score = (value - this.ewma) / Math.sqrt(this.ewmaVariance);
        if (score < -3.4) {
            return -3.4;
        }
        if (score > 3.4) {
            return 3.4;
        }
        return score;
    }

    double getProbabilityLessThan(double value) {
        double zScore = this.getZScore(value);
        int probabiltyIndex = (int)(zScore * 100.0) + 340;
        return Z_SCORE_PROBABILITY_LESS_THAN[probabiltyIndex];
    }

    double getProbabilityGreaterThan(double value) {
        return 1.0 - this.getProbabilityLessThan(value);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        double variance = this.ewmaVariance == Double.NEGATIVE_INFINITY ? 0.0 : this.ewmaVariance;
        sb.append(" ewma=").append(String.format("%16.6f", this.ewma));
        sb.append(" stddev=").append(String.format("%16.6f", Math.sqrt(variance)));
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ThroughputDistribution.class);
        Z_SCORE_PROBABILITY_LESS_THAN = new double[]{3.369292657E-4, 3.494631183E-4, 3.62429149E-4, 3.758409184E-4, 3.897123626E-4, 4.040578019E-4, 4.188919495E-4, 4.342299204E-4, 4.500872406E-4, 4.664798561E-4, 4.834241424E-4, 5.009369138E-4, 5.190354332E-4, 5.377374218E-4, 5.57061069E-4, 5.770250424E-4, 5.976484979E-4, 6.189510904E-4, 6.409529837E-4, 6.636748614E-4, 6.871379379E-4, 7.113639686E-4, 7.363752616E-4, 7.621946881E-4, 7.888456944E-4, 8.163523128E-4, 8.447391735E-4, 8.740315156E-4, 9.042551998E-4, 9.354367195E-4, 9.676032132E-4, 0.0010007824766, 0.0010350029748, 0.0010702938547, 0.0011066849574, 0.001144206831, 0.0011828907431, 0.0012227686936, 0.0012638734277, 0.0013062384488, 0.0013498980316, 0.0013948872355, 0.0014412419173, 0.0014889987452, 0.0015381952117, 0.0015888696474, 0.0016410612342, 0.0016948100193, 0.0017501569287, 0.0018071437808, 0.0018658133004, 0.0019262091322, 0.0019883758549, 0.0020523589949, 0.0021182050404, 0.0021859614549, 0.0022556766915, 0.0023274002067, 0.0024011824742, 0.0024770749988, 0.0025551303304, 0.0026354020779, 0.0027179449227, 0.0028028146328, 0.0028900680762, 0.0029797632351, 0.0030719592187, 0.0031667162774, 0.0032640958159, 0.0033641604067, 0.003466973803, 0.0035726009524, 0.0036811080092, 0.0037925623477, 0.0039070325749, 0.0040245885428, 0.004145301361, 0.0042692434091, 0.0043964883481, 0.004527111133, 0.0046611880237, 0.0047987965971, 0.0049400157578, 0.005084925749, 0.0052336081636, 0.0053861459541, 0.0055426234431, 0.005703126333, 0.0058677417153, 0.0060365580804, 0.0062096653258, 0.0063871547649, 0.0065691191355, 0.0067556526071, 0.0069468507886, 0.0071428107353, 0.0073436309553, 0.0075494114163, 0.0077602535506, 0.0079762602607, 0.0081975359246, 0.0084241863993, 0.0086563190255, 0.0088940426303, 0.0091374675306, 0.0093867055348, 0.0096418699454, 0.0099030755592, 0.0101704386687, 0.010444077062, 0.0107241100217, 0.0110106583244, 0.0113038442386, 0.0116037915219, 0.0119106254185, 0.012224472655, 0.0125454614359, 0.0128737214386, 0.0132093838073, 0.0135525811464, 0.0139034475135, 0.0142621184107, 0.014628730776, 0.0150034229737, 0.0153863347839, 0.0157776073911, 0.0161773833722, 0.0165858066836, 0.0170030226476, 0.0174291779377, 0.0178644205628, 0.0183088998517, 0.0187627664349, 0.0192261722275, 0.0196992704094, 0.0201822154057, 0.0206751628661, 0.0211782696427, 0.0216916937676, 0.0222155944294, 0.0227501319482, 0.0232954677502, 0.0238517643415, 0.0244191852802, 0.0249978951482, 0.0255880595216, 0.0261898449405, 0.0268034188771, 0.0274289497038, 0.0280666066598, 0.028716559816, 0.0293789800404, 0.0300540389612, 0.0307419089295, 0.0314427629808, 0.0321567747956, 0.0328841186592, 0.0336249694196, 0.0343795024459, 0.035147893584, 0.0359303191129, 0.0367269556987, 0.0375379803485, 0.0383635703629, 0.0392039032875, 0.0400591568638, 0.0409295089788, 0.0418151376136, 0.0427162207913, 0.043632936524, 0.0445654627585, 0.0455139773215, 0.0464786578637, 0.0474596818029, 0.0484572262667, 0.0494714680336, 0.0505025834741, 0.0515507484901, 0.0526161384542, 0.0536989281481, 0.0547992916996, 0.0559174025195, 0.0570534332378, 0.0582075556385, 0.0593799405948, 0.0605707580021, 0.0617801767118, 0.063008364464, 0.0642554878189, 0.0655217120889, 0.0668072012689, 0.0681121179667, 0.0694366233333, 0.0707808769917, 0.0721450369659, 0.0735292596096, 0.0749336995343, 0.0763585095367, 0.0778038405265, 0.0792698414534, 0.0807566592338, 0.0822644386777, 0.083793322415, 0.085343450822, 0.0869149619471, 0.0885079914374, 0.0901226724644, 0.0917591356503, 0.0934175089935, 0.0950979177952, 0.0968004845856, 0.0985253290497, 0.1002725679544, 0.1020423150748, 0.1038346811213, 0.1056497736669, 0.1074876970746, 0.1093485524257, 0.1112324374478, 0.113139446444, 0.1150696702217, 0.1170231960231, 0.1190001074552, 0.121000484421, 0.1230244030513, 0.1250719356371, 0.1271431505628, 0.12923811224, 0.1313568810427, 0.1334995132427, 0.1356660609464, 0.137856572032, 0.1400710900888, 0.1423096543559, 0.1445722996639, 0.1468590563759, 0.149169950331, 0.1515050027883, 0.1538642303727, 0.1562476450212, 0.1586552539315, 0.1610870595108, 0.1635430593277, 0.1660232460635, 0.1685276074668, 0.1710561263085, 0.1736087803386, 0.1761855422453, 0.1787863796144, 0.1814112548918, 0.1840601253468, 0.1867329430372, 0.1894296547767, 0.1921502021037, 0.1948945212518, 0.1976625431227, 0.2004541932604, 0.2032693918281, 0.2061080535858, 0.2089700878716, 0.2118553985834, 0.2147638841636, 0.2176954375857, 0.2206499463426, 0.2236272924376, 0.2266273523769, 0.2296499971648, 0.2326950923009, 0.2357624977792, 0.23885206809, 0.2419636522231, 0.2450970936743, 0.2482522304536, 0.2514288950953, 0.2546269146713, 0.2578461108059, 0.2610862996929, 0.2643472921157, 0.267628893469, 0.270930903783, 0.2742531177501, 0.2775953247535, 0.2809573088986, 0.2843388490463, 0.287739718849, 0.2911596867883, 0.2945985162157, 0.2980559653949, 0.301531787547, 0.3050257308975, 0.308537538726, 0.3120669494174, 0.3156136965162, 0.3191775087825, 0.3227581102503, 0.3263552202879, 0.3299685536606, 0.3335978205954, 0.3372427268482, 0.3409029737723, 0.3445782583897, 0.348268273464, 0.3519727075758, 0.3556912451994, 0.359423566782, 0.3631693488244, 0.366928263964, 0.3706999810593, 0.3744841652767, 0.378280478178, 0.382088577811, 0.3859081188011, 0.3897387524442, 0.393580126802, 0.3974318867982, 0.4012936743171, 0.4051651283022, 0.409045884858, 0.4129355773518, 0.4168338365175, 0.4207402905609, 0.4246545652652, 0.4285762840991, 0.432505068325, 0.4364405371086, 0.4403823076297, 0.4443299951941, 0.4482832133454, 0.4522415739794, 0.4562046874577, 0.460172162723, 0.4641436074148, 0.468118627986, 0.4720968298195, 0.4760778173459, 0.4800611941616, 0.4840465631472, 0.4880335265859, 0.4920216862831, 0.4960106436854, 0.5, 0.5039893563146, 0.5079783137169, 0.5119664734141, 0.5159534368528, 0.5199388058384, 0.5239221826541, 0.5279031701805, 0.531881372014, 0.5358563925852, 0.539827837277, 0.5437953125423, 0.5477584260206, 0.5517167866546, 0.5556700048059, 0.5596176923702, 0.5635594628914, 0.567494931675, 0.5714237159009, 0.5753454347348, 0.5792597094391, 0.5831661634824, 0.5870644226482, 0.590954115142, 0.5948348716978, 0.5987063256829, 0.6025681132018, 0.606419873198, 0.6102612475558, 0.6140918811989, 0.6179114221889, 0.621719521822, 0.6255158347233, 0.6293000189406, 0.633071736036, 0.6368306511756, 0.640576433218, 0.6443087548005, 0.6480272924242, 0.651731726536, 0.6554217416103, 0.6590970262277, 0.6627572731517, 0.6664021794045, 0.6700314463394, 0.6736447797121, 0.6772418897496, 0.6808224912174, 0.6843863034838, 0.6879330505826, 0.691462461274, 0.6949742691025, 0.698468212453, 0.7019440346051, 0.7054014837843, 0.7088403132116, 0.712260281151, 0.7156611509537, 0.7190426911014, 0.7224046752465, 0.7257468822499, 0.729069096217, 0.732371106531, 0.7356527078843, 0.7389137003071, 0.7421538891941, 0.7453730853287, 0.7485711049047, 0.7517477695464, 0.7549029063257, 0.7580363477769, 0.76114793191, 0.7642375022207, 0.7673049076991, 0.7703500028352, 0.7733726476231, 0.7763727075624, 0.7793500536573, 0.7823045624143, 0.7852361158364, 0.7881446014166, 0.7910299121284, 0.7938919464142, 0.7967306081719, 0.7995458067395, 0.8023374568773, 0.8051054787482, 0.8078497978963, 0.8105703452233, 0.8132670569628, 0.8159398746532, 0.8185887451082, 0.8212136203856, 0.8238144577547, 0.8263912196614, 0.8289438736915, 0.8314723925332, 0.8339767539365, 0.8364569406723, 0.8389129404892, 0.8413447460685, 0.8437523549787, 0.8461357696273, 0.8484949972117, 0.850830049669, 0.8531409436241, 0.8554277003361, 0.8576903456441, 0.8599289099112, 0.862143427968, 0.8643339390536, 0.8665004867572, 0.8686431189573, 0.87076188776, 0.8728568494372, 0.8749280643628, 0.8769755969487, 0.878999515579, 0.8809998925448, 0.8829768039769, 0.8849303297783, 0.886860553556, 0.8887675625522, 0.8906514475743, 0.8925123029254, 0.8943502263331, 0.8961653188787, 0.8979576849252, 0.8997274320456, 0.9014746709502, 0.9031995154144, 0.9049020822048, 0.9065824910065, 0.9082408643497, 0.9098773275355, 0.9114920085626, 0.9130850380529, 0.914656549178, 0.916206677585, 0.9177355613223, 0.9192433407662, 0.9207301585466, 0.9221961594735, 0.9236414904633, 0.9250663004657, 0.9264707403903, 0.9278549630341, 0.9292191230083, 0.9305633766667, 0.9318878820333, 0.9331927987311, 0.9344782879111, 0.9357445121811, 0.936991635536, 0.9382198232882, 0.9394292419979, 0.9406200594052, 0.9417924443614, 0.9429465667622, 0.9440825974805, 0.9452007083004, 0.9463010718519, 0.9473838615457, 0.9484492515099, 0.9494974165259, 0.9505285319663, 0.9515427737333, 0.9525403181971, 0.9535213421363, 0.9544860226784, 0.9554345372415, 0.956367063476, 0.9572837792087, 0.9581848623864, 0.9590704910212, 0.9599408431362, 0.9607960967125, 0.9616364296371, 0.9624620196515, 0.9632730443013, 0.9640696808871, 0.964852106416, 0.9656204975541, 0.9663750305804, 0.9671158813408, 0.9678432252044, 0.9685572370192, 0.9692580910705, 0.9699459610388, 0.9706210199596, 0.971283440184, 0.9719333933402, 0.9725710502962, 0.9731965811229, 0.9738101550595, 0.9744119404784, 0.9750021048518, 0.9755808147198, 0.9761482356585, 0.9767045322498, 0.9772498680518, 0.9777844055706, 0.9783083062324, 0.9788217303573, 0.9793248371339, 0.9798177845943, 0.9803007295906, 0.9807738277725, 0.9812372335651, 0.9816911001483, 0.9821355794372, 0.9825708220623, 0.9829969773524, 0.9834141933164, 0.9838226166278, 0.9842223926089, 0.9846136652161, 0.9849965770263, 0.985371269224, 0.9857378815893, 0.9860965524865, 0.9864474188536, 0.9867906161927, 0.9871262785614, 0.9874545385641, 0.987775527345, 0.9880893745815, 0.9883962084781, 0.9886961557614, 0.9889893416756, 0.9892758899783, 0.989555922938, 0.9898295613313, 0.9900969244408, 0.9903581300546, 0.9906132944652, 0.9908625324694, 0.9911059573697, 0.9913436809745, 0.9915758136007, 0.9918024640754, 0.9920237397393, 0.9922397464494, 0.9924505885837, 0.9926563690447, 0.9928571892647, 0.9930531492114, 0.9932443473929, 0.9934308808645, 0.9936128452351, 0.9937903346742, 0.9939634419196, 0.9941322582847, 0.994296873667, 0.9944573765569, 0.9946138540459, 0.9947663918364, 0.994915074251, 0.9950599842422, 0.9952012034029, 0.9953388119763, 0.995472888867, 0.9956035116519, 0.9957307565909, 0.995854698639, 0.9959754114572, 0.9960929674251, 0.9962074376523, 0.9963188919908, 0.9964273990476, 0.996533026197, 0.9966358395933, 0.9967359041841, 0.9968332837226, 0.9969280407813, 0.9970202367649, 0.9971099319238, 0.9971971853672, 0.9972820550773, 0.9973645979221, 0.9974448696696, 0.9975229250012, 0.9975988175258, 0.9976725997933, 0.9977443233085, 0.9978140385451, 0.9978817949596, 0.9979476410051, 0.9980116241451, 0.9980737908678, 0.9981341866996, 0.9981928562192, 0.9982498430713, 0.9983051899807, 0.9983589387658, 0.9984111303526, 0.9984618047883, 0.9985110012548, 0.9985587580827, 0.9986051127645, 0.9986501019684, 0.9986937615512, 0.9987361265723, 0.9987772313064, 0.9988171092569, 0.998855793169, 0.9988933150426, 0.9989297061453, 0.9989649970252, 0.9989992175234, 0.9990323967868, 0.9990645632805, 0.9990957448002, 0.9991259684844, 0.9991552608265, 0.9991836476872, 0.9992111543056, 0.9992378053119, 0.9992636247384, 0.9992886360314, 0.9993128620621, 0.9993363251386, 0.9993590470163, 0.9993810489096, 0.9994023515021, 0.9994229749576, 0.999442938931, 0.9994622625782, 0.9994809645668, 0.9994990630862, 0.9995165758576, 0.9995335201439, 0.9995499127594, 0.9995657700796, 0.9995811080506, 0.9995959421981, 0.9996102876374, 0.9996241590816, 0.999637570851, 0.9996505368817, 0.9996630707343};
    }
}

