/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.LaunchManifest;
import com.ibm.ws.kernel.boot.cmdline.PackageDelegateClassLoader;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.NameBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.VersionUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.tools.ToolProvider;

public class UtilityMain {
    private static final String DEFAULT_BUNDLE_VERSION = "0.0.0";
    private static File installDir = null;

    public static void main(String[] args) {
        try {
            UtilityMain.internal_main(args);
        }
        catch (InvocationTargetException e) {
            Throwable ite = e.getTargetException();
            if (ite != null) {
                ite.printStackTrace();
            } else {
                e.printStackTrace();
            }
            System.exit(32);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void internal_main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, PrivilegedActionException {
        String jarName = System.getProperty("java.class.path");
        JarFile jarFile = new JarFile(new File(jarName));
        Attributes a = jarFile.getManifest().getMainAttributes();
        jarFile.close();
        String commandClass = a.getValue("Command-Class");
        String requiredBundles = a.getValue("Require-Bundle");
        String parentCL = a.getValue("Parent-ClassLoader");
        String parentLastPackages = a.getValue("Parent-Last-Package");
        String requireCompiler = a.getValue("Require-Compiler");
        boolean bootstrapCLParent = false;
        boolean compilerTools = false;
        if ("bootstrap".equals(parentCL)) {
            bootstrapCLParent = true;
        }
        if ("true".equals(requireCompiler)) {
            compilerTools = true;
        }
        List<LaunchManifest.RequiredBundle> rbs = LaunchManifest.parseRequireBundle(requiredBundles);
        BundleRepositoryRegistry.initializeDefaults(null, false);
        NameBasedLocalBundleRepository repo = new NameBasedLocalBundleRepository(UtilityMain.getInstallDir());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (LaunchManifest.RequiredBundle requiredBundle : rbs) {
            String bundleVersion = requiredBundle.getAttribute("version");
            String string = bundleVersion = null != bundleVersion ? bundleVersion : DEFAULT_BUNDLE_VERSION;
            File f = repo.selectResource(requiredBundle.getAttribute("location"), requiredBundle.getSymbolicName(), VersionUtility.stringToVersionRange(bundleVersion));
            if (f == null) continue;
            urls.add(f.toURI().toURL());
        }
        LinkedList<URL> embeddedLibUrls = new LinkedList<URL>();
        for (URL jarFileUrl : urls) {
            embeddedLibUrls.addAll(UtilityMain.getBundleEmbeddedLibs(jarFileUrl));
        }
        urls.addAll(embeddedLibUrls);
        if (compilerTools) {
            File file = Utils.getJavaTools();
            if (file != null) {
                urls.add(file.toURI().toURL());
            } else if (!UtilityMain.isCompilerAvailable()) {
                if (UtilityMain.javaVersion() <= 8) {
                    UtilityMain.error("error.sdkRequired", System.getProperty("java.home"));
                } else {
                    UtilityMain.error("error.compilerMissing", new Object[0]);
                }
                System.exit(30);
                return;
            }
        }
        Thread thread = Thread.currentThread();
        ClassLoader originalContextLoader = thread.getContextClassLoader();
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        List<String> parentLastPackageList = LaunchManifest.parseHeaderList(parentLastPackages);
        ClassLoader parentLoader = bootstrapCLParent ? null : Utils.class.getClassLoader();
        PackageDelegateClassLoader cl = new PackageDelegateClassLoader(urlArray, parentLoader, parentLastPackageList);
        thread.setContextClassLoader(cl);
        try {
            Class<?> clazz = cl.loadClass(commandClass);
            Method m = clazz.getMethod("main", args.getClass());
            m.invoke(null, new Object[]{args});
        }
        finally {
            thread.setContextClassLoader(originalContextLoader);
        }
    }

    private static String format(String key, Object ... args) {
        String string = Utils.getResourceBundleString(key);
        return args == null || args.length == 0 ? string : MessageFormat.format(string, args);
    }

    private static void error(String key, Object ... args) {
        System.err.println(UtilityMain.format(key, args));
    }

    private static List<URL> getBundleEmbeddedLibs(final URL jarFileUrl) throws IOException, PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<List<URL>>(){

            @Override
            public List<URL> run() throws Exception {
                JarFile jarFile = new JarFile(URLDecoder.decode(jarFileUrl.getFile(), "utf-8"));
                LinkedList<URL> libs = new LinkedList<URL>();
                Attributes manifest = jarFile.getManifest().getMainAttributes();
                String rawBundleClasspath = manifest.getValue("Bundle-ClassPath");
                if (rawBundleClasspath != null) {
                    String[] bundleClassPaths;
                    HashSet<String> allValidBundleClassPaths = new HashSet<String>();
                    for (String bundleClassPath : bundleClassPaths = rawBundleClasspath.split(",")) {
                        if ((bundleClassPath = bundleClassPath.trim()).equals(".") || !bundleClassPath.endsWith(".jar")) continue;
                        allValidBundleClassPaths.add(bundleClassPath);
                    }
                    Enumeration<JarEntry> entries = jarFile.entries();
                    File tempDir = UtilityMain.createTempDir("was-cmdline");
                    tempDir.deleteOnExit();
                    int MAX_READ_SIZE = 512;
                    int offset = 0;
                    int read = 0;
                    byte[] buff = new byte[MAX_READ_SIZE];
                    while (entries.hasMoreElements()) {
                        int index;
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        if (!allValidBundleClassPaths.contains(entryName)) continue;
                        String fileName = entryName;
                        while ((index = fileName.indexOf("/")) != -1) {
                            fileName = fileName.substring(index + 1);
                        }
                        InputStream stream = jarFile.getInputStream(jarEntry);
                        File file = new File(tempDir, fileName);
                        file.deleteOnExit();
                        FileOutputStream fileStream = new FileOutputStream(file);
                        while ((read = stream.read(buff, offset, MAX_READ_SIZE)) > 0) {
                            fileStream.write(buff, 0, read);
                        }
                        fileStream.flush();
                        fileStream.close();
                        stream.close();
                        libs.add(file.toURI().toURL());
                    }
                }
                jarFile.close();
                return libs;
            }
        });
    }

    public static File createTempDir(String baseName) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        baseName = baseName + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 1000 attempts (tried " + baseName + "0 to " + baseName + 999 + ')');
    }

    public static File getInstallDir() {
        URL url;
        if (installDir == null && (url = Utils.class.getProtectionDomain().getCodeSource().getLocation()).getProtocol().equals("file")) {
            try {
                if (url.getAuthority() != null) {
                    url = new URL("file://" + url.toString().substring("file:".length()));
                }
                File f = new File(url.toURI());
                installDir = f.getParentFile().getParentFile();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return installDir;
    }

    private static boolean isCompilerAvailable() {
        try {
            return ToolProvider.getSystemJavaCompiler() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int javaVersion() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.valueOf(versionElements[0]) == 1 ? 1 : 0;
        return Integer.valueOf(versionElements[i]);
    }
}

