/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.SASException;
import com.ibm.ws.transport.iiop.security.SASInvalidMechanismException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CSI.EstablishContext;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSCompoundSecMechListConfig
implements Serializable {
    private boolean stateful;
    private final ArrayList<TSSCompoundSecMechConfig> mechs = new ArrayList();
    private final HashMap<String, TSSCompoundSecMechConfig> mechsMap = new HashMap();
    static final long serialVersionUID = -4692632365521558329L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public void add(TSSCompoundSecMechConfig mech) {
        this.mechs.add(mech);
    }

    public void add(TSSCompoundSecMechConfig mech, String mechOid) {
        this.add(mech);
        this.mechsMap.put(mechOid, mech);
    }

    public TSSCompoundSecMechConfig mechAt(int i) {
        return this.mechs.get(i);
    }

    public int size() {
        return this.mechs.size();
    }

    public TaggedComponent encodeIOR(Codec codec) throws Exception {
        CompoundSecMechList csml = new CompoundSecMechList();
        csml.stateful = this.stateful;
        csml.mechanism_list = new CompoundSecMech[this.mechs.size()];
        for (int i = 0; i < this.mechs.size(); ++i) {
            csml.mechanism_list[i] = this.mechs.get(i).encodeIOR(codec);
        }
        Any any = ORB.init().create_any();
        CompoundSecMechListHelper.insert((Any)any, (CompoundSecMechList)csml);
        return new TaggedComponent(33, codec.encode_value(any));
    }

    public static TSSCompoundSecMechListConfig decodeIOR(Codec codec, TaggedComponent taggedComponent) throws Exception {
        TSSCompoundSecMechListConfig result = new TSSCompoundSecMechListConfig();
        Any any = codec.decode_value(taggedComponent.component_data, CompoundSecMechListHelper.type());
        CompoundSecMechList csml = CompoundSecMechListHelper.extract((Any)any);
        result.setStateful(csml.stateful);
        for (int i = 0; i < csml.mechanism_list.length; ++i) {
            result.add(TSSCompoundSecMechConfig.decodeIOR(codec, csml.mechanism_list[i]));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Subject check(SSLSession session, EstablishContext msg, Codec codec) throws SASException {
        Subject result = null;
        String theOid = Util.getMechOidFromAuthToken(codec, msg);
        if (theOid != null) {
            TSSCompoundSecMechConfig tssCompoundSecMechConfig = this.mechsMap.get(theOid);
            if (tssCompoundSecMechConfig == null) throw new SASInvalidMechanismException();
            return tssCompoundSecMechConfig.check(session, msg, codec);
        }
        int i = 0;
        while (i < this.mechs.size()) {
            result = this.mechs.get(i).check(session, msg, codec);
            if (result != null) return result;
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    void toString(String spaces, StringBuilder buf) {
        buf.append(spaces).append("TSSCompoundSecMechListConfig: [\n");
        for (TSSCompoundSecMechConfig aConfig : this.mechs) {
            aConfig.toString(spaces + "  ", buf);
            buf.append("\n");
        }
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSCompoundSecMechListConfig.class);
    }
}

