/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={CustomUserRegistryFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class CustomUserRegistryFactory {
    static final String KEY_CUSTOM = "customUserRegistry";
    static final String KEY_CONFIG_ID = "config.id";
    static final String KEY_SERVICE_ID = "service.id";
    static final String KEY_TYPE_CUSTOM = "CUSTOM";
    static final String ID_SEPARATOR = "_";
    private final Map<String, com.ibm.websphere.security.UserRegistry> customUserRegistries = new ConcurrentHashMap<String, com.ibm.websphere.security.UserRegistry>();
    private final Map<String, ServiceRegistration<UserRegistry>> registrynRegistrationsToUnregister = new ConcurrentHashMap<String, ServiceRegistration<UserRegistry>>();
    static final long serialVersionUID = -3989024934893694675L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setCustomUserRegistry(com.ibm.websphere.security.UserRegistry externalUserRegistry, Map<String, Object> props) {
        String id = this.getId(props);
        this.customUserRegistries.put(id, externalUserRegistry);
    }

    private String getId(Map<String, Object> ref) {
        String id = (String)ref.get(KEY_CONFIG_ID);
        if (id == null) {
            id = Long.toString((Long)ref.get(KEY_SERVICE_ID));
        }
        id = "CUSTOM_" + id;
        return id;
    }

    protected synchronized void unsetCustomUserRegistry(Map<String, Object> props) {
        String id = this.getId(props);
        this.customUserRegistries.remove(id);
        ServiceRegistration<UserRegistry> registration = this.registrynRegistrationsToUnregister.remove(id);
        if (registration != null) {
            registration.unregister();
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.registerUserRegistryConfigurations(bundleContext);
    }

    private void registerUserRegistryConfigurations(BundleContext bundleContext) {
        for (Map.Entry<String, com.ibm.websphere.security.UserRegistry> entry : this.customUserRegistries.entrySet()) {
            Hashtable<String, String> userRegistryCProperties = new Hashtable<String, String>();
            userRegistryCProperties.put("com.ibm.ws.security.registry.type", KEY_TYPE_CUSTOM);
            userRegistryCProperties.put(KEY_CONFIG_ID, entry.getKey());
            CustomUserRegistryWrapper userRegistry = new CustomUserRegistryWrapper(entry.getValue());
            ServiceRegistration userRegistryConfigurationRegistration = bundleContext.registerService(UserRegistry.class, (Object)userRegistry, userRegistryCProperties);
            this.registrynRegistrationsToUnregister.put(entry.getKey(), (ServiceRegistration<UserRegistry>)userRegistryConfigurationRegistration);
        }
    }

    @Deactivate
    protected void deactivate() {
        for (String id : this.registrynRegistrationsToUnregister.keySet()) {
            ServiceRegistration<UserRegistry> registration = this.registrynRegistrationsToUnregister.remove(id);
            registration.unregister();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CustomUserRegistryFactory.class);
    }
}

