/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class LDAPUtils {
    private static final TraceComponent tc = Tr.register(LDAPUtils.class);
    private static final int START_CN_OFFSET = 3;
    static final long serialVersionUID = -8352650017272236473L;

    private LDAPUtils() {
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public static String getCNFromDN(String dn) {
        String cn;
        block3: {
            cn = null;
            try {
                LdapName ldapDN = new LdapName(dn);
                for (int i = ldapDN.size() - 1; i > -1; --i) {
                    if (!ldapDN.get(i).toLowerCase().startsWith("cn=")) continue;
                    cn = ldapDN.get(i).substring(3);
                    break;
                }
            }
            catch (InvalidNameException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Unable to getCNFromDN: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        return cn;
    }
}

