/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationService;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.cert.Certificate;
import javax.security.auth.Subject;

public class Authentication {
    private static TraceComponent tc = SibTr.register(Authentication.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.Authentication";
    private MessagingAuthenticationService messagingAuthenticationService = null;
    private RuntimeSecurityService runtimeSecurityService = RuntimeSecurityService.SINGLETON_INSTANCE;

    public Subject login(String userName, String password) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)new Object[]{userName, "Password Not Traced"});
        }
        Subject result = null;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = this.runtimeSecurityService.createUnauthenticatedSubject();
        } else if (this.messagingAuthenticationService != null) {
            result = this.messagingAuthenticationService.login(userName, password);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)result);
        }
        return result;
    }

    public Subject login(Subject subject) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)subject);
        }
        Subject result = null;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = this.runtimeSecurityService.createUnauthenticatedSubject();
        } else if (this.messagingAuthenticationService != null) {
            result = this.messagingAuthenticationService.login(subject);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)result);
        }
        return result;
    }

    public Subject login(byte[] securityToken, String securityTokenType) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)securityTokenType);
        }
        Subject result = null;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = this.runtimeSecurityService.createUnauthenticatedSubject();
        } else if (this.messagingAuthenticationService != null) {
            result = this.messagingAuthenticationService.login(securityToken, securityTokenType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)result);
        }
        return result;
    }

    public Subject login(Certificate[] certificates) throws MessagingAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)certificates);
        }
        Subject result = null;
        if (!this.runtimeSecurityService.isMessagingSecure()) {
            result = this.runtimeSecurityService.createUnauthenticatedSubject();
        } else if (this.messagingAuthenticationService != null) {
            result = this.messagingAuthenticationService.login(certificates);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogin", (Object)result);
        }
        return result;
    }

    public void logout(Subject subject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogout");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.Authenticationlogout");
        }
    }

    public void setMessagingAuthenticationService(MessagingAuthenticationService messagingAuthenticationService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthenticationsetMessagingAuthenticationService", (Object)messagingAuthenticationService);
        }
        this.messagingAuthenticationService = messagingAuthenticationService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.AuthenticationsetMessagingAuthenticationService");
        }
    }
}

