/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.impl;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.net.InetAddress;
import javax.net.ssl.SSLSession;

public class ConversationMetaDataImpl
implements ConversationMetaData {
    private static final TraceComponent tc;
    private String chainName;
    private boolean containsSSLChannel;
    private boolean containsHTTPTunnelChannel;
    private boolean isInbound;
    private static Class sslChannelFactoryClass;
    private static Class httptChannelFactoryClass;
    private static Class tcpProxyChannelFactoryClass;
    private boolean isTrusted = false;
    private ConnectionLink baseLink;

    public ConversationMetaDataImpl(ChainData chainData, ConnectionLink baseLink) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{chainData, baseLink});
        }
        this.isTrusted = false;
        this.chainName = chainData.getName();
        this.isInbound = chainData.getType() == FlowType.INBOUND;
        this.baseLink = baseLink;
        ChannelData[] channelData = chainData.getChannelList();
        this.containsSSLChannel = false;
        this.containsHTTPTunnelChannel = false;
        for (int i = 0; i < channelData.length; ++i) {
            if (sslChannelFactoryClass != null) {
                this.containsSSLChannel |= channelData[i].getFactoryType().equals(sslChannelFactoryClass);
            }
            if (httptChannelFactoryClass != null) {
                this.containsHTTPTunnelChannel |= channelData[i].getFactoryType().equals(httptChannelFactoryClass);
            }
            if (tcpProxyChannelFactoryClass == null) continue;
            this.isTrusted |= channelData[i].getFactoryType().equals(tcpProxyChannelFactoryClass);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("chainName=" + this.chainName + "\nisInbound=" + this.isInbound + "\ncontainsSSLChannel=" + this.containsSSLChannel + "\ncontainsHTTPTunnelChannel=" + this.containsHTTPTunnelChannel + "\nisTrusted=" + this.isTrusted));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public String getChainName() {
        return this.chainName;
    }

    @Override
    public boolean containsSSLChannel() {
        return this.containsSSLChannel;
    }

    @Override
    public boolean containsHTTPTunnelChannel() {
        return this.containsHTTPTunnelChannel;
    }

    @Override
    public boolean isInbound() {
        return this.isInbound;
    }

    @Override
    public boolean isTrusted() {
        return this.isTrusted;
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteAddress");
        }
        InetAddress result = null;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null) {
            result = tcpContext.getRemoteAddress();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteAddress", (Object)result);
        }
        return result;
    }

    @Override
    public int getRemotePort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemotePort");
        }
        int portNumber = 0;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null) {
            portNumber = tcpContext.getRemotePort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemotePort", (Object)("" + portNumber));
        }
        return portNumber;
    }

    @Override
    public SSLSession getSSLSession() {
        SSLConnectionContext sslConnCtx;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSSLSession");
        }
        SSLSession sslSession = null;
        TCPConnectionContext tcpContext = null;
        ConnectionLink connLinkRef = this.baseLink.getDeviceLink();
        if (connLinkRef != null && (tcpContext = (TCPConnectionContext)connLinkRef.getChannelAccessor()) != null && (sslConnCtx = tcpContext.getSSLContext()) != null) {
            sslSession = sslConnCtx.getSession();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSSLSession", sslSession);
        }
        return sslSession;
    }

    static {
        block8: {
            block7: {
                tc = SibTr.register(ConversationMetaData.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationMetaDataImpl.java, SIB.comms, WASX.SIB, uu1215.01 1.17");
                }
                try {
                    sslChannelFactoryClass = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                }
                catch (ClassNotFoundException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Could not find SSL Channel class");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            try {
                httptChannelFactoryClass = Class.forName("com.ibm.ws.httptunnel.channel.WSHttpTunnelOutboundChannelFactory");
            }
            catch (ClassNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Could not find HTTP Tunnel Channel class");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
        }
    }
}

