/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.client.rest.ClientProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class MessengerConnectionHelper {
    private static final TraceComponent tc = Tr.register(MessengerConnectionHelper.class);
    private JSSEHelper jsseHelper;
    private final String host;
    private final int port;
    private final int readTimeoutMillis;
    private final String sslConfig;
    private final ObjectName objectName;
    private JMXConnector connector = null;
    private SSLSocketFactory sslSF = null;
    private MBeanServerConnection mbsc = null;
    private boolean connected = false;
    static final long serialVersionUID = 9080439412789609940L;

    /*
     * WARNING - void declaration
     */
    public MessengerConnectionHelper(JSSEHelper jsseHelper, String host, int port, int readTimeoutMillis, String sslConfig) {
        this.jsseHelper = jsseHelper;
        this.host = host;
        this.port = port;
        this.readTimeoutMillis = readTimeoutMillis;
        this.sslConfig = sslConfig;
        try {
            this.objectName = new ObjectName("WebSphere:feature=collectiveMember,type=SingletonServiceMessenger,name=SingletonServiceMessenger");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            void e;
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper", (String)"78", (Object)this, (Object[])new Object[]{jsseHelper, host, port, readTimeoutMillis, sslConfig});
            throw new IllegalStateException("Unable to create object name", (Throwable)e);
        }
        catch (NullPointerException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper", (String)"80", (Object)this, (Object[])new Object[]{jsseHelper, host, port, readTimeoutMillis, sslConfig});
            throw new IllegalStateException("Unable to create object name due to a null pointer", e);
        }
    }

    private JMXConnector createConnector(String host, int port) throws IOException, MalformedURLException, SSLConfigurationNotAvailableException {
        this.sslSF = this.getSSLSocketFactory();
        HashMap<String, Object> environment = new HashMap<String, Object>();
        environment.put("com.ibm.ws.jmx.connector.client.CUSTOM_SSLSOCKETFACTORY", this.sslSF);
        environment.put("jmx.remote.protocol.provider.pkgs", "com.ibm.ws.jmx.connector.client");
        environment.put("jmx.remote.credentials", "com.ibm.ws.jmx.connector.client.CLIENT_CERT_AUTH");
        environment.put("com.ibm.ws.jmx.connector.client.rest.readTimeout", this.readTimeoutMillis);
        environment.put("com.ibm.ws.jmx.connector.client.disableURLHostnameVerification", Boolean.TRUE);
        environment.put("com.ibm.ws.jmx.connector.client.rest.notificationFetchInterval", 10000);
        JMXServiceURL serviceURL = new JMXServiceURL("REST", host, port, "/IBMJMXConnectorREST");
        return new ClientProvider().newJMXConnector(serviceURL, environment);
    }

    @FFDCIgnore(value={SSLConfigurationNotAvailableException.class})
    private SSLSocketFactory getSSLSocketFactory() throws IOException, SSLConfigurationNotAvailableException {
        SSLContext context = null;
        SSLSocketFactory factory = null;
        String failureMessage = "Could not get an SSL context for the specified SSL configuration: " + this.sslConfig + ". Check that the specified SSL configuration is correct.";
        try {
            context = this.jsseHelper.getSSLContext(this.sslConfig, null, null, false);
        }
        catch (SSLConfigurationNotAvailableException e) {
            throw e;
        }
        catch (SSLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper", (String)"124", (Object)this, (Object[])new Object[0]);
            throw new IOException(failureMessage, e);
        }
        if (context == null) {
            throw new IllegalStateException(failureMessage);
        }
        try {
            factory = context.getSocketFactory();
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper", (String)"134", (Object)this, (Object[])new Object[0]);
            throw e;
        }
        if (factory == null) {
            throw new IllegalStateException("Factory from context was null");
        }
        return factory;
    }

    private IOException asExplainedIOException(Exception e) throws IOException {
        String message = "A network, communication or security error has occured while trying to invoke the MBean " + this.objectName + " on the target server. Cause: " + e.getMessage();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)message, (Object[])new Object[]{e});
        }
        return new IOException(message, e);
    }

    @Trivial
    @FFDCIgnore(value={IOException.class, SSLConfigurationNotAvailableException.class})
    private void connect() throws IOException {
        if (!this.connected) {
            try {
                this.setupConnection(this.host, this.port);
                this.connected = true;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"MESSENGER_CONNECTOR_CONNECTED", (Object[])new Object[]{this.host, this.port});
                }
            }
            catch (SSLConfigurationNotAvailableException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught SSLConfigurationNotAvailableException. Attepmt to connect to target server host=" + this.host + ", port=" + this.port), (Object[])new Object[0]);
                }
                throw this.asExplainedIOException((Exception)((Object)e));
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught IOException. Attepmt to connect to target server host=" + this.host + ", port=" + this.port), (Object[])new Object[0]);
                }
                throw this.asExplainedIOException(e);
            }
        }
    }

    private void setupConnection(String host, int port) throws IOException, SSLConfigurationNotAvailableException {
        this.disconnectRemoteConnection();
        this.connector = this.createConnector(host, port);
        this.connector.connect();
        this.mbsc = this.connector.getMBeanServerConnection();
        this.connected = true;
    }

    public Object invoke(String operationName, @Sensitive Object[] params, String[] signature) throws IOException {
        this.connect();
        return this.doInvoke(this.mbsc, this.objectName, operationName, params, signature);
    }

    @FFDCIgnore(value={IOException.class})
    public void disconnectRemoteConnection() {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught IOException. Attepmt to disconnect from the server.", (Object[])new Object[0]);
            }
        }
        finally {
            this.connected = false;
        }
    }

    @Trivial
    String buildInvokeDebugString(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        StringBuffer invokeString = new StringBuffer("invoke(");
        invokeString.append(objectName.toString());
        invokeString.append(", ");
        invokeString.append(operationName);
        invokeString.append(", ");
        invokeString.append("{ ");
        for (Object param : params) {
            if (param == null) {
                invokeString.append("null, ");
                continue;
            }
            invokeString.append(param.toString());
            invokeString.append(", ");
        }
        invokeString.delete(invokeString.length() - 2, invokeString.length());
        invokeString.append(" }");
        invokeString.append(", ");
        invokeString.append("{ ");
        for (String sig : signature) {
            invokeString.append(sig);
            invokeString.append(", ");
        }
        invokeString.delete(invokeString.length() - 2, invokeString.length());
        invokeString.append(" }");
        invokeString.append(")");
        return invokeString.toString();
    }

    private void markDisconnected() {
        this.connected = false;
        Tr.info((TraceComponent)tc, (String)"MESSENGER_CONNECTION_LOST", (Object[])new Object[0]);
    }

    @FFDCIgnore(value={ConnectException.class, IOException.class, RuntimeMBeanException.class, MBeanException.class, InstanceNotFoundException.class})
    Object doInvoke(MBeanServerConnection mbsc, ObjectName objectName, String operationName, @Sensitive Object[] params, String[] signature) throws IOException {
        if (mbsc == null) {
            throw new IllegalStateException("MBeanServerConnection is null, bootstrap() did not succeed.");
        }
        try {
            return mbsc.invoke(objectName, operationName, params, signature);
        }
        catch (ConnectException e) {
            this.markDisconnected();
            throw this.asExplainedIOException(e);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException || e.getMessage().contains("CWWKX0206E")) {
                this.markDisconnected();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException message: " + e.getMessage()), (Object[])new Object[0]);
            }
            throw this.asExplainedIOException(e);
        }
        catch (InstanceNotFoundException e) {
            String message = "Could not find " + objectName + " on the target server.";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException", (Object[])new Object[]{message, e});
            }
            throw new IllegalStateException(message, e);
        }
        catch (ReflectionException e) {
            Object[] objectArray = new Object[5];
            objectArray[0] = mbsc;
            objectArray[1] = objectName;
            objectArray[2] = operationName;
            objectArray[3] = "<sensitive java.lang.Object[]>";
            objectArray[4] = signature;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.collective.singleton.internal.MessengerConnectionHelper", (String)"322", (Object)this, (Object[])objectArray);
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            String message = "An error occurred while invoking " + invokeString + " on the target MBean " + objectName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught ReflectionException", (Object[])new Object[]{message, e});
            }
            throw new IllegalStateException(message, e);
        }
        catch (RuntimeMBeanException e) {
            Throwable cause = e.getCause();
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught RuntimeMBeanException (will re-throw cause) while executing " + invokeString + ". Caught " + cause.toString()), (Object[])new Object[]{e, cause});
            }
            if (e.getMessage().contains("CWWKX9002E")) {
                this.markDisconnected();
            }
            throw (RuntimeException)e.getCause();
        }
        catch (MBeanException e) {
            Throwable cause = e.getCause();
            String invokeString = this.buildInvokeDebugString(objectName, operationName, params, signature);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught MBeanException (will re-throw cause) while executing " + invokeString + ". Caught " + cause.toString()), (Object[])new Object[]{e, cause});
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            String message = "Caught an unexpected exception during " + invokeString + ". Caught " + cause.toString();
            throw new IllegalStateException(message, cause);
        }
    }

    protected void setJMXConnector(JMXConnector conn) {
        this.connector = conn;
    }

    protected void setJSSEHelper(JSSEHelper jsse) {
        this.jsseHelper = jsse;
    }
}

