/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.SingletonService;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import com.ibm.wsspi.collective.singleton.extender.SingletonServiceExtender;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CollectiveSingletonElector
implements Elector {
    private static final TraceComponent tc = Tr.register(CollectiveSingletonElector.class);
    private static final String SINGLETON_REPO_PATH = "/sys.was.system/singleton/";
    private SingletonService.SingletonScope myScope;
    private SingletonServiceExtender service;
    private ServiceEndpointIdentity leader;
    private boolean electionStarted = false;
    private Thread electionRunnerThread;
    private final Set<ServiceEndpointIdentity> candidateIdentities = new HashSet<ServiceEndpointIdentity>();
    static final long serialVersionUID = -843803955181285126L;

    public void setSingletonService(SingletonServiceExtender service) {
        this.service = service;
    }

    public void start() {
    }

    public void stop() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = 8013299562998855803L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                CollectiveSingletonElector.this.electionRunnerThread.interrupt();
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }

    public void participantRegistered(ServiceEndpointIdentity participant) {
    }

    public void participantUnregistered(ServiceEndpointIdentity participant) {
    }

    public void candidateRegistered(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.add(candidate);
        Tr.info((TraceComponent)tc, (String)"CANDIDATE_REGISTERED", (Object[])new Object[]{candidate});
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -9020171180466841393L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                if (!CollectiveSingletonElector.this.electionStarted) {
                    CollectiveSingletonElector.this.electionStarted = true;
                    CollectiveSingletonElector.this.electionRunnerThread = new Thread(new ElectionRunner());
                    CollectiveSingletonElector.this.electionRunnerThread.start();
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
    }

    public void candidateUnregistered(ServiceEndpointIdentity candidate) {
        this.candidateIdentities.remove(candidate);
        Tr.info((TraceComponent)tc, (String)"CANDIDATE_UNREGISTERED", (Object[])new Object[]{candidate});
    }

    public Set<ServiceEndpointIdentity> getParticipants() {
        return null;
    }

    public Set<ServiceEndpointIdentity> getCandidates() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ServiceEndpointIdentity getLeader() {
        ServiceEndpointIdentity result;
        block4: {
            result = ServiceEndpointIdentityImpl.NULL_IDENTITY;
            try {
                String path = SINGLETON_REPO_PATH + this.service.getName() + "/leader";
                String canonicalID = (String)this.service.getRepositoryMember().getData(path);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("From repository got: " + canonicalID), (Object[])new Object[0]);
                }
                result = new ServiceEndpointIdentityImpl();
                result.fromCanonicalForm(canonicalID);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Converted from repostiory got: " + result), (Object[])new Object[0]);
                }
            }
            catch (IOException path) {
                void e;
                FFDCFilter.processException((Throwable)path, (String)"com.ibm.ws.collective.singleton.internal.CollectiveSingletonElector", (String)"239", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Error in CollectiveSingletonElector.getLeader - error: " + e), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public String getIdentity() {
        return "CollectiveSingletonElector";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class ElectionRunner
    implements Runnable {
        static final long serialVersionUID = -6522954025621848970L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ElectionRunner() {
        }

        private ServiceEndpointIdentity elect() {
            int numCandidates;
            Object[] candidates = CollectiveSingletonElector.this.candidateIdentities.toArray();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Election runner SingletonService reference: " + CollectiveSingletonElector.this.service), (Object[])new Object[0]);
            }
            if ((numCandidates = candidates.length) == 0) {
                throw new IllegalStateException("There are no registered candidates for service " + CollectiveSingletonElector.this.service.getName());
            }
            Random random = new Random();
            ServiceEndpointIdentity leader = (ServiceEndpointIdentity)candidates[random.nextInt(numCandidates)];
            return leader;
        }

        /*
         * WARNING - void declaration
         */
        private void storeLeaderToRepository(ServiceEndpointIdentity leader) {
            block2: {
                try {
                    String path = CollectiveSingletonElector.SINGLETON_REPO_PATH + CollectiveSingletonElector.this.service.getName() + "/leader";
                    boolean bl = CollectiveSingletonElector.this.service.getRepositoryMember().create(path, (Object)leader.toCanonicalForm());
                }
                catch (Exception path) {
                    void e;
                    FFDCFilter.processException((Throwable)path, (String)"com.ibm.ws.collective.singleton.internal.CollectiveSingletonElector$ElectionRunner", (String)"162", (Object)this, (Object[])new Object[]{leader});
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug((TraceComponent)tc, (String)("Could not store leader in repository, with exception " + e), (Object[])new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CollectiveSingletonElector.this.leader = this.elect();
            CollectiveSingletonElector.this.service.leaderElected(CollectiveSingletonElector.this.leader);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Leader " + CollectiveSingletonElector.this.leader + " is elected."), (Object[])new Object[0]);
            }
            this.storeLeaderToRepository(CollectiveSingletonElector.this.leader);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Leader " + CollectiveSingletonElector.this.leader + " is stored in repository."), (Object[])new Object[0]);
            }
            ElectionRunner electionRunner = this;
            synchronized (electionRunner) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collective.singleton.internal.CollectiveSingletonElector$ElectionRunner", (String)"190", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ElectionRunner interrupted, exiting.", (Object[])new Object[0]);
                    }
                    CollectiveSingletonElector.this.electionStarted = false;
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ElectionRunner.class);
        }
    }
}

