/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogFileHandle;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RLSControllerImpl;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.File;
import java.util.ArrayList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class LogHandle {
    private static final TraceComponent tc;
    private static String RECOVERY_FILE_1_NAME;
    private static String RECOVERY_FILE_2_NAME;
    private final MultiScopeRecoveryLog _recoveryLog;
    private final String _serviceName;
    private final int _serviceVersion;
    private final String _serverName;
    private final String _logName;
    private final String _logDirectory;
    private final int _logFileSize;
    private final int _maxLogFileSize;
    private LogFileHandle _file1;
    private LogFileHandle _file2;
    private LogFileHandle _activeFile;
    private LogFileHandle _inactiveFile;
    private long _recordSequenceNumber;
    private ArrayList<ReadableLogRecord> _recoveredRecords;
    public int _physicalFreeBytes;
    private byte[] _serviceData;
    FailureScope _failureScope;
    static final long serialVersionUID = -8575578242474364504L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    LogHandle(MultiScopeRecoveryLog recoveryLog, String serviceName, int serviceVersion, String serverName, String logName, String logDirectory, int logFileSize, int maxLogFileSize, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"LogHandle", (Object)new Object[]{recoveryLog, serviceName, new Integer(serviceVersion), serverName, logName, logDirectory, logFileSize, maxLogFileSize, fs});
        }
        this._recoveryLog = recoveryLog;
        this._serviceName = serviceName;
        this._serviceVersion = serviceVersion;
        this._serverName = serverName;
        this._logName = logName;
        this._logDirectory = logDirectory;
        this._maxLogFileSize = maxLogFileSize;
        this._logFileSize = logFileSize;
        this._failureScope = fs;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"LogHandle", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void openLog() throws LogOpenException, LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        block71: {
            block74: {
                long file2FRSN;
                long file1FRSN;
                block77: {
                    block76: {
                        long file2Date;
                        long file1Date;
                        block75: {
                            int file2Status;
                            int file1Status;
                            block73: {
                                block72: {
                                    boolean coldStart;
                                    if (tc.isEntryEnabled()) {
                                        Tr.entry((TraceComponent)tc, (String)"openLog", (Object)this);
                                    }
                                    if (this._activeFile != null) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogOpenException");
                                        }
                                        throw new LogOpenException(null);
                                    }
                                    if (!RLSUtils.createDirectoryTree(this._logDirectory)) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogAllocationException");
                                        }
                                        throw new LogAllocationException(null);
                                    }
                                    this.createWarningFile();
                                    String osName = System.getProperty("os.name");
                                    if (osName.equalsIgnoreCase("HPUX") || osName.equalsIgnoreCase("HP-UX")) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Running on HP-UX, open logs with initial size of maximum log size");
                                        }
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._maxLogFileSize, this._failureScope);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._maxLogFileSize, this._failureScope);
                                    } else {
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._logFileSize, this._failureScope);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._logFileSize, this._failureScope);
                                    }
                                    this._activeFile = null;
                                    this._inactiveFile = null;
                                    if (this._file1.fileExists() != this._file2.fileExists()) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)"One of the recovery log files has been deleted. Recovery can't complete");
                                        }
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                        }
                                        throw new LogCorruptedException(null);
                                    }
                                    boolean bl = coldStart = !this._file1.fileExists();
                                    if (coldStart) {
                                        this._file1.becomeActive();
                                        Tr.info((TraceComponent)tc, (String)"CWRLS0007_RECOVERY_LOG_NOT_EXIST", (Object)this._logDirectory);
                                    }
                                    try {
                                        this._file1.fileOpen();
                                    }
                                    catch (LogIncompatibleException logIncompatibleException) {
                                        void exc;
                                        FFDCFilter.processException((Throwable)logIncompatibleException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"343", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"391", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                                        }
                                        throw exc;
                                    }
                                    catch (InternalLogException exc) {
                                        void ile;
                                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"363", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"331", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)ile);
                                        }
                                        throw ile;
                                    }
                                    catch (LogAllocationException ile) {
                                        void lae;
                                        FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"371", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)lae, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"339", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)lae);
                                        }
                                        throw lae;
                                    }
                                    catch (Throwable lae) {
                                        FFDCFilter.processException((Throwable)lae, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"379", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"347", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                        }
                                        throw new InternalLogException((Throwable)exc);
                                    }
                                    try {
                                        this._file2.fileOpen();
                                    }
                                    catch (LogIncompatibleException exc) {
                                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"392", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"449", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                                        }
                                        throw exc;
                                    }
                                    catch (InternalLogException exc) {
                                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"412", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"369", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)ile);
                                        }
                                        throw ile;
                                    }
                                    catch (LogAllocationException ile) {
                                        FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"420", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)lae, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"377", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)lae);
                                        }
                                        throw lae;
                                    }
                                    catch (Throwable lae) {
                                        FFDCFilter.processException((Throwable)lae, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"428", (Object)this, (Object[])new Object[0]);
                                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"385", (Object)this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                                        }
                                        throw new InternalLogException((Throwable)exc);
                                    }
                                    if (this._file1 == null || this._file2 == null) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event((TraceComponent)tc, (String)"Neither of the recovery log files are valid. Recovery can't complete");
                                        }
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                        }
                                        throw new LogCorruptedException(null);
                                    }
                                    if (this._file2.logFileHeader().status() == 16) {
                                        if (this._file1.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not valid"));
                                            }
                                            this._activeFile = this._file1;
                                            this._inactiveFile = this._file2;
                                            this._inactiveFile.resetHeader(this._activeFile);
                                            break block71;
                                        } else {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("The only valid recovery log file '" + this._file1.fileName() + "' is not in ACTIVE state"));
                                            }
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                            }
                                            throw new LogCorruptedException(null);
                                        }
                                    }
                                    if (this._file1.logFileHeader().status() == 16) {
                                        if (this._file2.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not valid"));
                                            }
                                            this._activeFile = this._file2;
                                            this._inactiveFile = this._file1;
                                            this._inactiveFile.resetHeader(this._activeFile);
                                            break block71;
                                        } else {
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("The only valid recovery log file '" + this._file2.fileName() + "' is not in ACTIVE state"));
                                            }
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                                            }
                                            throw new LogCorruptedException(null);
                                        }
                                    }
                                    file1Status = this._file1.logFileHeader().status();
                                    file2Status = this._file2.logFileHeader().status();
                                    file1FRSN = this._file1.logFileHeader().firstRecordSequenceNumber();
                                    file2FRSN = this._file2.logFileHeader().firstRecordSequenceNumber();
                                    file1Date = this._file1.logFileHeader().date();
                                    file2Date = this._file2.logFileHeader().date();
                                    if (file1Status != 4 || file2Status == 4) break block72;
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not ACTIVE"));
                                    }
                                    this._activeFile = this._file1;
                                    this._inactiveFile = this._file2;
                                    break block71;
                                }
                                if (file1Status == 4 || file2Status != 4) break block73;
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not ACTIVE"));
                                }
                                this._activeFile = this._file2;
                                this._inactiveFile = this._file1;
                                break block71;
                            }
                            if (file1Status != 4 || file2Status != 4) break block74;
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Both recovery files are in ACTIVE state. Determine target file by examining timestamp");
                            }
                            if (file1Date <= file2Date) break block75;
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as it was created after '" + this._file2.fileName() + "'"));
                            }
                            this._activeFile = this._file1;
                            this._inactiveFile = this._file2;
                            break block71;
                        }
                        if (file1Date >= file2Date) break block76;
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as it was created after '" + this._file1.fileName() + "'"));
                        }
                        this._activeFile = this._file2;
                        this._inactiveFile = this._file1;
                        break block71;
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Both recovery files have the same timestamp. Determine target file by examining first record sequence numbers");
                    }
                    if (file1FRSN != 0L || file2FRSN != 0L) break block77;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as both files are empty"));
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block71;
                }
                if (file1FRSN > file2FRSN) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file1.fileName() + "' as it has as the highest record sequence number"));
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block71;
                } else if (file1FRSN < file2FRSN) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Selecting recovery log file '" + this._file2.fileName() + "' as it has as the highest record sequence number"));
                    }
                    this._activeFile = this._file2;
                    this._inactiveFile = this._file1;
                    break block71;
                } else {
                    this._file1 = null;
                    this._file2 = null;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Neither of the recovery log files are valid as they have the same record sequence number. Recovery can't complete");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
                    }
                    throw new LogCorruptedException(null);
                }
            }
            this._file1 = null;
            this._file2 = null;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The recovery lof files are in an undefined state");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogCorruptedException");
            }
            throw new LogCorruptedException(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Selected log file '" + this._activeFile.fileName() + "' for recovery"));
        }
        this._serviceData = this._activeFile.getServiceData();
        if (this._activeFile == this._file1) {
            this._file2.setServiceData(this._serviceData);
        } else {
            this._file1.setServiceData(this._serviceData);
        }
        try {
            this._recoveredRecords = this.readRecords();
        }
        catch (InternalLogException file1Status) {
            void exc;
            FFDCFilter.processException((Throwable)file1Status, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"627", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"554", (Object)this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"638", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.openLog", (String)"565", (Object)this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    private ArrayList<ReadableLogRecord> readRecords() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readRecords", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readRecords", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        ArrayList<ReadableLogRecord> records = null;
        this._recordSequenceNumber = this._activeFile.logFileHeader().firstRecordSequenceNumber();
        ReadableLogRecord readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        if (readableLogRecord != null) {
            records = new ArrayList<ReadableLogRecord>();
        }
        while (readableLogRecord != null) {
            records.add(readableLogRecord);
            long realSequenceNumber = readableLogRecord.getSequenceNumber();
            if (this._recordSequenceNumber != realSequenceNumber) {
                if (realSequenceNumber > this._recordSequenceNumber) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("byte-by-byte scanning found records. Adjusting record sequence number:" + this._recordSequenceNumber + " to:" + realSequenceNumber));
                    }
                    this._recordSequenceNumber = realSequenceNumber;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ERROR byte-by-byte scanning found records. Expected to find record sequence number:" + this._recordSequenceNumber + " but found :" + realSequenceNumber));
                    }
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.recoverylog.spi.LogHandle.readRecords", (String)"685", (Object)this, (Object[])new Object[]{String.valueOf(this._recordSequenceNumber), String.valueOf(realSequenceNumber)});
                }
            }
            ++this._recordSequenceNumber;
            readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Next record sequence number is " + this._recordSequenceNumber));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readRecords", records);
        }
        return records;
    }

    /*
     * WARNING - void declaration
     */
    void keypointStarting() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointStarting", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._activeFile == this._file1) {
            this._activeFile = this._file2;
            this._inactiveFile = this._file1;
        } else {
            this._activeFile = this._file1;
            this._inactiveFile = this._file2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keypoint processing is switching to log file " + this._activeFile.fileName()));
        }
        try {
            this._activeFile.keypointStarting(this._recordSequenceNumber);
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"792", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", (String)"690", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"798", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", (String)"696", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointStarting", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointStarting");
        }
    }

    /*
     * WARNING - void declaration
     */
    void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            this._file1.fileClose();
            this._file2.fileClose();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"841", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.closeLog", (String)"736", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"847", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.closeLog", (String)"742", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        this._file1 = null;
        this._file2 = null;
        this._activeFile = null;
        this._recoveredRecords = null;
        this._physicalFreeBytes = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    byte[] getServiceData() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServiceData", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        byte[] serviceData = this._activeFile.getServiceData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServiceData", (Object)RLSUtils.toHexString(serviceData, 32));
        }
        return serviceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"force", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"force", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        Object object = RLSControllerImpl.SUSPEND_LOCK;
        synchronized (object) {
            while (RLSControllerImpl.isSuspended()) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for RecoveryLogService to resume");
                    }
                    RLSControllerImpl.SUSPEND_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"931", (Object)this, (Object[])new Object[0]);
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.force", (String)"834", (Object)this);
                }
            }
            if (Configuration._isSnapshotSafe) {
                this._activeFile.force();
            }
        }
        if (!Configuration._isSnapshotSafe) {
            this._activeFile.force();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"force");
        }
    }

    LogFileHeader logFileHeader() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logFileHeader", (Object)this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"logFileHeader", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        LogFileHeader logFileHeader = this._activeFile.logFileHeader();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logFileHeader", (Object)logFileHeader);
        }
        return logFileHeader;
    }

    ArrayList<ReadableLogRecord> recoveredRecords() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"recoveredRecords", this._recoveredRecords);
        }
        return this._recoveredRecords;
    }

    void setServiceData(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServiceData", (Object)new Object[]{RLSUtils.toHexString(serviceData, 32), this});
        }
        if (this._file1 == null || this._file2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setServiceData", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._serviceData = serviceData;
        this._file1.setServiceData(serviceData);
        this._file2.setServiceData(serviceData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServiceData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void keypoint() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object)this);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe));
            }
            Object object = RLSControllerImpl.SUSPEND_LOCK;
            synchronized (object) {
                while (RLSControllerImpl.isSuspended()) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Waiting for RecoveryLogService to resume");
                        }
                        RLSControllerImpl.SUSPEND_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        void exc;
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1089", (Object)this, (Object[])new Object[0]);
                        com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypoint", (String)"923", (Object)this);
                    }
                }
                if (Configuration._isSnapshotSafe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe));
                    }
                    this.keypointInternal();
                }
            }
            if (!Configuration._isSnapshotSafe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe));
                }
                this.keypointInternal();
            }
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1127", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypoint", (String)"932", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)exc);
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void keypointInternal() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypointInternal");
        }
        try {
            this.force();
            this._activeFile.keypointComplete();
            if (this._activeFile == this._file1) {
                this._file2.becomeInactive();
            } else {
                this._file1.becomeInactive();
            }
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1172", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointInternal", (String)"952", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointInternal", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1178", (Object)this, (Object[])new Object[0]);
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.keypointInternal", (String)"958", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypointInternal", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypointInternal");
        }
    }

    /*
     * WARNING - void declaration
     */
    void resizeLog(int targetSize) throws InternalLogException, LogFullException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resizeLog", (Object)new Object[]{this, targetSize});
        }
        if (this._activeFile == null || this._inactiveFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            this._file1.fileExtend(targetSize);
            this._file2.fileExtend(targetSize);
        }
        catch (LogAllocationException logAllocationException) {
            void exc;
            FFDCFilter.processException((Throwable)logAllocationException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1221", (Object)this, (Object[])new Object[]{targetSize});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", (String)"1612", (Object)this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog", (Object)"WriteOperationFailedException");
            }
            throw new WriteOperationFailedException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1249", (Object)this, (Object[])new Object[]{targetSize});
            com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", (String)"1555", (Object)this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resizeLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Log file " + this._activeFile.fileName() + " now has " + this._physicalFreeBytes + " bytes of storage available"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resizeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected WriteableLogRecord getWriteableLogRecord(int recordLength) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)new Object[]{this, recordLength});
        }
        WriteableLogRecord writeableLogRecord = null;
        boolean keyPointRequired = false;
        LogHandle logHandle = this;
        synchronized (logHandle) {
            if (this._activeFile.freeBytes() < recordLength + WriteableLogRecord.HEADER_SIZE) {
                keyPointRequired = true;
            } else {
                try {
                    writeableLogRecord = this._activeFile.getWriteableLogRecord(recordLength, this._recordSequenceNumber++);
                }
                catch (InternalLogException internalLogException) {
                    void exc;
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1328", (Object)this, (Object[])new Object[]{recordLength});
                    com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1112", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)exc);
                    }
                    throw exc;
                }
            }
        }
        if (keyPointRequired) {
            try {
                this._recoveryLog.keypoint();
            }
            catch (LogClosedException logClosedException) {
                void exc;
                FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1345", (Object)this, (Object[])new Object[]{recordLength});
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1129", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1351", (Object)this, (Object[])new Object[]{recordLength});
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1135", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)exc);
                }
                throw exc;
            }
            catch (LogIncompatibleException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1357", (Object)this, (Object[])new Object[]{recordLength});
                com.ibm.tx.util.logging.FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", (String)"1204", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)exc);
                }
                throw new InternalLogException(exc);
            }
            writeableLogRecord = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriteableLogRecord", (Object)writeableLogRecord);
        }
        return writeableLogRecord;
    }

    protected int getFreeSpace() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFreeSpace", (Object)this);
        }
        int freeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFreeSpace", (Object)freeBytes);
        }
        return freeBytes;
    }

    protected void writeLogRecord(LogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeLogRecord", (Object)logRecord);
        }
        this._activeFile.writeLogRecord(logRecord);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeLogRecord");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createWarningFile() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createWarningFile", (Object)this);
            }
            try {
                File file = new File(this._logDirectory, "DO NOT DELETE LOG FILES");
                if (!file.exists()) {
                    file.createNewFile();
                }
            }
            catch (Throwable file) {
                void e;
                FFDCFilter.processException((Throwable)file, (String)"com.ibm.ws.recoverylog.spi.LogHandle", (String)"1427", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"createWarningFile", (Object)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createWarningFile");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register(LogHandle.class);
        tc = Tr.register(LogHandle.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
        RECOVERY_FILE_1_NAME = "log1";
        RECOVERY_FILE_2_NAME = "log2";
    }
}

