/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.facade.IFacade;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SRTRequestContext
implements Cloneable {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTRequestContext";
    protected Hashtable webappToSessionMap;
    protected SRTServletRequest request;
    private Stack boundaries = new Stack();

    public SRTRequestContext(SRTServletRequest request) {
        this.request = request;
        this.webappToSessionMap = new Hashtable();
    }

    public void sessionPreInvoke(WebApp webapp) {
        HttpSession session;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sessionPreInvoke", "entry");
        }
        if ((session = (HttpSession)this.webappToSessionMap.get(webapp)) == null) {
            IHttpSessionContext sessionContext;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sessionPreInvoke", "null session, find or create");
            }
            HttpSession httpSession = session = (sessionContext = webapp.getSessionContext()) != null ? sessionContext.sessionPreInvoke(this.request, (HttpServletResponse)this.request.getResponse()) : null;
            if (session != null) {
                this.webappToSessionMap.put(webapp, session);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sessionPreInvoke", "exit");
        }
    }

    public boolean isRequestedSessionIdValid(WebApp webapp) {
        HttpSession session = this.getSession(false, webapp);
        return webapp.getSessionContext().isRequestedSessionIdValid(this.request, session);
    }

    public void sessionPostInvoke() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sessionPostInvoke", "entry");
            logger.logp(Level.FINE, CLASS_NAME, "sessionPostInvoke", "exit");
        }
    }

    public HttpSession getSession(boolean create, WebApp webapp) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSession", " entry");
        }
        SRTServletRequest localrequest = this.request;
        HttpSession session = (HttpSession)this.webappToSessionMap.get(webapp);
        if (session != null && webapp.getSessionContext().isValid(session, localrequest, create)) {
            return (HttpSession)((IFacade)session).getFacade();
        }
        session = webapp.getSessionContext().getIHttpSession(localrequest, (HttpServletResponse)this.request.getResponse(), create);
        if (session == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "getSession", "null");
            }
            return null;
        }
        this.webappToSessionMap.put(webapp, session);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSession", " exit");
        }
        return (HttpSession)((IFacade)session).getFacade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "finish", " entry");
        }
        try {
            Enumeration webapps = this.webappToSessionMap.keys();
            while (webapps.hasMoreElements()) {
                WebApp wa = (WebApp)webapps.nextElement();
                HttpSession s = (HttpSession)this.webappToSessionMap.get(wa);
                IHttpSessionContext ctx = wa.getSessionContext();
                if (ctx != null) {
                    wa.getSessionContext().sessionPostInvoke(s);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "finish", "Session Context was null so session data will not be persisted.");
            }
        }
        finally {
            this.webappToSessionMap.clear();
            this.boundaries.clear();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", " exit");
            }
        }
    }

    public String encodeURL(WebApp webapp, HttpServletRequest request, String arg0) {
        HttpSession session = (HttpSession)this.webappToSessionMap.get(webapp);
        if (session != null) {
            return webapp.getSessionContext().encodeURL(session, request, arg0);
        }
        return arg0;
    }

    public void setCurrWebAppBoundary(WebApp webapp) {
        this.boundaries.push(webapp);
    }

    public void rollBackBoundary() {
        this.boundaries.pop();
    }

    public boolean isWithinModule(WebApp app) {
        WebApp currWebAppBoundary = (WebApp)this.boundaries.peek();
        return currWebAppBoundary.equals(app);
    }

    public boolean isWithinApplication(WebApp app) {
        WebApp currWebAppBoundary = (WebApp)this.boundaries.peek();
        return currWebAppBoundary.getApplicationName().equals(app.getApplicationName());
    }

    protected Object clone(SRTServletRequest clonedRequest) throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        SRTRequestContext clonedRequestContext = (SRTRequestContext)super.clone();
        if (this.boundaries != null) {
            clonedRequestContext.boundaries = (Stack)this.boundaries.clone();
        }
        if (this.webappToSessionMap != null) {
            clonedRequestContext.webappToSessionMap = (Hashtable)this.webappToSessionMap.clone();
        }
        clonedRequestContext.request = clonedRequest;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " clone -->" + clonedRequestContext);
        }
        return clonedRequestContext;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        this.request = null;
        this.webappToSessionMap = null;
        this.boundaries = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }
}

