/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.osgi.interceptor.RegisterRequestInterceptor;
import com.ibm.ws.webcontainer.servlet.WsocHandler;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterChain
implements FilterChain {
    private ArrayList _filters = new ArrayList(5);
    private int _currentFilterIndex = -1;
    private int _numberOfFilters = 0;
    private RequestProcessor requestProcessor;
    private boolean _filtersDefined = false;
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.WebAppFilterChain";
    private WebApp webapp = null;

    public WebAppFilterChain() {
    }

    public WebAppFilterChain(WebApp webapp) {
        this.webapp = webapp;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doFilter", "entry");
        }
        try {
            if (!this._filtersDefined) {
                this.invokeTarget(request, response);
            } else {
                ++this._currentFilterIndex;
                if (this._currentFilterIndex < this._numberOfFilters) {
                    FilterInstanceWrapper wrapper = (FilterInstanceWrapper)this._filters.get(this._currentFilterIndex);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "doFilter", "executing filter -->" + wrapper.getFilterName());
                    }
                    wrapper.doFilter(request, response, this);
                } else {
                    this.invokeTarget(request, response);
                }
            }
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof FileNotFoundException) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "FileNotFound");
            } else if (!this.webapp.getDestroyed().booleanValue()) {
                FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "82", this);
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "Can not invoke filter because application is destroyed", e);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "exit");
            }
            throw e;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            FFDCWrapper.processException(th, "com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", "89", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doFilter", "exit");
            }
            throw new ServletErrorReport(th);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "doFilter", "exit");
        }
    }

    private void invokeTarget(ServletRequest request, ServletResponse response) throws Exception {
        if (this.requestProcessor != null) {
            HttpServletResponse httpResponse;
            HttpServletRequest httpRequest = ServletUtil.unwrapRequest(request, HttpServletRequest.class);
            if (!RegisterRequestInterceptor.notifyRequestInterceptors("AfterFilters", httpRequest, httpResponse = (HttpServletResponse)ServletUtil.unwrapResponse(response, HttpServletResponse.class))) {
                WsocHandler wsocHandler = ((com.ibm.ws.webcontainer.osgi.webapp.WebApp)this.webapp).getWebSocketHandler();
                if (wsocHandler != null) {
                    if (wsocHandler.isWsocRequest(request)) {
                        wsocHandler.handleRequest(httpRequest, httpResponse);
                    } else {
                        this.requestProcessor.handleRequest(request, response);
                    }
                } else {
                    this.requestProcessor.handleRequest(request, response);
                }
            }
        } else {
            this.webapp.finishedFiltersWithNullTarget(request, response, this.requestProcessor);
        }
    }

    public void addFilter(FilterInstanceWrapper fiw) {
        this._filtersDefined = true;
        ++this._numberOfFilters;
        this._filters.add(fiw);
    }

    public void setRequestProcessor(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }
}

