/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;

public class UninstallAsset {
    IFixInfo fixInfo;
    String name;
    String displayName;
    ProvisioningFeatureDefinition pd;
    UninstallAssetType type;

    public UninstallAsset(IFixInfo fixInfo) {
        this.fixInfo = fixInfo;
        this.name = fixInfo.getId();
        this.pd = null;
        this.type = UninstallAssetType.fix;
    }

    public UninstallAsset(ProvisioningFeatureDefinition pd) {
        String ext = pd.getBundleRepositoryType();
        String shortName = InstallUtils.getShortName(pd);
        this.name = pd.getSymbolicName();
        this.pd = pd;
        this.displayName = ext == null || ext.isEmpty() ? shortName : ext + ":" + shortName;
        this.type = UninstallAssetType.feature;
    }

    public IFixInfo getIFixInfo() {
        return this.fixInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.name;
    }

    public UninstallAssetType getType() {
        return this.type;
    }

    public ProvisioningFeatureDefinition getProvisioningFeatureDefinition() {
        return this.pd;
    }

    public String uninstalledLogMsg() {
        if (this.type == UninstallAssetType.feature) {
            return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALLED_FEATURE", this.toString()).replaceAll("CWWKF1306I:", "").trim();
        }
        if (this.type == UninstallAssetType.fix) {
            return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_UNINSTALLED_FIX", this.toString()).replaceAll("CWWKF1307I:", "").trim();
        }
        return "";
    }

    public static enum UninstallAssetType {
        feature,
        fix;

    }
}

