/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class LdapURL {
    public static final String SCHEMENAME = "ldap";
    public static final String SCHEMENAMESSL = "ldaps";
    private final String ENCODING = "UTF-8";
    private final String ldapurl;
    private String scheme;
    private String hostport;
    private String host;
    private String port;
    private String dn;
    private String attributesBuffer;
    private String[] attributes;
    private String scope;
    private String filter;
    private String[] extensions;
    private boolean parsedOK;
    private String parseMsg;
    private boolean parsedone;
    private int length;
    private static final TraceComponent tc = Tr.register(LdapURL.class);
    static final long serialVersionUID = 1521005374053490979L;

    public LdapURL(String a_url) {
        this.ldapurl = a_url;
        this.length = a_url.length();
        this.parsedOK = false;
        this.parseMsg = "Unparsed";
        this.parsedone = false;
    }

    public LdapURL() {
        this.ldapurl = null;
        this.parsedOK = false;
        this.parseMsg = "Unparsed";
        this.parsedone = false;
    }

    private void parse() throws UnsupportedEncodingException {
        int colonDoubleSlash = this.ldapurl.indexOf("://");
        this.schemeParser(0, colonDoubleSlash);
        if (this.parsedone) {
            return;
        }
        int lastSlash = this.ldapurl.indexOf("/", colonDoubleSlash + 3);
        this.hostPortParser(colonDoubleSlash + 3, lastSlash);
        if (this.parsedone) {
            return;
        }
        int firstQ = this.ldapurl.indexOf("?", lastSlash + 1);
        this.searchBaseDnParser(lastSlash + 1, firstQ);
        if (this.parsedone) {
            return;
        }
        int secondQ = this.ldapurl.indexOf("?", firstQ + 1);
        this.attributesParser(firstQ + 1, secondQ);
        if (this.parsedone) {
            return;
        }
        int thirdQ = this.ldapurl.indexOf("?", secondQ + 1);
        this.scopeParser(secondQ + 1, thirdQ);
        if (this.parsedone) {
            return;
        }
        int fourthQ = this.ldapurl.indexOf("?", thirdQ + 1);
        this.filterParser(thirdQ + 1, fourthQ);
        if (this.parsedone) {
            return;
        }
        this.extensionsParser(fourthQ + 1);
        if (this.parsedone) {
            return;
        }
    }

    private void schemeParser(int beginIndex, int endIndex) {
        if (endIndex > beginIndex) {
            this.scheme = this.ldapurl.substring(beginIndex, endIndex);
            if (this.scheme.compareToIgnoreCase(SCHEMENAME) == 0 || this.scheme.compareToIgnoreCase(SCHEMENAMESSL) == 0) {
                this.parseMsg = "scheme parsed";
            } else {
                this.parseMsg = "invalid ldap url";
                this.parsedone = true;
            }
        } else {
            this.parseMsg = "invalid ldap url";
            this.parsedone = true;
        }
    }

    private void hostPortParser(int beginIndex, int endIndex) throws UnsupportedEncodingException {
        if (endIndex > beginIndex) {
            this.hostport = this.ldapurl.substring(beginIndex, endIndex);
            this.hostPortSubParser();
            this.parseMsg = "hostport parsed";
        } else if (endIndex == beginIndex) {
            this.parseMsg = "no hostport";
        } else if (endIndex == -1) {
            if (this.length >= beginIndex + 1) {
                this.hostport = this.ldapurl.substring(beginIndex);
                this.hostPortSubParser();
                this.parseMsg = "hostport parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void hostPortSubParser() throws UnsupportedEncodingException {
        if (this.hostport.length() > 0) {
            int colon = this.hostport.lastIndexOf(":");
            if (colon == -1) {
                this.host = URLDecoder.decode(this.hostport, "UTF-8");
            } else {
                String hostBuf = this.hostport.substring(0, colon);
                this.host = URLDecoder.decode(hostBuf, "UTF-8");
                String portBuf = this.hostport.substring(colon + 1);
                this.port = URLDecoder.decode(portBuf, "UTF-8");
            }
        }
    }

    private void searchBaseDnParser(int beginIndex, int endIndex) throws UnsupportedEncodingException {
        if (endIndex > beginIndex) {
            String dnBuf = this.ldapurl.substring(beginIndex, endIndex);
            this.dn = URLDecoder.decode(dnBuf, "UTF-8");
            this.parseMsg = "dn parsed";
        } else if (endIndex == beginIndex) {
            this.parseMsg = "invalid ldap url";
            this.parsedone = true;
        } else if (endIndex == -1) {
            if (this.length >= beginIndex + 1) {
                String dnBuf = this.ldapurl.substring(beginIndex);
                this.dn = URLDecoder.decode(dnBuf, "UTF-8");
                this.parseMsg = "dn parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void attributesParser(int beginIndex, int endIndex) {
        if (endIndex > beginIndex) {
            this.attributesBuffer = this.ldapurl.substring(beginIndex, endIndex);
            this.attributesSubParser();
            this.parseMsg = "attributes parsed";
        } else if (endIndex == beginIndex) {
            this.parseMsg = "no attributes";
        } else if (endIndex == -1) {
            if (this.length >= beginIndex + 1) {
                this.attributesBuffer = this.ldapurl.substring(beginIndex);
                this.attributesSubParser();
                this.parseMsg = "attributes parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void attributesSubParser() {
        this.attributes = this.attributesBuffer.split(",");
    }

    private void scopeParser(int beginIndex, int endIndex) {
        if (endIndex > beginIndex) {
            this.scope = this.ldapurl.substring(beginIndex, endIndex);
            this.parseMsg = "scope parsed";
        } else if (endIndex == beginIndex) {
            this.parseMsg = "no scope";
        } else if (endIndex == -1) {
            if (this.length >= beginIndex + 1) {
                this.scope = this.ldapurl.substring(beginIndex);
                this.parseMsg = "scope parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void filterParser(int beginIndex, int endIndex) throws UnsupportedEncodingException {
        if (endIndex > beginIndex) {
            String filterBuf = this.ldapurl.substring(beginIndex, endIndex);
            this.filter = URLDecoder.decode(filterBuf, "UTF-8");
            this.parseMsg = "filter parsed";
        } else if (endIndex == beginIndex) {
            this.parseMsg = "no filter";
        } else if (endIndex == -1) {
            if (this.length >= beginIndex + 1) {
                String filterBuf = this.ldapurl.substring(beginIndex);
                this.filter = URLDecoder.decode(filterBuf, "UTF-8");
                this.parseMsg = "filter parsed";
                this.parsedOK = true;
            }
            this.parsedone = true;
        }
    }

    private void extensionsParser(int fromIndex) {
        if (this.length >= fromIndex + 1) {
            String extensionsBuffer = this.ldapurl.substring(fromIndex);
            int arrayIndex = 0;
            int bufferLen = extensionsBuffer.length();
            int beginIndex = 0;
            arrayIndex = 0;
            while (bufferLen > beginIndex + 1) {
                int endIndex = extensionsBuffer.indexOf(",", beginIndex);
                if (endIndex > 0) {
                    this.extensions[arrayIndex] = extensionsBuffer.substring(beginIndex, endIndex);
                } else if (endIndex == -1) {
                    this.extensions[arrayIndex] = extensionsBuffer.substring(beginIndex);
                    break;
                }
                beginIndex = endIndex + 1;
                ++arrayIndex;
            }
            this.parseMsg = "extensions parsed";
        }
        this.parsedOK = true;
        this.parsedone = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean parsedOK() throws WIMSystemException {
        try {
            if (!this.parsedone) {
                this.parse();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapURL", (String)"293", (Object)this, (Object[])new Object[0]);
            throw new WIMSystemException("GENERIC", Tr.formatMessage((TraceComponent)tc, (String)"GENERIC", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString())));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapURL", (String)"298", (Object)this, (Object[])new Object[0]);
            e.getMessage();
            this.parsedOK = false;
        }
        return this.parsedOK;
    }

    public String get_parseMsg() {
        return this.parseMsg;
    }

    public String get_url() {
        return this.ldapurl;
    }

    public String get_host() {
        return this.host;
    }

    public String get_port() {
        return this.port;
    }

    public String get_dn() {
        return this.dn;
    }

    public String[] get_attributes() {
        if (this.attributes != null) {
            return (String[])this.attributes.clone();
        }
        return new String[0];
    }

    public String get_scope() {
        return this.scope;
    }

    public String get_filter() {
        return this.filter;
    }

    public int get_searchScope() {
        int searchScope = 0;
        String scopeBuf = this.get_scope();
        if (scopeBuf != null) {
            if (scopeBuf.compareToIgnoreCase("base") == 0) {
                searchScope = 0;
            } else if (scopeBuf.compareToIgnoreCase("one") == 0) {
                searchScope = 1;
            } else if (scopeBuf.compareToIgnoreCase("sub") == 0) {
                searchScope = 2;
            }
        }
        return searchScope;
    }

    public String[] get_extensions() {
        return (String[])this.extensions.clone();
    }

    public String toString() {
        return this.ldapurl;
    }
}

