/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.management.security.ManagementRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AdministratorRole
implements ManagementRole {
    private static final TraceComponent tc = Tr.register(AdministratorRole.class);
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_GROUP = "group";
    private final Set<String> users = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    static final long serialVersionUID = 3839022921917832039L;

    protected synchronized void activate(Map<String, Object> props) {
        this.resetBindings();
        this.updateBindings(props);
    }

    protected synchronized void modify(Map<String, Object> props) {
        this.resetBindings();
        this.updateBindings(props);
    }

    protected synchronized void deactivate() {
        this.resetBindings();
    }

    private void resetBindings() {
        this.users.clear();
        this.groups.clear();
    }

    private void updateBindings(Map<String, Object> props) {
        HashSet<String> badUsers = new HashSet<String>();
        String[] cfgUsers = (String[])props.get(CFG_KEY_USER);
        if (cfgUsers != null) {
            for (String user : cfgUsers) {
                if (badUsers.contains(user) || user.trim().isEmpty() || this.users.add(user)) continue;
                Tr.error((TraceComponent)tc, (String)"ROLE_ENTRY_DUPLICATE", (Object[])new Object[]{this.getRoleName(), CFG_KEY_USER, user});
                badUsers.add(user);
                this.users.remove(user);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Administrator role user binding", (Object[])new Object[]{this.users});
        }
        HashSet<String> badGroups = new HashSet<String>();
        String[] cfgGroups = (String[])props.get(CFG_KEY_GROUP);
        if (cfgGroups != null) {
            for (String group : cfgGroups) {
                if (badGroups.contains(group) || group.trim().isEmpty() || this.groups.add(group)) continue;
                Tr.error((TraceComponent)tc, (String)"ROLE_ENTRY_DUPLICATE", (Object[])new Object[]{this.getRoleName(), CFG_KEY_GROUP, group});
                badGroups.add(group);
                this.groups.remove(group);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Administrator role group binding", (Object[])new Object[]{this.groups});
        }
    }

    @Override
    public String getRoleName() {
        return "Administrator";
    }

    @Override
    public synchronized Set<String> getUsers() {
        return this.users;
    }

    @Override
    public synchronized Set<String> getGroups() {
        return this.groups;
    }
}

