/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.app.deploy.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedEARApplicationInfo;
import com.ibm.ws.container.service.app.deploy.internal.ApplicationInfoImpl;
import com.ibm.ws.container.service.app.deploy.internal.EARApplicationInfoImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationInfoFactoryImpl
implements ApplicationInfoFactory {
    private final AtomicServiceReference<J2EENameFactory> j2eeNameFactory = new AtomicServiceReference("j2eeNameFactory");
    private final Set<String> names = new HashSet<String>();
    static final long serialVersionUID = 6232436640731165768L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setJ2eeNameFactory(ServiceReference<J2EENameFactory> ref) {
        this.j2eeNameFactory.setReference(ref);
    }

    public void unsetJ2eeNameFactory(ServiceReference<J2EENameFactory> ref) {
        this.j2eeNameFactory.unsetReference(ref);
    }

    protected void activate(ComponentContext cc) {
        this.j2eeNameFactory.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.j2eeNameFactory.deactivate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String reserveName(String preferredName) {
        String name = preferredName;
        Set<String> set = this.names;
        synchronized (set) {
            if (!this.names.add(name)) {
                int number = 2;
                do {
                    name = preferredName + '_' + number;
                    ++number;
                } while (!this.names.add(name));
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreserveName(String name) {
        Set<String> set = this.names;
        synchronized (set) {
            this.names.remove(name);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExtendedApplicationInfo createApplicationInfo(String appMgrName, String preferredName, Container container, ApplicationClassesContainerInfo appClassesContainerInfo, NestedConfigHelper configHelper) {
        J2EEName j2eeName = ((J2EENameFactory)this.j2eeNameFactory.getService()).create(appMgrName, null, null);
        String name = this.reserveName(preferredName);
        ApplicationInfoImpl appInfo = new ApplicationInfoImpl(name, j2eeName, container, configHelper);
        try {
            NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            cache.addToCache(ApplicationInfo.class, (Object)appInfo);
            cache.addToCache(ApplicationClassesContainerInfo.class, (Object)appClassesContainerInfo);
        }
        catch (UnableToAdaptException cache) {
            void ex;
            FFDCFilter.processException((Throwable)cache, (String)"com.ibm.ws.container.service.app.deploy.internal.ApplicationInfoFactoryImpl", (String)"91", (Object)this, (Object[])new Object[]{appMgrName, preferredName, container, appClassesContainerInfo, configHelper});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"ApplicationInfoFactoryImpl_createApplicationInfo");
        }
        return appInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ExtendedEARApplicationInfo createEARApplicationInfo(String appMgrName, String preferredName, Container container, ApplicationClassesContainerInfo appClassesContainerInfo, NestedConfigHelper configHelper, Container libDirContainer, AppClassLoaderFactory classLoaderFactory) {
        J2EEName j2eeName = ((J2EENameFactory)this.j2eeNameFactory.getService()).create(appMgrName, null, null);
        EARApplicationInfoImpl appInfo = null;
        try {
            String name = this.reserveName(preferredName);
            appInfo = new EARApplicationInfoImpl(name, j2eeName, container, configHelper, libDirContainer, classLoaderFactory);
            NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
            cache.addToCache(ApplicationInfo.class, (Object)appInfo);
            cache.addToCache(ApplicationClassesContainerInfo.class, (Object)appClassesContainerInfo);
        }
        catch (UnableToAdaptException name) {
            void ex;
            FFDCFilter.processException((Throwable)name, (String)"com.ibm.ws.container.service.app.deploy.internal.ApplicationInfoFactoryImpl", (String)"112", (Object)this, (Object[])new Object[]{appMgrName, preferredName, container, appClassesContainerInfo, configHelper, libDirContainer, classLoaderFactory});
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"ApplicationInfoFactoryImpl_createEARApplicationInfo");
        }
        return appInfo;
    }

    @Override
    public void destroyApplicationInfo(ApplicationInfo appInfo) {
        this.unreserveName(appInfo.getName());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationInfoFactoryImpl.class);
    }
}

