/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.security.internal.jacc;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.audit.AuditAuthResult;
import com.ibm.websphere.security.audit.AuditAuthenticationResult;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.audit.context.AuditThreadContext;
import com.ibm.ws.ejbcontainer.EJBComponentMetaData;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.ejbcontainer.EJBRequestData;
import com.ibm.ws.ejbcontainer.security.internal.EJBAccessDeniedException;
import com.ibm.ws.ejbcontainer.security.internal.EJBAuthorizationHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authorization.jacc.JaccService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EJBJaccAuthorizationHelper
implements EJBAuthorizationHelper {
    private static final TraceComponent tc = Tr.register(EJBJaccAuthorizationHelper.class);
    private AtomicServiceReference<JaccService> jaccServiceRef = null;
    public HashMap<String, Object> ejbAuditHashMap = new HashMap();
    protected AuditManager auditManager;
    private static ThreadLocal<AuditThreadContext> threadLocal = new ThreadLocal();
    static final long serialVersionUID = -8231286558213137193L;

    public EJBJaccAuthorizationHelper(AtomicServiceReference<JaccService> jaccServiceRef) {
        this.jaccServiceRef = jaccServiceRef;
    }

    public void populateAuditEJBHashMap(EJBRequestData request) {
        EJBMethodMetaData methodMetaData = request.getEJBMethodMetaData();
        Object[] methodArguments = request.getMethodArguments();
        String applicationName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getApplication();
        String moduleName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getModule();
        String methodName = methodMetaData.getMethodName();
        String methodInterface = methodMetaData.getEJBMethodInterface().specName();
        String methodSignature = methodMetaData.getMethodSignature();
        String beanName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getComponent();
        List<Object> methodParameters = null;
        if (methodArguments != null && methodArguments.length > 0) {
            methodParameters = Arrays.asList(methodArguments);
        }
        this.ejbAuditHashMap.put("methodArguments", methodArguments);
        this.ejbAuditHashMap.put("applicationName", applicationName);
        this.ejbAuditHashMap.put("moduleName", moduleName);
        this.ejbAuditHashMap.put("methodName", methodName);
        this.ejbAuditHashMap.put("methodInterface", methodInterface);
        this.ejbAuditHashMap.put("methodSignature", methodSignature);
        this.ejbAuditHashMap.put("beanName", beanName);
        this.ejbAuditHashMap.put("methodParameters", methodParameters);
    }

    @Override
    public void authorizeEJB(EJBRequestData request, Subject subject) throws EJBAccessDeniedException {
        this.auditManager = new AuditManager();
        Object req = this.auditManager.getHttpServletRequest();
        Object webRequest = this.auditManager.getWebRequest();
        String realm = this.auditManager.getRealm();
        EJBMethodMetaData methodMetaData = request.getEJBMethodMetaData();
        Object[] methodArguments = request.getMethodArguments();
        String applicationName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getApplication();
        String moduleName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getModule();
        String methodName = methodMetaData.getMethodName();
        String methodInterface = methodMetaData.getEJBMethodInterface().specName();
        String methodSignature = methodMetaData.getMethodSignature();
        String beanName = methodMetaData.getEJBComponentMetaData().getJ2EEName().getComponent();
        List<Object> methodParameters = null;
        this.populateAuditEJBHashMap(request);
        Object bean = request.getBeanInstance();
        EnterpriseBean ejb = null;
        if (bean instanceof EnterpriseBean) {
            ejb = (EnterpriseBean)bean;
        }
        if (methodArguments != null && methodArguments.length > 0) {
            methodParameters = Arrays.asList(methodArguments);
        }
        boolean isAuthorized = ((JaccService)this.jaccServiceRef.getService()).isAuthorized(applicationName, moduleName, beanName, methodName, methodInterface, methodSignature, methodParameters, (Object)ejb, subject);
        String authzUserName = subject.getPrincipals(WSPrincipal.class).iterator().next().getName();
        if (!isAuthorized) {
            Tr.audit((TraceComponent)tc, (String)"EJB_JACC_AUTHZ_FAILED", (Object[])new Object[]{authzUserName, methodName, applicationName});
            AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.FAILURE, authzUserName, "BASIC", null, "failure");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_03, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, Integer.valueOf("403")});
            throw new EJBAccessDeniedException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages", (String)"EJB_JACC_AUTHZ_FAILED", (Object[])new Object[]{authzUserName, methodName, applicationName}, (String)"CWWKS9406A: Authorization by the JACC provider failed. The user is not granted access to any of the required roles."));
        }
        AuditAuthenticationResult auditAuthResult = new AuditAuthenticationResult(AuditAuthResult.SUCCESS, authzUserName, "BASIC", null, "success");
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHZ_03, (Object[])new Object[]{auditAuthResult, this.ejbAuditHashMap, req, webRequest, realm, subject, Integer.valueOf("200")});
    }

    @Override
    public boolean isCallerInRole(EJBComponentMetaData cmd, EJBRequestData request, String roleName, String roleLink, Subject subject) {
        String applicationName = cmd.getJ2EEName().getApplication();
        String moduleName = cmd.getJ2EEName().getModule();
        String beanName = cmd.getJ2EEName().getComponent();
        String methodName = request.getEJBMethodMetaData().getMethodName();
        Object[] methodArguments = request.getMethodArguments();
        List<Object> methodParameters = null;
        if (methodArguments != null && methodArguments.length > 0) {
            methodParameters = Arrays.asList(methodArguments);
        }
        EnterpriseBean bean = null;
        if (request.getBeanInstance() instanceof EnterpriseBean) {
            bean = (EnterpriseBean)request.getBeanInstance();
        }
        return ((JaccService)this.jaccServiceRef.getService()).isSubjectInRole(applicationName, moduleName, beanName, methodName, methodParameters, roleName, (Object)bean, subject);
    }
}

