/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.krb5.Krb5Helper;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SpnegoTokenHelper {
    private static final TraceComponent tc;
    private static Oid SPNEGO_MECH_OID;
    static final long serialVersionUID = 6653793280107778576L;

    public static String buildSpnegoAuthorizationFromCallerSubject(String spn, int lifetime, boolean delegate) throws WSSecurityException, GSSException, PrivilegedActionException {
        Subject subject = WSSubject.getCallerSubject();
        if (subject == null) {
            subject = WSSubject.getRunAsSubject();
        }
        return SpnegoTokenHelper.buildSpnegoAuthorizationFromSubject(spn, subject, lifetime, delegate);
    }

    public static String buildSpnegoAuthorizationFromSubject(String spn, Subject subject, int lifetime, boolean delegate) throws GSSException, PrivilegedActionException {
        Krb5Helper.checkSpn(spn);
        return Krb5Helper.buildSpnegoAuthorizationFromSubjectCommon(spn, subject, lifetime, delegate);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromNativeCreds(final String spn, final int lifetime, final boolean delegate) throws GSSException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn(spn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -6063323207179772536L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws PrivilegedActionException, GSSException {
                    String token = null;
                    String savedProperty = Krb5Helper.setPropertyAsNeeded("javax.security.auth.useSubjectCredsOnly", "false");
                    try {
                        GSSCredential gssCred = Krb5Helper.getGSSCred(null, null, SPNEGO_MECH_OID, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
                        token = Krb5Helper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    }
                    finally {
                        Krb5Helper.restorePropertyAsNeeded("javax.security.auth.useSubjectCredsOnly", savedProperty, "false");
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"129", null, (Object[])new Object[]{spn, lifetime, delegate});
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUpn(final String spn, final String upn, final String jaasLoginContextEntry, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn(spn);
        Krb5Helper.checkUpn(upn);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -8771378281528230433L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws LoginException, PrivilegedActionException, GSSException {
                    String token = null;
                    String savedProperty = Krb5Helper.setPropertyAsNeeded("javax.security.auth.useSubjectCredsOnly", "false");
                    try {
                        Subject subject = SpnegoTokenHelper.doKerberosLogin(jaasLoginContextEntry, upn, null);
                        GSSCredential gssCred = (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){
                            static final long serialVersionUID = -3876628782473623535L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public Object run() throws GSSException, Exception {
                                GSSCredential innerCred = Krb5Helper.getGSSCred(null, upn, SPNEGO_MECH_OID, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
                                return innerCred;
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class);
                            }
                        });
                        token = Krb5Helper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    }
                    finally {
                        Krb5Helper.restorePropertyAsNeeded("javax.security.auth.useSubjectCredsOnly", savedProperty, "false");
                    }
                    return token;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"195", null, (Object[])new Object[]{spn, upn, jaasLoginContextEntry, lifetime, delegate});
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    public static String buildSpnegoAuthorizationFromUseridPassword(String spn, String userid, @Sensitive String password, int lifetime, boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        return SpnegoTokenHelper.buildSpnegoAuthorizationFromUseridPassword(spn, userid, password, "JAASClient", lifetime, delegate);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildSpnegoAuthorizationFromUseridPassword(final String spn, final String userid, final @Sensitive String password, final String jaasLoginContextEntry, final int lifetime, final boolean delegate) throws GSSException, LoginException, PrivilegedActionException {
        String token;
        Krb5Helper.checkSpn(spn);
        Krb5Helper.checkUpn(userid);
        Krb5Helper.checkPassword(password);
        try {
            token = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = 5246391761545194704L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws LoginException, GSSException, PrivilegedActionException {
                    String innerToken = null;
                    Subject useSubject = SpnegoTokenHelper.doKerberosLogin(jaasLoginContextEntry, userid, password);
                    GSSCredential gssCred = (GSSCredential)Subject.doAs(useSubject, new PrivilegedExceptionAction<Object>(){
                        static final long serialVersionUID = 2903546241992746685L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() throws GSSException, Exception {
                            GSSCredential innerCred = Krb5Helper.getGSSCred(null, userid, SPNEGO_MECH_OID, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
                            return innerCred;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                    innerToken = Krb5Helper.buildSpnegoAuthorization(gssCred, spn, lifetime, delegate);
                    return innerToken;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            Object[] objectArray = new Object[6];
            objectArray[0] = spn;
            objectArray[1] = userid;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = jaasLoginContextEntry;
            objectArray[4] = lifetime;
            objectArray[5] = delegate;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"279", null, (Object[])objectArray);
            Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
            if (general instanceof LoginException) {
                throw (LoginException)general;
            }
            if (general instanceof GSSException) {
                throw (GSSException)general;
            }
            throw e;
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    private static Subject doKerberosLogin(String jaasLoginContextEntry, final String upn, final @Sensitive String password) throws LoginException {
        Subject subject;
        block4: {
            subject = null;
            if (jaasLoginContextEntry == null) {
                jaasLoginContextEntry = "JAASClient";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("jaasLoginContextEntry: " + jaasLoginContextEntry), (Object[])new Object[0]);
                }
            }
            final String inJaasLoginContextEntry = jaasLoginContextEntry;
            try {
                subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){
                    static final long serialVersionUID = 5228473330192668780L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Subject run() throws LoginException {
                        WSCallbackHandlerImpl callbackHandler = new WSCallbackHandlerImpl(upn, password);
                        LoginContext lc = new LoginContext(inJaasLoginContextEntry, (CallbackHandler)callbackHandler);
                        lc.login();
                        return lc.getSubject();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(4.class);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = jaasLoginContextEntry;
                objectArray[1] = upn;
                objectArray[2] = "<sensitive java.lang.String>";
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"320", null, (Object[])objectArray);
                Throwable general = Krb5Helper.getGeneralCause((PrivilegedActionException)e);
                if (!(general instanceof LoginException)) break block4;
                throw (LoginException)general;
            }
        }
        return subject;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        block2: {
            tc = Tr.register(SpnegoTokenHelper.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
            try {
                SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
            }
            catch (GSSException gSSException) {
                void ex;
                FFDCFilter.processException((Throwable)gSSException, (String)"com.ibm.wsspi.security.token.SpnegoTokenHelper", (String)"333", null, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Unexpected GSSExecption: " + ex), (Object[])new Object[0]);
            }
        }
    }
}

