/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsManagedConnectionFactory;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.sib.api.jms.impl.JmsConnectionImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsJMSContextImpl;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.resource.ResourceException;

public class JmsManagedConnectionFactoryImpl
implements JmsManagedConnectionFactory,
ApiJmsConstants {
    private static final long serialVersionUID = 2796080016458361701L;
    private static TraceComponent tc = SibTr.register(JmsManagedConnectionFactoryImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    JmsJcaConnectionFactory jcaConnectionFactory = null;

    JmsManagedConnectionFactoryImpl(JmsJcaConnectionFactory jcaConnectionFactory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsManagedConnectionFactoryImpl", (Object)jcaConnectionFactory);
        }
        this.jcaConnectionFactory = jcaConnectionFactory;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsManagedConnectionFactoryImpl");
        }
    }

    public Connection createConnection() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnection");
        }
        Connection connection = this.createConnection(null, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)new Object[]{userName, password == null ? "<null>" : "<non-null>"});
        }
        JmsConnectionImpl connection = null;
        JmsJcaConnection jcaConnection = null;
        try {
            jcaConnection = userName == null && password == null ? this.jcaConnectionFactory.createConnection() : this.jcaConnectionFactory.createConnection(userName, password);
        }
        catch (SIAuthenticationException siae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHENTICATION_FAILED_CWSIA0009", null, siae, null, this, tc);
        }
        catch (SINotAuthorizedException sinae) {
            throw (JMSSecurityException)JmsErrorUtils.newThrowable(JMSSecurityException.class, "AUTHORIZATION_FAILED_CWSIA0006", null, sinae, null, this, tc);
        }
        catch (SIException sice) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0241", new Object[]{sice, "JmsManagedConnectionFactoryImpl.createConnection"}, sice, "JmsManagedConnectionFactoryImpl.createConnection#3", this, tc);
        }
        catch (ResourceException re) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, re, null, this, tc);
        }
        HashMap<String, String> passThruProps = new HashMap<String, String>();
        passThruProps.put("clientID", this.getClientID());
        passThruProps.put("nonPersistentMapping", this.getNonPersistentMapping());
        passThruProps.put("persistentMapping", this.getPersistentMapping());
        passThruProps.put("readAhead", this.getReadAhead());
        passThruProps.put("durableSubscriptionHome", this.getDurableSubscriptionHome());
        passThruProps.put("tempQueueNamePrefix", this.getTemporaryQueueNamePrefix());
        passThruProps.put("tempTopicNamePrefix", this.getTemporaryTopicNamePrefix());
        passThruProps.put("producerDoesNotModifyPayloadAfterSet", this.getProducerDoesNotModifyPayloadAfterSet());
        passThruProps.put("consumerDoesNotModifyPayloadAfterGet", this.getConsumerDoesNotModifyPayloadAfterGet());
        passThruProps.put("shareDurableSubscriptions", this.getShareDurableSubscriptions());
        passThruProps.put("busName", this.getBusName());
        connection = this.instantiateConnection(jcaConnection, passThruProps);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createConnection", (Object)connection);
        }
        return connection;
    }

    @Override
    public String getClientID() {
        String clientID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getClientID");
        }
        if ((clientID = this.jcaConnectionFactory.getClientID()) != null && "".equals(clientID)) {
            clientID = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getClientID", (Object)clientID);
        }
        return clientID;
    }

    @Override
    public String getNonPersistentMapping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNonPersistentMapping");
        }
        String nonPersistentMapping = this.jcaConnectionFactory.getNonPersistentMapping();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNonPersistentMapping", (Object)nonPersistentMapping);
        }
        return nonPersistentMapping;
    }

    @Override
    public boolean isManaged() {
        boolean isManaged;
        String imP;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isManaged");
        }
        if ((imP = PrivHelper.getProperty((String)"com.ibm.ws.sib.api.isManaged")) == null) {
            isManaged = this.jcaConnectionFactory.isManaged();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("isManaged being overridden by system property: " + imP));
            }
            isManaged = (imP = imP.toUpperCase()).equals("TRUE") || imP.equals("YES");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isManaged", (Object)isManaged);
        }
        return isManaged;
    }

    @Override
    public String getReadAhead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReadAhead");
        }
        String ra = this.jcaConnectionFactory.getReadAhead();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReadAhead", (Object)ra);
        }
        return ra;
    }

    @Override
    public String getDurableSubscriptionHome() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDurableSubscriptionHome");
        }
        String dsh = this.jcaConnectionFactory.getDurableSubscriptionHome();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDurableSubscriptionHome", (Object)dsh);
        }
        return dsh;
    }

    @Override
    public String getTemporaryQueueNamePrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTemporaryQueueNamePrefix");
        }
        String prefix = this.jcaConnectionFactory.getTemporaryQueueNamePrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTemporaryQueueNamePrefix", (Object)prefix);
        }
        return prefix;
    }

    @Override
    public String getTemporaryTopicNamePrefix() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTemporaryTopicNamePrefix");
        }
        String prefix = this.jcaConnectionFactory.getTemporaryTopicNamePrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTemporaryTopicNamePrefix", (Object)prefix);
        }
        return prefix;
    }

    JmsConnectionImpl instantiateConnection(JmsJcaConnection jcaConnection, Map<String, String> _passThruProps) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateConnection", (Object)jcaConnection);
        }
        JmsConnectionImpl jmsConnection = new JmsConnectionImpl(jcaConnection, this.isManaged(), _passThruProps);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateConnection", (Object)jmsConnection);
        }
        return jmsConnection;
    }

    @Override
    public String getPersistentMapping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentMapping");
        }
        String persistentMapping = this.jcaConnectionFactory.getPersistentMapping();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentMapping", (Object)persistentMapping);
        }
        return persistentMapping;
    }

    @Override
    public String getBusName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBusName");
        }
        String busName = this.jcaConnectionFactory.getBusName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBusName", (Object)busName);
        }
        return busName;
    }

    @Override
    public String getUserName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getUserName");
        }
        String userName = this.jcaConnectionFactory.getUserName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getUserName", (Object)userName);
        }
        return userName;
    }

    public String getPassword() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPassword");
        }
        String password = this.jcaConnectionFactory.getPassword();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPassword");
        }
        return password;
    }

    @Override
    public String getConnectionProximity() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionProximity");
        }
        String connectionProximity = this.jcaConnectionFactory.getConnectionProximity();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionProximity", (Object)connectionProximity);
        }
        return connectionProximity;
    }

    @Override
    public String getProviderEndpoints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderEndpoints");
        }
        String providerEndpoints = this.jcaConnectionFactory.getProviderEndpoints();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderEndpoints", (Object)providerEndpoints);
        }
        return providerEndpoints;
    }

    @Override
    public String getTargetTransportChain() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTargetTransportChain");
        }
        String targetTransportChain = this.jcaConnectionFactory.getTargetTransportChain();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTargetTransportChain", (Object)targetTransportChain);
        }
        return targetTransportChain;
    }

    @Override
    public String getTarget() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTarget");
        }
        String remoteTargetGroup = this.jcaConnectionFactory.getTarget();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTarget", (Object)remoteTargetGroup);
        }
        return remoteTargetGroup;
    }

    @Override
    public String getTargetType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTargetType");
        }
        String remoteTargetType = this.jcaConnectionFactory.getTargetType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTargetType", (Object)remoteTargetType);
        }
        return remoteTargetType;
    }

    @Override
    public String getShareDurableSubscriptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getShareDurableSubscriptions");
        }
        String val = this.jcaConnectionFactory.getShareDurableSubscriptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getShareDurableSubscriptions", (Object)val);
        }
        return val;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        JmsJcaConnectionFactory thatJcaConnectionFactory = ((JmsManagedConnectionFactoryImpl)that).jcaConnectionFactory;
        if (this.jcaConnectionFactory == thatJcaConnectionFactory) {
            return true;
        }
        if (this.jcaConnectionFactory != null) {
            return this.jcaConnectionFactory.equals(thatJcaConnectionFactory);
        }
        return false;
    }

    public int hashCode() {
        return this.jcaConnectionFactory.hashCode();
    }

    @Override
    public String getTargetSignificance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTargetSignificance");
        }
        String result = this.jcaConnectionFactory.getTargetSignificance();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTargetSignificance", (Object)result);
        }
        return result;
    }

    @Override
    public String getMulticastInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMulticastInterface");
        }
        String result = this.jcaConnectionFactory.getMulticastInterface();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMulticastInterface", (Object)result);
        }
        return result;
    }

    @Override
    public String getSubscriptionProtocol() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSubscriptionProtocol");
        }
        String result = this.jcaConnectionFactory.getSubscriptionProtocol();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSubscriptionProtocol", (Object)result);
        }
        return result;
    }

    @Override
    public String getProducerDoesNotModifyPayloadAfterSet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProducerDoesNotModifyPayloadAfterSet");
        }
        String result = this.jcaConnectionFactory.getProducerDoesNotModifyPayloadAfterSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProducerDoesNotModifyPayloadAfterSet", (Object)result);
        }
        return result;
    }

    @Override
    public String getConsumerDoesNotModifyPayloadAfterGet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerDoesNotModifyPayloadAfterGet");
        }
        String result = this.jcaConnectionFactory.getConsumerDoesNotModifyPayloadAfterGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerDoesNotModifyPayloadAfterGet", (Object)result);
        }
        return result;
    }

    public JMSContext createContext() throws JMSRuntimeException, JMSSecurityRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createContext");
        }
        JMSContext jmsContext = null;
        try {
            jmsContext = this.createContext(null, null, 1);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext");
            }
        }
        return jmsContext;
    }

    public JMSContext createContext(int sessionMode) throws JMSRuntimeException, JMSSecurityRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{sessionMode});
        }
        JMSContext jmsContext = null;
        try {
            jmsContext = this.createContext(null, null, sessionMode);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext");
            }
        }
        return jmsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSContext createContext(String userName, String password) throws JMSRuntimeException, JMSSecurityRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{userName, password});
        }
        JMSContext jmsContext = null;
        try {
            jmsContext = this.createContext(userName, password, 1);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext");
            }
        }
        return jmsContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSContext createContext(String userName, String password, int sessionMode) throws JMSRuntimeException, JMSSecurityRuntimeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createContext", (Object)new Object[]{userName, password, sessionMode});
        }
        JmsConnectionImpl jmsConnection = null;
        JmsJMSContextImpl jmsContext = null;
        try {
            switch (sessionMode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw (JMSRuntimeException)JmsErrorUtils.newThrowable(JMSRuntimeException.class, "INVALID_ACKNOWLEDGE_MODE_CWSIA0514", new Object[]{sessionMode}, tc);
                }
            }
            jmsConnection = (JmsConnectionImpl)this.createConnection(userName, password);
            jmsContext = new JmsJMSContextImpl(jmsConnection, sessionMode, true);
        }
        catch (JMSSecurityException jmsse) {
            try {
                throw (JMSSecurityRuntimeException)JmsErrorUtils.getJMS2Exception((JMSException)((Object)jmsse), JMSSecurityRuntimeException.class);
                catch (JMSException jmse) {
                    throw (JMSRuntimeException)JmsErrorUtils.getJMS2Exception(jmse, JMSRuntimeException.class);
                }
            }
            catch (Throwable throwable) {
                if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
                if (!tc.isEntryEnabled()) throw throwable;
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext", jmsContext);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return jmsContext;
        if (!tc.isEntryEnabled()) return jmsContext;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"createContext", (Object)jmsContext);
        return jmsContext;
    }
}

