/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.internal.GatewayClassLoader;
import com.ibm.ws.classloading.internal.ParentLastClassLoader;
import com.ibm.ws.classloading.internal.UnifiedClassLoader;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ThreadContextClassLoader
extends UnifiedClassLoader
implements Keyed<String> {
    static final TraceComponent tc = Tr.register(ThreadContextClassLoader.class);
    private final AtomicReference<Bundle> bundle = new AtomicReference();
    protected final String key;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final ClassLoader appLoader;
    static final long serialVersionUID = 7093379526360135425L;

    public ThreadContextClassLoader(GatewayClassLoader augLoader, ClassLoader appLoader, String key) {
        super(appLoader instanceof ParentLastClassLoader ? appLoader : augLoader, appLoader instanceof ParentLastClassLoader ? augLoader : appLoader);
        this.bundle.set(augLoader.getBundle());
        this.key = key;
        this.appLoader = appLoader;
    }

    private void cleanup() {
        String methodName = "cleanup(): ";
        try {
            Bundle b = this.bundle.getAndSet(null);
            if (b != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cleanup(): Uninstalling bundle location: " + b.getLocation() + ", bundle id: " + b.getBundleId()), (Object[])new Object[0]);
                }
                b.uninstall();
            }
        }
        catch (BundleException bundleException) {
            FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader", (String)"58", (Object)this, (Object[])new Object[0]);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.classloading.internal.ThreadContextClassLoader", (String)"59", (Object)this, (Object[])new Object[0]);
        }
    }

    int decrementRefCount() {
        String methodName = "decrementRefCount(): ";
        int count = this.refCount.decrementAndGet();
        if (count < 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"decrementRefCount():  refCount < 0 - too many calls to destroy/cleaup", (Object[])new Object[]{new Throwable("stack trace")});
        }
        if (count == 0) {
            this.cleanup();
        }
        return count;
    }

    int incrementRefCount() {
        return this.refCount.incrementAndGet();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    protected URL findResource(String arg0) {
        return super.findResource(arg0);
    }

    @Override
    protected Enumeration<URL> findResources(String arg0) throws IOException {
        return super.findResources(arg0);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    final boolean isFor(ClassLoader classLoader) {
        return classLoader == this.appLoader;
    }
}

