/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.internal.CompositeResourceProvider;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoadingConfigurationException;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class GatewayClassLoader
extends ClassLoader
implements DeclaredApiAccess,
BundleReference {
    private final GatewayConfiguration config;
    private final Object wiringMonitor = new Object(){
        static final long serialVersionUID = -6591900154872362572L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private final Bundle bundle;
    private BundleWiring wiring = null;
    private ClassLoader bundleLoader;
    private final CompositeResourceProvider resourceProviders;
    static final long serialVersionUID = -4256474098847905153L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GatewayClassLoader createGatewayClassLoader(Map<Bundle, Set<GatewayClassLoader>> classloaders, GatewayConfiguration config, ClassLoader bundleLoader, CompositeResourceProvider resourceProviders) {
        Bundle b;
        GatewayClassLoader result = new GatewayClassLoader(config, bundleLoader, resourceProviders);
        if (classloaders != null && (b = result.getBundle()) != null) {
            Map<Bundle, Set<GatewayClassLoader>> map = classloaders;
            synchronized (map) {
                Set<GatewayClassLoader> loaders = classloaders.get(b);
                if (loaders == null) {
                    loaders = Collections.newSetFromMap(new WeakHashMap());
                    classloaders.put(b, loaders);
                }
                loaders.add(result);
            }
        }
        return result;
    }

    private GatewayClassLoader(GatewayConfiguration config, ClassLoader bundleLoader, CompositeResourceProvider resourceProviders) {
        this.config = config;
        if (bundleLoader instanceof BundleReference) {
            this.bundle = ((BundleReference)bundleLoader).getBundle();
            this.wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
            if (this.wiring == null) {
                throw new IllegalStateException("Gateway bundle is not resolved.");
            }
            this.bundleLoader = this.wiring.getClassLoader();
            if (this.bundleLoader == null) {
                throw new IllegalStateException("Gateway bundle does not have a class loader.");
            }
        } else {
            this.bundle = null;
            this.bundleLoader = bundleLoader;
        }
        this.resourceProviders = resourceProviders;
    }

    @Override
    @Trivial
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.config.getApiTypeVisibility();
    }

    @Override
    @Trivial
    public URL getResource(String resName) {
        URL result = this.findResource(resName);
        return result == null ? GatewayClassLoader.getSystemResource(resName) : result;
    }

    @Override
    protected URL findResource(String name) {
        URL result = null;
        if (!"".equals(name) && !"/".equals(name)) {
            result = this.bundleLoader.getResource(name);
        }
        return result == null ? this.resourceProviders.findResource(name) : result;
    }

    @Override
    @Trivial
    public Enumeration<URL> getResources(String resName) throws IOException {
        return this.findResources(resName).add(GatewayClassLoader.getSystemResources(resName));
    }

    protected CompositeEnumeration<URL> findResources(String name) throws IOException {
        CompositeEnumeration result = new CompositeEnumeration();
        if (!"".equals(name) && !"/".equals(name)) {
            Enumeration<URL> urls = this.bundleLoader.getResources(name);
            result.add(urls);
        }
        this.resourceProviders.findResources(name, (CompositeEnumeration<URL>)result);
        return result;
    }

    @Override
    @Trivial
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.config.getDelegateToSystem()) {
            try {
                return Delegation.loadClass(className, this.bundleLoader);
            }
            catch (ClassNotFoundException perfectlyNormal) {
                return this.findSystemClass(className);
            }
        }
        return Delegation.loadClass(className, this.bundleLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateNewLoader() throws ClassLoadingConfigurationException {
        if (this.bundle != null) {
            Object object = this.wiringMonitor;
            synchronized (object) {
                if (this.wiring == null || !this.wiring.isCurrent()) {
                    this.wiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
                    if (this.wiring != null) {
                        ClassLoader newLoader = this.wiring.getClassLoader();
                        if (newLoader == null) {
                            throw new ClassLoadingConfigurationException("No class loader available for the gateway bundle.");
                        }
                        this.bundleLoader = newLoader;
                    }
                }
            }
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(GatewayClassLoader.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class Delegation {
        static final long serialVersionUID = -6904704400381012569L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Delegation() {
        }

        @Trivial
        static Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
            return loader.loadClass(className);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Delegation.class);
        }
    }
}

