/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.ClassGenerator;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassGeneratorManager
implements ClassGenerator {
    private static final TraceComponent tc = Tr.register(ClassGeneratorManager.class);
    private final ConcurrentServiceReferenceSet<ClassGenerator> generatorRefs;
    static final long serialVersionUID = 4152663586056483310L;

    public ClassGeneratorManager(ConcurrentServiceReferenceSet<ClassGenerator> generatorRefs) {
        this.generatorRefs = generatorRefs;
    }

    @Override
    public byte[] generateClass(String name, ClassLoader loader) throws ClassNotFoundException {
        for (ClassGenerator generator : this.generatorRefs.services()) {
            byte[] bytes = generator.generateClass(name, loader);
            if (bytes == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("class " + name + " generated by " + generator), (Object[])new Object[0]);
            }
            return bytes;
        }
        return null;
    }
}

