/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.routing.member.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.routing.member.internal.WebModuleRoutingInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ApplicationRoutingInfo {
    private static final TraceComponent tc = Tr.register(ApplicationRoutingInfo.class, (String)"Collective", (String)"com.ibm.ws.collective.routing.member.internal.resources.RoutingMemberMessages");
    private String digest;
    private String prevDigest;
    private final String applicationName;
    private final J2EEName j2EEName;
    private List<WebModuleRoutingInfo> wmris;
    static final long serialVersionUID = 6488759714361314334L;

    @Trivial
    public J2EEName getJ2EEName() {
        return this.j2EEName;
    }

    @Trivial
    public String getApplicationName() {
        return this.applicationName;
    }

    @Trivial
    public String getDigest() {
        return this.digest;
    }

    @Trivial
    public String getPrevDigest() {
        return this.prevDigest;
    }

    @Trivial
    public List<WebModuleRoutingInfo> getWMRIs() {
        return this.wmris;
    }

    ApplicationRoutingInfo(J2EEName j2EEName, List<WebModuleRoutingInfo> wmris) {
        this.applicationName = j2EEName.getApplication();
        this.j2EEName = j2EEName;
        this.digest = null;
        this.update(wmris);
    }

    public void update() {
        this.update(this.wmris);
    }

    public synchronized void update(List<WebModuleRoutingInfo> wmris) {
        this.wmris = wmris;
        ArrayList<String> webModuleInfos = new ArrayList<String>();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Updating WebModuleRoutingInfos for " + this.j2EEName.toString()), (Object[])new Object[0]);
        }
        for (WebModuleRoutingInfo wmri : wmris) {
            for (int j = 0; j < wmri.getJsonRepresentation().size(); ++j) {
                JSONObject webModule = (JSONObject)wmri.getJsonRepresentation().get(j);
                JSONObject webModuleAttributes = (JSONObject)webModule.get((Object)"attributes");
                String webModuleSessionAffinityCookie = (String)webModuleAttributes.get((Object)"SessionAffinityCookie");
                Boolean webModuleFileServingEnabled = (Boolean)webModuleAttributes.get((Object)"FileServingEnabled");
                String webModuleDigest = (String)webModule.get((Object)"digest");
                webModuleInfos.add(webModuleDigest + webModuleFileServingEnabled + webModuleSessionAffinityCookie);
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("  Updated WebModuleRoutingInfo = " + wmri.toString()), (Object[])new Object[0]);
        }
        Collections.sort(webModuleInfos);
        this.prevDigest = this.digest;
        this.digest = DigestUtils.md5Hex((String)((Object)webModuleInfos).toString());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Digests for WebModuleRoutingInfos: prevDigest = " + this.prevDigest + ", digest = " + this.digest), (Object[])new Object[0]);
        }
    }
}

