/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.ee7;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.internal.outbound.HttpOutputStreamImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.exception.WriteBeyondContentLengthException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpOutputStreamEE7
extends HttpOutputStreamImpl {
    private static final TraceComponent tc = Tr.register(HttpOutputStreamEE7.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private InterChannelCallback _callback;
    private boolean _isReady = true;
    private boolean _internalReady = true;
    private int _bytesRemainingWhenAsync = 0;
    private byte[] _remValue = null;
    private boolean _dataSaved = false;
    private final Object _lockObj = new Object(){
        static final long serialVersionUID = 1818073030646734277L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    public Object _writeReadyLockObj = new Object(){
        static final long serialVersionUID = 673193084762718029L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class);
        }
    };
    public boolean status_not_ready_checked = false;
    public boolean write_crlf_pending = false;
    private boolean exceptionDuringOnWP = false;
    static final long serialVersionUID = 2421318657626897978L;

    public HttpOutputStreamEE7(HttpInboundServiceContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRemainingToBuffers() throws Exception {
        this.clearBuffersAfterWrite();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Write out remainig bytes if any --> " + this._bytesRemainingWhenAsync), (Object[])new Object[0]);
        }
        if (this._bytesRemainingWhenAsync > 0) {
            Object object = this._lockObj;
            synchronized (object) {
                if (!this.isDataSaved()) {
                    this._lockObj.wait();
                }
                this.setDataSaved(false);
            }
            this.set_internalReady(true);
            this.writeToBuffers(this._remValue, 0, this._bytesRemainingWhenAsync);
        } else {
            this.set_internalReady(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToBuffers(byte[] value, int start, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing " + len + ", buffered=" + this.bufferedCount), (Object[])new Object[0]);
        }
        if (value.length < start + len) {
            throw new IllegalArgumentException("Length outside value range");
        }
        this.writing = true;
        int remaining = len;
        int offset = start;
        while (0 < remaining) {
            if (this._callback != null && !this.get_internalReady()) {
                this._remValue = new byte[remaining];
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Save of bytesRemainingWhenAsync -->" + this._bytesRemainingWhenAsync + ", value size -->" + value.length + ", remValue size -->" + this._remValue.length), (Object[])new Object[0]);
                }
                Object object = this._lockObj;
                synchronized (object) {
                    System.arraycopy(value, offset, this._remValue, 0, remaining);
                    this.setDataSaved(true);
                    this._lockObj.notifyAll();
                    break;
                }
            }
            WsByteBuffer buffer = this.getBuffer();
            int avail = buffer.remaining();
            if (this.contentLengthSet && this.bytesRemaining < (long)(this.bufferedCount + remaining)) {
                int numberToWrite = (int)this.bytesRemaining - this.bufferedCount;
                boolean throwExceptionThisTime = true;
                if (numberToWrite > avail) {
                    numberToWrite = avail;
                    throwExceptionThisTime = false;
                }
                this.bufferedCount += numberToWrite;
                buffer.put(value, offset, numberToWrite);
                remaining -= numberToWrite;
                if (throwExceptionThisTime) {
                    throw new WriteBeyondContentLengthException();
                }
            }
            if (avail >= remaining) {
                this.bufferedCount += remaining;
                buffer.put(value, offset, remaining);
                remaining = 0;
            } else {
                this.bufferedCount += avail;
                buffer.put(value, offset, avail);
                offset += avail;
                remaining -= avail;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing " + len + ", buffered=" + this.bufferedCount + ", this.amountToBuffer=" + this.amountToBuffer), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("buffer now -->" + buffer), (Object[])new Object[0]);
            }
            if (this.bufferedCount < this.amountToBuffer) continue;
            this.ignoreFlush = false;
            if (this._callback == null) {
                this.flushBuffers();
                continue;
            }
            this._bytesRemainingWhenAsync = remaining;
            this.flushAsyncBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IOException.class})
    private void flushAsyncBuffers() throws IOException {
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Flushing Async buffers: " + this), (Object[])new Object[0]);
            }
            if (!this.isc.getResponse().isCommitted()) {
                if (this.obs != null && !this.WCheadersWritten) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("obs  ->" + this.obs), (Object[])new Object[0]);
                    }
                    this.obs.alertOSFirstFlush();
                }
                this.isc.getResponse().setCommitted();
            }
            if (this.ignoreFlush) {
                this.ignoreFlush = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignoring first flush attempt", (Object[])new Object[0]);
                }
                return;
            }
            boolean writingBody = this.hasBufferedContent();
            if (writingBody && null != this.output[this.outputIndex]) {
                this.output[this.outputIndex].flip();
            }
            try {
                WsByteBuffer[] content;
                WsByteBuffer[] wsByteBufferArray = content = writingBody ? this.output : null;
                if (this.isClosed() || this.isClosing) {
                    if (!this.hasFinished) {
                        this.isc.finishResponseMessage(content);
                        this.isClosing = false;
                        this.hasFinished = true;
                    }
                    break block26;
                }
                this.vc = this.isc.sendResponseBody(content, this._callback, false);
                if (this.vc == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"wait for data to be written, async write in progress, set ready to false", (Object[])new Object[0]);
                    }
                    Object object = this._writeReadyLockObj;
                    synchronized (object) {
                        this.setWriteReady(false);
                        this.set_internalReady(false);
                        break block26;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("able to write out, no callback required, vc -->" + this.vc), (Object[])new Object[0]);
                }
            }
            catch (MessageSentException content) {
                void mse;
                FFDCFilter.processException((Throwable)content, (String)"com.ibm.wsspi.http.ee7.HttpOutputStreamEE7", (String)"236", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)mse, (String)this.getClass().getName(), (String)"flushAsyncBuffers", (Object[])new Object[]{this, this.isc});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Invalid state, message-sent-exception received; " + this.isc), (Object[])new Object[0]);
                }
                this.error = new IOException("Invalid state");
                throw this.error;
            }
            catch (IOException ioe) {
                this.error = ioe;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received exception during write: " + ioe), (Object[])new Object[0]);
                }
                throw ioe;
            }
            finally {
                this.bytesWritten += (long)this.bufferedCount;
                if (this.contentLengthSet) {
                    this.bytesRemaining -= (long)this.bufferedCount;
                }
                this.bufferedCount = 0;
                this.outputIndex = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("finally, this " + this + " ,bytesRemaining -->" + this.bytesRemaining + ", bytesWritten -->" + this.bytesWritten), (Object[])new Object[0]);
                }
                if (writingBody && this.vc != null) {
                    this.clearBuffersAfterWrite();
                }
            }
        }
    }

    private void clearBuffersAfterWrite() {
        if (this.output != null) {
            if (null != this.output[0]) {
                this.output[0].clear();
            }
            for (int i = 1; i < this.output.length; ++i) {
                if (null == this.output[i]) continue;
                this.output[i].position(0);
                this.output[i].limit(0);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._callback != null) {
            if (!this._isReady) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cannot flush stream , output not ready: " + this), (Object[])new Object[0]);
                }
                return;
            }
            this.validate();
            this.flushBuffers();
        } else {
            super.flush();
        }
    }

    public void setAsyncServletWriteListenerCallBack(InterChannelCallback callback) {
        this._callback = callback;
    }

    public InterChannelCallback getAsyncServletWriteListenerCallBack() {
        return this._callback;
    }

    public boolean isWriteReady() {
        return this._isReady;
    }

    public void setWriteReady(boolean ready) {
        this._isReady = ready;
    }

    private boolean isDataSaved() {
        return this._dataSaved;
    }

    private void setDataSaved(boolean dataSaved) {
        this._dataSaved = dataSaved;
    }

    public boolean get_internalReady() {
        return this._internalReady;
    }

    public void set_internalReady(boolean _internalReady) {
        this._internalReady = _internalReady;
    }

    public boolean getExceptionDuringOnWP() {
        return this.exceptionDuringOnWP;
    }

    public void setExceptionDuringOnWP(boolean exceptionDuringOnWP) {
        this.exceptionDuringOnWP = exceptionDuringOnWP;
    }

    @Override
    public VirtualConnection getVc() {
        return super.getVc();
    }
}

