/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class AccessLogStartTime
extends AccessLogData {
    public AccessLogStartTime() {
        super("%t");
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long startTime = AccessLogStartTime.getStartTime(response, request, data);
        if (startTime != 0L) {
            Date startDate = new Date(startTime);
            accessLogEntry.append("[");
            accessLogEntry.append(HttpDispatcher.getDateFormatter().getNCSATime(startDate));
            accessLogEntry.append("]");
        } else {
            accessLogEntry.append("-");
        }
        return true;
    }

    public static long getStartTime(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        HttpRequestMessageImpl requestMessageImpl = null;
        long startTime = 0L;
        if (request != null) {
            requestMessageImpl = (HttpRequestMessageImpl)request;
        }
        if (requestMessageImpl != null) {
            long elapsedTime = System.nanoTime() - requestMessageImpl.getStartNanoTime();
            startTime = System.currentTimeMillis() - TimeUnit.NANOSECONDS.toMillis(elapsedTime);
        }
        return startTime;
    }
}

