/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.RasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.introspect.InjectedTraceAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.main.AlpineTracePreprocessInstrumentation;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.MethodInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public abstract class AbstractRasMethodAdapter<C extends AbstractRasClassAdapter>
extends RasMethodAdapter
implements Opcodes {
    private static final Object THIS = new Object(){

        public String toString() {
            return "this";
        }
    };
    private static final Object OTHER = new Object(){

        public String toString() {
            return "other";
        }
    };
    private final C classAdapter;
    private final MethodInfo methodInfo;
    private final String methodName;
    private boolean isStatic = false;
    private Type[] argTypes = null;
    private Type returnType = null;
    private final Set<Type> observedAnnotations = new HashSet<Type>();
    private final Map<Integer, Set<Type>> observedParameterAnnotations = new HashMap<Integer, Set<Type>>();
    private InjectedTraceAnnotationVisitor injectedTraceAnnotationVisitor;
    private final Map<Label, String> handlers = new HashMap<Label, String>();
    private int lineNumber;
    private Label methodEntryLabel;
    private boolean methodEntryHasLineNumber;
    private boolean processedMethodEntry;
    private int firstNonParameterSlot;
    private boolean waitingForSuper = false;
    private List<Object> currentStack = null;
    private Map<Label, List<Object>> branchTargets = null;
    private String pendingExceptionHandlerTypeName;
    private final boolean visitFramesAfterCallbacks;

    public AbstractRasMethodAdapter(C classAdapter, boolean visitFrames, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(visitor);
        ClassInfo classInfo;
        this.classAdapter = classAdapter;
        this.visitFramesAfterCallbacks = visitFrames;
        this.methodName = methodName;
        this.isStatic = (access & 8) != 0;
        this.argTypes = Type.getArgumentTypes((String)descriptor);
        this.returnType = Type.getReturnType((String)descriptor);
        this.firstNonParameterSlot = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.argTypes.length; ++i) {
            this.firstNonParameterSlot += this.argTypes[i].getSize();
        }
        if (this.isConstructor()) {
            this.currentStack = new ArrayList<Object>();
            this.branchTargets = new HashMap<Label, List<Object>>();
            this.waitingForSuper = true;
        }
        if ((classInfo = ((AbstractRasClassAdapter)classAdapter).getClassInfo()) != null) {
            MethodInfo methodInfo = classInfo.getDeclaredMethod(methodName, descriptor);
            if (methodInfo == null) {
                methodInfo = new MethodInfo(methodName, descriptor);
                methodInfo.updateDefaultValuesFromClassInfo(classInfo);
            }
            this.methodInfo = methodInfo;
        } else {
            this.methodInfo = null;
        }
    }

    private void push(Object stackElement, int count) {
        for (int i = 0; i < count; ++i) {
            this.currentStack.add(stackElement);
        }
    }

    private Object pop(int count) {
        Object popped = null;
        for (int i = count; i > 0; --i) {
            popped = this.currentStack.remove(this.currentStack.size() - 1);
        }
        return popped;
    }

    private void addBranchTarget(Label target) {
        if (!this.branchTargets.containsKey(target)) {
            this.branchTargets.put(target, new ArrayList<Object>(this.currentStack));
        }
    }

    private void processPendingExceptionHandlerEntry(int astoreVar) {
        if (this.pendingExceptionHandlerTypeName != null) {
            Type exceptionType = Type.getObjectType((String)this.pendingExceptionHandlerTypeName);
            this.pendingExceptionHandlerTypeName = null;
            if (this.onExceptionHandlerEntry(exceptionType, astoreVar)) {
                this.visitFrameAfterOnExceptionHandlerEntry();
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        this.observedAnnotations.add(Type.getType((String)desc));
        if (desc.equals(AlpineTracePreprocessInstrumentation.INJECTED_TRACE_TYPE.getDescriptor())) {
            this.injectedTraceAnnotationVisitor = new InjectedTraceAnnotationVisitor(av, ((Object)((Object)this)).getClass());
            av = this.injectedTraceAnnotationVisitor;
        }
        return av;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor av = super.visitParameterAnnotation(parameter, desc, visible);
        Set<Type> parameterAnnotations = this.observedParameterAnnotations.get(parameter);
        if (parameterAnnotations == null) {
            parameterAnnotations = new HashSet<Type>();
            this.observedParameterAnnotations.put(parameter, parameterAnnotations);
        }
        parameterAnnotations.add(Type.getType((String)desc));
        return av;
    }

    public void visitCode() {
        if (this.injectedTraceAnnotationVisitor == null && ((AbstractRasClassAdapter)this.classAdapter).isInjectedTraceAnnotationRequired()) {
            AnnotationVisitor av = this.visitAnnotation(AlpineTracePreprocessInstrumentation.INJECTED_TRACE_TYPE.getDescriptor(), true);
            av.visitEnd();
        }
        super.visitCode();
        this.methodEntryLabel = new Label();
        this.visitLabel(this.methodEntryLabel);
        if (!this.waitingForSuper) {
            this.processMethodEntry();
        }
    }

    private void visitFrameAfterOnMethodEntry() {
        if (!this.visitFramesAfterCallbacks) {
            return;
        }
        if (this.isConstructor()) {
            ArrayList<Object> stackLocals = new ArrayList<Object>(this.argTypes.length + 1);
            stackLocals.add(((AbstractRasClassAdapter)this.classAdapter).getClassType().getInternalName());
            block7: for (Type type : this.argTypes) {
                switch (type.getSort()) {
                    case 9: 
                    case 10: {
                        stackLocals.add(type.getInternalName());
                        continue block7;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        stackLocals.add(INTEGER);
                        continue block7;
                    }
                    case 7: {
                        stackLocals.add(LONG);
                        continue block7;
                    }
                    case 6: {
                        stackLocals.add(FLOAT);
                        continue block7;
                    }
                    case 8: {
                        stackLocals.add(DOUBLE);
                    }
                }
            }
            this.visitFrame(0, stackLocals.size(), stackLocals.toArray(), 0, new Object[0]);
            this.visitInsn(0);
        } else {
            this.visitFrame(3, 0, null, 0, null);
            this.visitInsn(0);
        }
    }

    private void processMethodEntry() {
        if (this.processedMethodEntry) {
            return;
        }
        this.processedMethodEntry = true;
        if (this.isStaticInitializer()) {
            this.initializeTraceObjectField();
        }
        if (this.onMethodEntry()) {
            this.visitFrameAfterOnMethodEntry();
        }
    }

    public void visitInsn(int inst) {
        this.processPendingExceptionHandlerEntry(-1);
        if (this.waitingForSuper) {
            super.visitInsn(inst);
            switch (inst) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: {
                    this.push(OTHER, 1);
                    break;
                }
                case 9: 
                case 10: 
                case 14: 
                case 15: {
                    this.push(OTHER, 2);
                    break;
                }
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.pop(1);
                    break;
                }
                case 47: 
                case 49: {
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.pop(3);
                    break;
                }
                case 80: 
                case 82: {
                    this.pop(4);
                    break;
                }
                case 87: {
                    this.pop(1);
                    break;
                }
                case 88: {
                    this.pop(2);
                    break;
                }
                case 89: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    this.push(top, 1);
                    break;
                }
                case 90: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    int addPosition = this.currentStack.size() - 2;
                    this.currentStack.add(addPosition, top);
                    break;
                }
                case 91: {
                    Object top = this.currentStack.get(this.currentStack.size() - 1);
                    int addPosition = this.currentStack.size() - 3;
                    this.currentStack.add(addPosition, top);
                    break;
                }
                case 92: {
                    int position = this.currentStack.size() - 2;
                    this.currentStack.add(this.currentStack.get(position));
                    this.currentStack.add(this.currentStack.get(position + 1));
                    break;
                }
                case 93: {
                    int addPosition = this.currentStack.size() - 3;
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                    break;
                }
                case 94: {
                    int addPosition = this.currentStack.size() - 4;
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 1));
                    this.currentStack.add(addPosition, this.currentStack.get(this.currentStack.size() - 2));
                    break;
                }
                case 95: {
                    Object o = this.currentStack.remove(this.currentStack.size() - 2);
                    this.currentStack.add(o);
                    break;
                }
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    this.pop(1);
                    break;
                }
                case 97: 
                case 99: 
                case 101: 
                case 103: 
                case 105: 
                case 107: 
                case 109: 
                case 111: 
                case 113: 
                case 115: 
                case 117: 
                case 119: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    this.pop(2);
                    break;
                }
                case 133: 
                case 135: 
                case 140: 
                case 141: {
                    this.push(OTHER, 1);
                    break;
                }
                case 134: 
                case 139: 
                case 145: 
                case 146: 
                case 147: {
                    break;
                }
                case 136: 
                case 137: 
                case 142: 
                case 144: {
                    this.pop(1);
                    break;
                }
                case 138: 
                case 143: {
                    break;
                }
                case 148: 
                case 151: 
                case 152: {
                    this.pop(3);
                    break;
                }
                case 149: 
                case 150: {
                    this.pop(1);
                    break;
                }
                case 172: 
                case 174: 
                case 176: {
                    this.pop(1);
                    break;
                }
                case 173: 
                case 175: {
                    this.pop(2);
                    break;
                }
                case 177: {
                    break;
                }
                case 190: {
                    break;
                }
                case 191: {
                    this.pop(1);
                    break;
                }
                case 194: 
                case 195: {
                    this.pop(1);
                    break;
                }
            }
        } else {
            switch (inst) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    if (!this.onMethodReturn()) break;
                    this.visitFrameAfterMethodReturnCallback();
                    break;
                }
                case 191: {
                    if (!this.onThrowInstruction()) break;
                    this.visitFrameAfterOnThrowCallback();
                }
            }
            super.visitInsn(inst);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitFieldInsn(opcode, owner, name, desc);
        if (this.waitingForSuper) {
            Type type = Type.getType((String)desc);
            switch (opcode) {
                case 178: {
                    this.push(OTHER, type.getSize());
                    break;
                }
                case 180: {
                    this.push(OTHER, type.getSize() - 1);
                    break;
                }
                case 179: {
                    this.pop(type.getSize());
                    break;
                }
                case 181: {
                    this.pop(type.getSize() + 1);
                }
            }
        }
    }

    public void visitIincInsn(int var, int increment) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitIincInsn(var, increment);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitIntInsn(opcode, operand);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 16: 
                case 17: {
                    this.push(OTHER, 1);
                }
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitJumpInsn(opcode, label);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.pop(1);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.pop(2);
                    break;
                }
                case 167: {
                    break;
                }
                case 168: {
                    this.push(OTHER, 1);
                    break;
                }
                case 198: 
                case 199: {
                    this.pop(1);
                }
            }
            this.addBranchTarget(label);
        }
    }

    public void visitLdcInsn(Object constant) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitLdcInsn(constant);
        if (this.waitingForSuper) {
            if (constant instanceof Long || constant instanceof Double) {
                this.push(OTHER, 2);
            } else {
                this.push(OTHER, 1);
            }
        }
    }

    public void visitLookupSwitchInsn(Label defaultTarget, int[] keys, Label[] labels) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitLookupSwitchInsn(defaultTarget, keys, labels);
        if (this.waitingForSuper) {
            this.pop(1);
            this.addBranchTarget(defaultTarget);
            for (Label label : labels) {
                this.addBranchTarget(label);
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitMethodInsn(opcode, owner, name, desc);
        if (this.waitingForSuper) {
            for (Type arg : Type.getArgumentTypes((String)desc)) {
                this.pop(arg.getSize());
            }
            switch (opcode) {
                case 184: {
                    break;
                }
                case 182: 
                case 185: {
                    this.pop(1);
                    break;
                }
                case 183: {
                    Object top = this.pop(1);
                    if (top != THIS) break;
                    this.waitingForSuper = false;
                    this.processMethodEntry();
                }
            }
            Type returnType = Type.getReturnType((String)desc);
            if (returnType != Type.VOID_TYPE) {
                this.push(OTHER, returnType.getSize());
            }
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitMultiANewArrayInsn(desc, dims);
        if (this.waitingForSuper) {
            this.pop(dims);
            this.push(OTHER, 1);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label defaultLabel, Label ... labels) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitTableSwitchInsn(min, max, defaultLabel, labels);
        if (this.waitingForSuper) {
            this.pop(1);
            this.addBranchTarget(defaultLabel);
            for (Label label : labels) {
                this.addBranchTarget(label);
            }
        }
    }

    public void visitTypeInsn(int opcode, String type) {
        this.processPendingExceptionHandlerEntry(-1);
        super.visitTypeInsn(opcode, type);
        if (this.waitingForSuper) {
            switch (opcode) {
                case 187: {
                    this.push(OTHER, 1);
                    break;
                }
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (opcode == 58) {
            super.visitVarInsn(opcode, var);
            this.processPendingExceptionHandlerEntry(var);
        } else {
            this.processPendingExceptionHandlerEntry(-1);
            super.visitVarInsn(opcode, var);
        }
        if (this.waitingForSuper) {
            switch (opcode) {
                case 25: {
                    this.push(var == 0 ? THIS : OTHER, 1);
                    break;
                }
                case 21: 
                case 23: {
                    this.push(OTHER, 1);
                    break;
                }
                case 22: 
                case 24: {
                    this.push(OTHER, 2);
                    break;
                }
                case 54: 
                case 56: 
                case 58: {
                    this.pop(1);
                    break;
                }
                case 55: 
                case 57: {
                    this.pop(2);
                    break;
                }
            }
        }
    }

    private void visitFrameAfterMethodReturnCallback() {
        if (!this.visitFramesAfterCallbacks) {
            return;
        }
        Type returnType = this.getReturnTypeForTrace();
        if (!Type.VOID_TYPE.equals((Object)this.getReturnTypeForTrace()) && !this.isConstructor()) {
            Object typeDescriptor = null;
            switch (returnType.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    typeDescriptor = INTEGER;
                    break;
                }
                case 8: {
                    typeDescriptor = DOUBLE;
                    break;
                }
                case 6: {
                    typeDescriptor = FLOAT;
                    break;
                }
                case 7: {
                    typeDescriptor = LONG;
                    break;
                }
                default: {
                    typeDescriptor = returnType.getInternalName();
                }
            }
            this.visitFrame(4, 0, null, 1, new Object[]{typeDescriptor});
        } else {
            this.visitFrame(3, 0, null, 0, null);
        }
    }

    private void visitFrameAfterOnThrowCallback() {
        if (!this.visitFramesAfterCallbacks) {
            return;
        }
        this.visitFrame(3, 0, null, 0, null);
        this.visitInsn(0);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.handlers.put(handler, type);
        }
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.waitingForSuper) {
            if (this.branchTargets.containsKey(label)) {
                this.currentStack = this.branchTargets.get(label);
            }
        } else {
            this.pendingExceptionHandlerTypeName = this.handlers.get(label);
        }
    }

    public void visitFrame(int type, int numLocals, Object[] locals, int stackSize, Object[] stack) {
        if (!this.isVisitFrameRequired()) {
            return;
        }
        super.visitFrame(type, numLocals, locals, stackSize, stack);
    }

    private void visitFrameAfterOnExceptionHandlerEntry() {
        if (!this.visitFramesAfterCallbacks) {
            return;
        }
        this.visitFrame(3, 0, null, 0, null);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index < this.firstNonParameterSlot) {
            start = this.methodEntryLabel;
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        if (!this.methodEntryHasLineNumber) {
            this.methodEntryHasLineNumber = true;
            start = this.methodEntryLabel;
        }
        this.lineNumber = line;
        super.visitLineNumber(line, start);
    }

    protected void createTraceArrayForParameters() {
        String className;
        String ownerName;
        int localVarOffset = this.isStatic ? 0 : 1;
        int syntheticArgs = 0;
        if (this.isConstructor() && ((AbstractRasClassAdapter)this.getClassAdapter()).isInnerClass() && this.argTypes.length > 1 && Type.getObjectType((String)(ownerName = (className = ((AbstractRasClassAdapter)this.getClassAdapter()).getClassInternalName()).substring(0, className.lastIndexOf("$")))).equals((Object)this.argTypes[0])) {
            syntheticArgs = 1;
        }
        this.visitLdcInsn(new Integer(this.argTypes.length - syntheticArgs));
        this.visitTypeInsn(189, "java/lang/Object");
        for (int i = syntheticArgs; i < this.argTypes.length; ++i) {
            int j = i + localVarOffset;
            this.visitInsn(89);
            this.visitLdcInsn(new Integer(i - syntheticArgs));
            this.boxLocalVar(this.argTypes[i], j, this.isArgumentSensitive(i));
            this.visitInsn(83);
            localVarOffset += this.argTypes[i].getSize() - 1;
        }
    }

    protected void boxLocalVar(Type type, int slot, boolean isSensitive) {
        this.visitVarInsn(type.getOpcode(21), slot);
        this.box(type, isSensitive);
    }

    protected void box(Type type, boolean isSensitive) {
        if (isSensitive) {
            this.boxSensitive(type);
            return;
        }
        switch (type.getSort()) {
            case 1: {
                this.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                this.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                this.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 8: {
                this.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 6: {
                this.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 5: {
                this.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                this.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 4: {
                this.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
        }
    }

    protected void boxSensitive(Type type) {
        if (type.getSize() == 2) {
            this.visitInsn(88);
        } else {
            this.visitInsn(87);
        }
        this.visitLdcInsn("<sensitive " + type.getClassName() + ">");
    }

    protected void visitGetTraceObjectField() {
        this.visitFieldInsn(178, ((AbstractRasClassAdapter)this.classAdapter).getClassInternalName(), this.classAdapter.getTraceObjectFieldName(), this.classAdapter.getTraceObjectFieldType().getDescriptor());
    }

    protected void visitSetTraceObjectField() {
        this.visitFieldInsn(179, ((AbstractRasClassAdapter)this.classAdapter).getClassInternalName(), this.classAdapter.getTraceObjectFieldName(), this.classAdapter.getTraceObjectFieldType().getDescriptor());
    }

    protected void visitLoadClassName() {
        this.visitLdcInsn(((AbstractRasClassAdapter)this.classAdapter).getClassName());
    }

    protected void visitLoadMethodName() {
        this.visitLdcInsn(this.methodName);
    }

    protected void visitGetClassForType(Type classType) {
        if (this.isLdcFromClassTypeAllowed()) {
            this.visitLdcInsn(classType);
        } else {
            this.mv.visitLdcInsn((Object)classType.getClassName());
            this.mv.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)}));
        }
    }

    protected Type getReturnTypeForTrace() {
        return this.isConstructor() ? Type.getObjectType((String)((AbstractRasClassAdapter)this.classAdapter).getClassInternalName()) : this.returnType;
    }

    protected boolean setupReturnObjectValueForExitTrace() {
        Type type = this.getReturnTypeForTrace();
        if (type.equals((Object)Type.VOID_TYPE)) {
            return false;
        }
        if (this.isConstructor()) {
            this.visitVarInsn(25, 0);
        } else if (type != Type.VOID_TYPE) {
            if (type.getSize() == 2) {
                this.visitInsn(92);
            } else {
                this.visitInsn(89);
            }
        }
        this.box(type, this.isResultSensitive());
        return true;
    }

    protected boolean isLdcFromClassTypeAllowed() {
        return (((AbstractRasClassAdapter)this.classAdapter).getClassVersion() & 0xFFFF) >= 49;
    }

    protected boolean isVisitFrameRequired() {
        return (((AbstractRasClassAdapter)this.classAdapter).getClassVersion() & 0xFFFF) >= 50;
    }

    protected C getClassAdapter() {
        return this.classAdapter;
    }

    MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    protected String getMethodName() {
        return this.methodName;
    }

    protected int getLineNumber() {
        return this.lineNumber;
    }

    protected boolean isStaticInitializer() {
        return "<clinit>".equals(this.methodName);
    }

    protected boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    protected boolean isResultSensitive() {
        if (this.methodInfo != null) {
            return this.methodInfo.isResultSensitive();
        }
        return this.observedAnnotations.contains(AbstractRasClassAdapter.SENSITIVE_TYPE);
    }

    protected boolean isArgumentSensitive(int index) {
        if (this.methodInfo != null) {
            return this.methodInfo.isArgSensitive(index);
        }
        Set<Type> parameterAnnotations = this.observedParameterAnnotations.get(index);
        if (parameterAnnotations != null) {
            return parameterAnnotations.contains(AbstractRasClassAdapter.SENSITIVE_TYPE);
        }
        return false;
    }

    protected boolean isTrivial() {
        if (this.methodInfo != null) {
            return this.methodInfo.isTrivial();
        }
        return this.observedAnnotations.contains(AbstractRasClassAdapter.TRIVIAL_TYPE);
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    protected boolean isTracedManually() {
        return this.observedAnnotations.contains(AlpineTracePreprocessInstrumentation.MANUAL_TRACE_TYPE);
    }

    protected boolean isMethodInstrumentedByThisAdapter() {
        if (this.injectedTraceAnnotationVisitor == null) {
            return false;
        }
        List<String> visitedMethodAdapters = this.injectedTraceAnnotationVisitor.getMethodAdapters();
        return visitedMethodAdapters.contains(((Object)((Object)this)).getClass().getName());
    }

    protected boolean isAlreadyTraced() {
        return this.isTracedManually() || this.isMethodInstrumentedByThisAdapter();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";methodInfo=").append(this.methodInfo);
        sb.append(",isStatic=").append(this.isStatic);
        sb.append(",lineNumber=").append(this.lineNumber);
        return sb.toString();
    }
}

