/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.AppMessageHelper;
import com.ibm.ws.app.manager.NotificationHelper;
import com.ibm.ws.app.manager.internal.ApplicationInstallInfo;
import com.ibm.ws.app.manager.internal.monitor.ApplicationMonitorConfig;
import com.ibm.ws.app.manager.internal.monitor.UpdateTrigger;
import com.ibm.ws.classloading.ClassLoadingButler;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationMonitor.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ApplicationMonitor {
    private final AtomicReference<ApplicationMonitorConfig> _config = new AtomicReference();
    private final AtomicReference<ExecutorService> _executorService = new AtomicReference();
    private final ConcurrentHashMap<String, ApplicationListeners> _appListeners = new ConcurrentHashMap();
    static final long serialVersionUID = -6600152248918069986L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext ctx, Map<String, Object> config) {
        ctx.getBundleContext();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        for (ApplicationListeners listeners : this._appListeners.values()) {
            listeners.stopListeners(true);
        }
    }

    @Reference(name="executorService")
    protected void setExecutorService(ScheduledExecutorService executorService) {
        this._executorService.set(executorService);
    }

    protected void unsetExecutorService(ScheduledExecutorService executorService) {
        this._executorService.set(null);
    }

    public ApplicationMonitorConfig getConfig() {
        return this._config.get();
    }

    public void refresh(ApplicationMonitorConfig config) {
        this._config.set(config);
        UpdateTrigger trigger = config.getUpdateTrigger();
        if (trigger != UpdateTrigger.DISABLED) {
            for (ApplicationListeners listeners : this._appListeners.values()) {
                listeners.startListeners(config.getPollingRate(), config.getUpdateTrigger() == UpdateTrigger.MBEAN);
            }
        } else {
            for (ApplicationListeners listeners : this._appListeners.values()) {
                listeners.stopListeners(false);
            }
        }
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public void addApplication(ApplicationInstallInfo installInfo) {
        boolean listenForRootStructuralChanges;
        Collection<Notifier.Notification> notificationsToMonitor;
        ApplicationMonitoringInformation ami = installInfo.getApplicationMonitoringInformation();
        if (ami != null) {
            notificationsToMonitor = ami.getNotificationsToMonitor();
            listenForRootStructuralChanges = ami.isListeningForRootStructuralChanges();
        } else {
            notificationsToMonitor = null;
            listenForRootStructuralChanges = true;
        }
        try {
            ApplicationMonitorConfig config;
            ApplicationListeners listeners = new ApplicationListeners(installInfo.getUpdateHandler(), this._executorService);
            if (notificationsToMonitor != null) {
                for (Notifier.Notification notificationToMonitor : notificationsToMonitor) {
                    ApplicationListener listener = new ApplicationListener(notificationToMonitor, listeners, installInfo);
                    listeners.addListener(listener);
                }
                listeners.addListener(new RootApplicationListener(installInfo.getContainer(), listenForRootStructuralChanges, listeners));
            } else {
                listeners.addListener(new CompleteApplicationListener(installInfo.getContainer(), listeners));
            }
            ApplicationListeners old = this._appListeners.put(installInfo.getPid(), listeners);
            if (old != null) {
                old.stopListeners(true);
            }
            if ((config = this._config.get()).getUpdateTrigger() != UpdateTrigger.DISABLED) {
                listeners.startListeners(config.getPollingRate(), config.getUpdateTrigger() == UpdateTrigger.MBEAN);
            }
        }
        catch (UnableToAdaptException e) {
            AppMessageHelper.get(installInfo.getHandler()).warning("APPLICATION_MONITORING_FAIL", installInfo.getName());
        }
    }

    public void removeApplication(String pid) {
        ApplicationListeners listeners = this._appListeners.remove(pid);
        if (listeners != null) {
            listeners.stopListeners(true);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ApplicationMonitor.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class CompleteApplicationListener
    extends BaseApplicationListener {
        static final long serialVersionUID = 354332027257632561L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CompleteApplicationListener(Container container, ApplicationListeners listeners) throws UnableToAdaptException {
            super((Notifier.Notification)new DefaultNotification(container, "/"), listeners);
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (removed.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.REMOVE);
            } else if (!(added.getPaths().isEmpty() && removed.getPaths().isEmpty() && modified.getPaths().isEmpty())) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CompleteApplicationListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ApplicationListener
    extends BaseApplicationListener {
        private final ApplicationInstallInfo appInfo;
        private final ClassLoadingButler butler;
        static final long serialVersionUID = 1026497165517839331L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationListener(Notifier.Notification monitoringInformation, ApplicationListeners listeners, ApplicationInstallInfo appInfo) throws UnableToAdaptException {
            super(monitoringInformation, listeners);
            this.appInfo = appInfo;
            this.butler = (ClassLoadingButler)appInfo.getContainer().adapt(ClassLoadingButler.class);
        }

        private boolean isMinorUpdate(Notifier.Notification modified) {
            if (modified.getPaths().isEmpty()) {
                return true;
            }
            for (String path : modified.getPaths()) {
                if (path.endsWith(".class")) continue;
                return false;
            }
            boolean isMinor = this.butler.redefineClasses(modified);
            if (isMinor) {
                NotificationHelper.broadcastChange(this.appInfo.getMBeanNotifier(), this.appInfo.getMBeanName(), "application.update", Boolean.TRUE, AppMessageHelper.get(this.appInfo.getHandler()).formatMessage("APPLICATION_UPDATED", this.appInfo.getName()));
                AppMessageHelper.get(this.appInfo.getHandler()).audit("APPLICATION_UPDATED", this.appInfo.getName());
            }
            return isMinor;
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (!(added.getPaths().isEmpty() && removed.getPaths().isEmpty() && this.isMinorUpdate(modified))) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class RootApplicationListener
    extends BaseApplicationListener {
        private final boolean listenForRootStructuralChanges;
        static final long serialVersionUID = -3538415793725844332L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public RootApplicationListener(Container container, boolean listenForRootStructuralChanges, ApplicationListeners listeners) throws UnableToAdaptException {
            super((Notifier.Notification)new DefaultNotification(container, "!/"), listeners);
            this.listenForRootStructuralChanges = listenForRootStructuralChanges;
        }

        public void notifyEntryChange(Notifier.Notification added, Notifier.Notification removed, Notifier.Notification modified) {
            if (removed.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.REMOVE);
            } else if (!(!this.listenForRootStructuralChanges || added.getPaths().isEmpty() && removed.getPaths().isEmpty())) {
                this.listeners.queueEvent(EventType.UPDATE);
            } else if (modified.getPaths().contains("/")) {
                this.listeners.queueEvent(EventType.UPDATE);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RootApplicationListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static abstract class BaseApplicationListener
    implements Notifier.NotificationListener {
        protected final Notifier applicationNotifier;
        protected final AtomicBoolean isListening = new AtomicBoolean(false);
        protected final Notifier.Notification monitoringInformation;
        protected final ApplicationListeners listeners;
        static final long serialVersionUID = 368981325486690867L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public BaseApplicationListener(Notifier.Notification monitoringInformation, ApplicationListeners listeners) throws UnableToAdaptException {
            this.monitoringInformation = monitoringInformation;
            this.applicationNotifier = (Notifier)monitoringInformation.getContainer().adapt(Notifier.class);
            this.listeners = listeners;
        }

        private synchronized void start(long interval, boolean useMBean) {
            this.applicationNotifier.setNotificationOptions(interval, useMBean);
            if (this.isListening.compareAndSet(false, true)) {
                this.applicationNotifier.registerForNotifications(this.monitoringInformation, (Notifier.NotificationListener)this);
            }
        }

        private synchronized void stop() {
            if (this.isListening.compareAndSet(true, false)) {
                this.applicationNotifier.removeListener((Notifier.NotificationListener)this);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BaseApplicationListener.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType UPDATE;
        public static final /* enum */ EventType REMOVE;
        private static final /* synthetic */ EventType[] $VALUES;
        static final long serialVersionUID = 8991273885684413367L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String name) {
            return Enum.valueOf(EventType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EventType.class);
            UPDATE = new EventType();
            REMOVE = new EventType();
            $VALUES = new EventType[]{UPDATE, REMOVE};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ApplicationListeners {
        private final UpdateHandler updateHandler;
        private final AtomicReference<ExecutorService> executorService;
        private final Collection<BaseApplicationListener> listeners = new HashSet<BaseApplicationListener>();
        private FutureTask<Object> future = null;
        private EventType eventType;
        private boolean start = true;
        static final long serialVersionUID = -7925656492005417059L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ApplicationListeners(UpdateHandler updateHandler, AtomicReference<ExecutorService> executorService) {
            this.updateHandler = updateHandler;
            this.executorService = executorService;
        }

        private void addListener(BaseApplicationListener listener) {
            this.listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopListeners(boolean terminal) {
            ApplicationListeners applicationListeners = this;
            synchronized (applicationListeners) {
                this.start = !terminal;
            }
            for (BaseApplicationListener listener : this.listeners) {
                listener.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startListeners(long interval, boolean useMBean) {
            boolean doStart;
            ApplicationListeners applicationListeners = this;
            synchronized (applicationListeners) {
                doStart = this.start;
            }
            if (doStart) {
                for (BaseApplicationListener listener : this.listeners) {
                    listener.start(interval, useMBean);
                }
            }
        }

        public synchronized void queueEvent(EventType eventToPerform) {
            ExecutorService executor;
            if (this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
            }
            if (this.eventType == null || this.eventType != EventType.REMOVE) {
                this.eventType = eventToPerform;
            }
            if ((executor = this.executorService.get()) != null) {
                this.future = new FutureTask<Object>(new Callable<Object>(){
                    static final long serialVersionUID = 3317205856618937509L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    @FFDCIgnore(value={InterruptedException.class})
                    public Object call() {
                        try {
                            Thread.sleep(200L);
                            ApplicationListeners.this.executeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                executor.execute(this.future);
            }
        }

        private synchronized void executeEvent() {
            if (this.eventType != null && this.start) {
                this.updateHandler.handleMonitorUpdate(this.eventType == EventType.REMOVE);
                this.future = null;
                this.eventType = null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ApplicationListeners.class);
        }
    }

    public static interface UpdateHandler {
        public void handleMonitorUpdate(boolean var1);
    }
}

