/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.utils;

import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import com.ibm.ws.webserver.plugin.utility.utils.CommonMBeanConnection;
import com.ibm.ws.webserver.plugin.utility.utils.ParseLoginAddress;
import com.ibm.ws.webserver.plugin.utility.utils.PluginUtilityConsole;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class PluginMBeanConnection
extends CommonMBeanConnection {
    static final String PLUGIN_CONFIG_MBEAN = "WebSphere:feature=PluginUtility,name=PluginConfigRequester";
    static final String FILE_TRANSFER_MBEAN = "WebSphere:feature=restConnector,type=FileTransfer,name=FileTransfer";
    private static final String CONNECTOR_ADDRESS_FILE_NAME = "com.ibm.ws.jmx.local.address";
    private final ObjectName objectName;
    private final PluginUtilityConsole console;
    JMXConnector connector = null;
    MBeanServerConnection mbsc = null;

    public PluginMBeanConnection(PluginUtilityConsole console) {
        super(console.getStdin(), console.getStderr());
        this.console = console;
        try {
            this.objectName = new ObjectName(PLUGIN_CONFIG_MBEAN);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException("Staticly defined MBean name WebSphere:feature=PluginUtility,name=PluginConfigRequester was not valid...", ex);
        }
    }

    public boolean generatePluginConfig(ParseLoginAddress loginAddress, String clusterName, String targetPath, String option) throws Exception {
        if (loginAddress.isLocal()) {
            this.console.printlnInfoMessage(CommandUtils.getMessage("generateWebServerPluginTask.start.server.local", loginAddress.getServerName()));
            this.connector = this.getLocalJMXConnection(loginAddress.getServerName());
        } else {
            this.console.printlnInfoMessage(CommandUtils.getMessage("generateWebServerPluginTask.start.server.remote", loginAddress.getHost() + ":" + loginAddress.getPort()));
            this.connector = this.getJMXConnector(loginAddress.getHost(), Integer.parseInt(loginAddress.getPort()), loginAddress.getUserName(), loginAddress.getPassword());
        }
        this.mbsc = this.connector.getMBeanServerConnection();
        boolean success = false;
        if (this.mbsc != null) {
            if (option.equalsIgnoreCase("collective")) {
                Object[] params = new Object[]{clusterName};
                String[] signature = new String[]{"java.lang.String"};
                success = (Boolean)this.mbsc.invoke(this.objectName, "generateClusterPlugin", params, signature);
            } else {
                Object[] params = new Object[]{};
                String[] signature = new String[]{};
                success = (Boolean)this.mbsc.invoke(this.objectName, "generateAppServerPlugin", params, signature);
            }
        }
        return success;
    }

    private JMXConnector getLocalJMXConnection(String serverName) throws IOException {
        String connectorAddr;
        JMXConnector localConnector = null;
        String serverOutputDir = System.getenv("WLP_OUTPUT_DIR");
        String serverRoot = serverOutputDir + File.separator + serverName + File.separator;
        if (serverName == null || serverName.length() == 0) {
            throw new IOException(CommandUtils.getMessage("serverNotFound", serverName, serverOutputDir));
        }
        String connectorFile = (serverRoot = serverRoot.replaceAll("\\\\", "/")) + "workarea" + File.separator + CONNECTOR_ADDRESS_FILE_NAME;
        File file = new File(connectorFile);
        if (file.exists()) {
            connectorAddr = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                connectorAddr = br.readLine();
            }
            catch (IOException e) {
                throw new IOException(CommandUtils.getMessage("jmx.local.connector.file.invalid", file.getAbsolutePath()));
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (connectorAddr == null) {
                throw new IOException(CommandUtils.getMessage("jmx.local.connector.file.invalid", file.getAbsolutePath()));
            }
        } else {
            throw new IOException(CommandUtils.getMessage("jmx.local.connector.file.notfound", file.getAbsolutePath()));
        }
        JMXServiceURL url = new JMXServiceURL(connectorAddr);
        localConnector = JMXConnectorFactory.connect(url);
        return localConnector;
    }

    public boolean remoteCopy(String clusterName, String targetPath) {
        boolean success = false;
        try {
            ObjectName fileTransferObjectName = new ObjectName(FILE_TRANSFER_MBEAN);
            String sourceFile = "${server.output.dir}" + File.separator + "logs" + File.separator + "state" + File.separator;
            if (clusterName != null) {
                sourceFile = sourceFile + clusterName + "-";
            }
            sourceFile = sourceFile + "plugin-cfg.xml";
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{sourceFile, targetPath};
            this.mbsc.invoke(fileTransferObjectName, "downloadFile", params, signature);
            File copiedFile = new File(targetPath);
            if (copiedFile.exists()) {
                success = true;
            }
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException("Staticly defined MBean name WebSphere:feature=restConnector,type=FileTransfer,name=FileTransfer was not valid...", ex);
        }
        catch (Exception e) {
            this.console.printlnErrorMessage(CommandUtils.getMessage("error", e.getMessage()));
            success = false;
        }
        return success;
    }

    public void closeConnector() throws IOException {
        if (this.connector != null) {
            this.connector.close();
        }
    }
}

