/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader.context.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloader.context.internal.ClassloaderContextProviderImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.RejectedExecutionException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassloaderContextImpl
implements ThreadContext {
    private static final long serialVersionUID = 2429635965226179594L;
    static final String CLASS_LOADER_IDENTIFIER = "I";
    private static final ObjectStreamField[] serialPersistentFields;
    static final ClassLoader SYSTEM_CLASS_LOADER;
    transient ClassloaderContextProviderImpl classLoaderContextProvider;
    transient ClassLoader classLoaderToPropagate;
    transient String classLoaderIdentifier;
    private transient ClassLoader previousClassLoader;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider) {
        this(provider, ClassloaderContextImpl.getCL());
    }

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider, String classLoaderIdentifier) {
        this.classLoaderContextProvider = provider;
        this.classLoaderIdentifier = classLoaderIdentifier;
    }

    ClassloaderContextImpl(ClassloaderContextProviderImpl provider, ClassLoader cl) {
        this.classLoaderContextProvider = provider;
        this.classLoaderToPropagate = cl;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadContext clone() {
        try {
            ClassloaderContextImpl copy = (ClassloaderContextImpl)super.clone();
            copy.previousClassLoader = null;
            return copy;
        }
        catch (CloneNotSupportedException copy) {
            void x;
            FFDCFilter.processException((Throwable)copy, (String)"com.ibm.ws.classloader.context.internal.ClassloaderContextImpl", (String)"117", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    public void taskStarting() throws RejectedExecutionException {
        if (this.classLoaderIdentifier != null && this.classLoaderToPropagate == null) {
            this.classLoaderToPropagate = this.classLoaderIdentifier.length() == 0 ? SYSTEM_CLASS_LOADER : this.classLoaderContextProvider.classLoaderIdentifierService.getClassLoader(this.classLoaderIdentifier);
        }
        this.previousClassLoader = ClassloaderContextImpl.getCL();
        this.setCL(this.classLoaderToPropagate);
    }

    public void taskStopping() {
        this.setCL(this.previousClassLoader);
        this.previousClassLoader = null;
    }

    private void setCL(final ClassLoader cl) {
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){
            static final long serialVersionUID = -936546149191500159L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        };
        AccessController.doPrivileged(action);
    }

    private static ClassLoader getCL() {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 3839148276333377060L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(3.class);
            }
        };
        return AccessController.doPrivileged(action);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.classLoaderIdentifier = (String)fields.get(CLASS_LOADER_IDENTIFIER, null);
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder(100).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(this.hashCode())).append(' ');
        if (this.classLoaderIdentifier != null) {
            sb.append(this.classLoaderIdentifier);
        } else {
            sb.append(this.classLoaderToPropagate);
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream outStream) throws IOException {
        if (this.classLoaderToPropagate == SYSTEM_CLASS_LOADER) {
            this.classLoaderIdentifier = "";
        } else if (this.classLoaderToPropagate != null) {
            this.classLoaderIdentifier = this.classLoaderContextProvider.getClassLoaderIdentifier(this.classLoaderToPropagate);
            if (this.classLoaderIdentifier == null) {
                throw new NotSerializableException(this.classLoaderToPropagate.getClass().getName());
            }
        }
        ObjectOutputStream.PutField fields = outStream.putFields();
        fields.put(CLASS_LOADER_IDENTIFIER, this.classLoaderIdentifier);
        outStream.writeFields();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClassloaderContextImpl.class);
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(CLASS_LOADER_IDENTIFIER, String.class)};
        SYSTEM_CLASS_LOADER = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 3789994635886440216L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        });
    }
}

