/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class RepositoryPathUtility {
    static final String HOST_REPOSITORY_PATH = "/sys.was.collectives/local/hosts/";
    public static final String METADATA_REPOSITORY_PATH = "/sys.was.system/metadata/";
    static final long serialVersionUID = 2311445735074397561L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    private static final boolean isLowerAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    @Trivial
    private static final boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    @Trivial
    private static final boolean isAlpha(char c) {
        return RepositoryPathUtility.isLowerAlpha(c) || RepositoryPathUtility.isUpperAlpha(c);
    }

    @Trivial
    private static final boolean hasWindowsDrivePrefix(String path) {
        if (path.length() < 3) {
            return false;
        }
        return RepositoryPathUtility.isAlpha(path.charAt(0)) && path.charAt(1) == ':' && path.charAt(2) == '/';
    }

    @Trivial
    private static final String capitalizeDriveLetter(String path) {
        if (RepositoryPathUtility.hasWindowsDrivePrefix(path) && RepositoryPathUtility.isLowerAlpha(path.charAt(0))) {
            return Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    @Trivial
    private static final String[] getServerTupleComponents(String serverTuple) {
        int lastComma;
        if (serverTuple == null) {
            return null;
        }
        int firstComma = serverTuple.indexOf(44);
        if (firstComma == (lastComma = serverTuple.lastIndexOf(44))) {
            return null;
        }
        String[] tupleComponents = new String[]{serverTuple.substring(0, firstComma), serverTuple.substring(firstComma + 1, lastComma), serverTuple.substring(lastComma + 1)};
        return tupleComponents;
    }

    public static final String buildServerRepositoryPath(String serverTuple) {
        String[] serverTupleComponents = RepositoryPathUtility.getServerTupleComponents(serverTuple);
        if (serverTupleComponents == null) {
            throw new IllegalArgumentException("The specified input to RepositoryPathUtility.buildServerRepositoryPath was not a recognized server tuple");
        }
        return RepositoryPathUtility.buildServerRepositoryPath(serverTupleComponents[0], RepositoryPathUtility.getURLEncodedPath(serverTupleComponents[1]), serverTupleComponents[2], true);
    }

    public static final String normalizePath(String path) {
        if (path == null) {
            return path;
        }
        if (path.isEmpty()) {
            return path;
        }
        path = PathUtils.normalize((String)path);
        if ((path = path.replaceAll("//+", "/")).startsWith("file:") && (path = path.substring(5)).length() > 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        if (!((path = RepositoryPathUtility.capitalizeDriveLetter(path)).length() == 3 && RepositoryPathUtility.hasWindowsDrivePrefix(path) || path.length() <= 1 || path.charAt(path.length() - 1) != '/')) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final String getURLEncodedPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("getURLEncodedPath: path is null");
        }
        path = RepositoryPathUtility.normalizePath(path);
        return RepositoryPathUtility.encodeDir(path);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeDir(String path) {
        try {
            return URLEncoder.encode(path, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.collective.utils.RepositoryPathUtility", (String)"194", null, (Object[])new Object[]{path});
            String msg = "Got a really un expected UnsupportedEncodingException. A JVM with no UTF8 support!";
            throw new IllegalStateException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final String decodeURLEncodedDir(String urlEncodedUserDir) {
        try {
            return URLDecoder.decode(urlEncodedUserDir, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.collective.utils.RepositoryPathUtility", (String)"211", null, (Object[])new Object[]{urlEncodedUserDir});
            String msg = "Got a really un expected UnsupportedEncodingException. A JVM with no UTF8 support!";
            throw new IllegalStateException(msg, (Throwable)e);
        }
    }

    public static final String buildHostRepositoryPath(String hostName) {
        String method = "buildHostRepositoryPath";
        RepositoryPathUtility.isValidString("buildHostRepositoryPath", "hostName", hostName);
        StringBuilder path = new StringBuilder(HOST_REPOSITORY_PATH);
        path.append(hostName.toLowerCase());
        path.append("/");
        return path.toString();
    }

    public static final String buildServerRepositoryPath(String hostName, String urlEncodedUserDir, String serverName) {
        return RepositoryPathUtility.buildServerRepositoryPath(hostName, urlEncodedUserDir, serverName, true);
    }

    public static final String buildServerRepositoryPath(String hostName, String urlEncodedUserDir, String serverName, boolean addTrailingSlash) {
        String method = "buildServerRepositoryPath";
        RepositoryPathUtility.isValidString("buildServerRepositoryPath", "hostName", hostName);
        RepositoryPathUtility.isValidString("buildServerRepositoryPath", "urlEncodedUserDir", urlEncodedUserDir);
        RepositoryPathUtility.isValidString("buildServerRepositoryPath", "serverName", serverName);
        StringBuilder path = new StringBuilder(HOST_REPOSITORY_PATH);
        path.append(hostName.toLowerCase());
        path.append("/userdirs/");
        path.append(urlEncodedUserDir);
        path.append("/servers/");
        path.append(serverName);
        if (addTrailingSlash) {
            path.append("/");
        }
        return path.toString();
    }

    public static final String buildMetadataIdentityPath(String resourceType, String identity) {
        String method = "buildMetadataIdentityPath";
        RepositoryPathUtility.isValidString("buildMetadataIdentityPath", "resourceType", resourceType);
        RepositoryPathUtility.isValidString("buildMetadataIdentityPath", "identity", identity);
        return RepositoryPathUtility.doBuildMetadataPath(resourceType, identity);
    }

    public static final String buildMetadataResourcePath(String resourceType) {
        String method = "buildMetadataResourcePath";
        RepositoryPathUtility.isValidString("buildMetadataResourcePath", "resourceType", resourceType);
        return RepositoryPathUtility.doBuildMetadataPath(resourceType, null);
    }

    private static String doBuildMetadataPath(String resourceType, String identity) {
        StringBuilder metdataPath = new StringBuilder(METADATA_REPOSITORY_PATH);
        metdataPath.append(resourceType.toLowerCase());
        metdataPath.append("/");
        if (identity != null) {
            if (identity.contains("/")) {
                int lastComma;
                int firstComma;
                if ("server".equals(resourceType)) {
                    identity = RepositoryPathUtility.encodeServerTuple(identity);
                }
                if ("application".equals(resourceType) && (firstComma = identity.indexOf(44)) != (lastComma = identity.lastIndexOf(44))) {
                    String serverTuple = identity.substring(0, lastComma);
                    identity = RepositoryPathUtility.encodeServerTuple(serverTuple) + "," + identity.substring(lastComma + 1);
                }
                if ("runtime".equals(resourceType)) {
                    firstComma = identity.indexOf(44);
                    String host = identity.substring(0, firstComma);
                    String runtime = identity.substring(firstComma + 1);
                    identity = host + "," + RepositoryPathUtility.getURLEncodedPath(runtime);
                }
            }
            metdataPath.append(identity.trim());
            metdataPath.append("/");
        }
        return metdataPath.toString();
    }

    private static final String getServerTuple(String path, boolean decodeUserDir) throws IllegalArgumentException {
        String method = "getServerTuple";
        RepositoryPathUtility.isValidString("getServerTuple", "path", path);
        if (path.matches("/sys.was.collectives/local/hosts/(.+)/userdirs/(.+)/servers/(.+)")) {
            String[] nodes = path.split("/");
            if (decodeUserDir) {
                return nodes[4] + "," + RepositoryPathUtility.decodeURLEncodedDir(nodes[6]) + "," + nodes[8];
            }
            return nodes[4] + "," + nodes[6] + "," + nodes[8];
        }
        throw new IllegalArgumentException("getServerTuple: path is not a server repository path");
    }

    public static final String getServerTuple(String path) throws IllegalArgumentException {
        return RepositoryPathUtility.getServerTuple(path, true);
    }

    public static final String getEncodedServerTuple(String path) throws IllegalArgumentException {
        return RepositoryPathUtility.getServerTuple(path, false);
    }

    public static final String encodeServerTuple(String tuple) {
        String method = "encodeServerTuple";
        RepositoryPathUtility.isValidString("encodeServerTuple", "tuple", tuple);
        String[] parts = RepositoryPathUtility.splitServerTuple(tuple);
        if (parts[1].contains("/")) {
            String hostName = parts[0];
            String wlpUserDir = parts[1];
            String serverName = parts[2];
            String encodedWlpUserDir = RepositoryPathUtility.getURLEncodedPath(wlpUserDir);
            StringBuilder sb = new StringBuilder();
            sb.append(hostName);
            sb.append(",");
            sb.append(encodedWlpUserDir);
            sb.append(",");
            sb.append(serverName);
            return sb.toString();
        }
        return tuple;
    }

    public static final String decodeServerTuple(String tuple) {
        String method = "decodeServerTuple";
        RepositoryPathUtility.isValidString("decodeServerTuple", "tuple", tuple);
        String hostName = tuple.substring(0, tuple.indexOf(44));
        String encodedWlpUserDir = tuple.substring(tuple.indexOf(44) + 1, tuple.lastIndexOf(44));
        String serverName = tuple.substring(tuple.lastIndexOf(44) + 1);
        String wlpUserDir = RepositoryPathUtility.decodeURLEncodedDir(encodedWlpUserDir);
        StringBuilder sb = new StringBuilder();
        sb.append(hostName);
        sb.append(",");
        sb.append(wlpUserDir);
        sb.append(",");
        sb.append(serverName);
        return sb.toString();
    }

    public static final String buildServerTuple(String hostName, String wlpUserDir, String serverName) {
        String method = "buildServerTuple";
        RepositoryPathUtility.isValidString("buildServerTuple", "hostName", hostName);
        RepositoryPathUtility.isValidString("buildServerTuple", "wlpUserDir", wlpUserDir);
        RepositoryPathUtility.isValidString("buildServerTuple", "serverName", serverName);
        StringBuilder path = new StringBuilder(hostName.toLowerCase());
        path.append(",");
        path.append(wlpUserDir);
        path.append(",");
        path.append(serverName);
        return path.toString();
    }

    public static final String buildEncodedServerTuple(String hostName, String urlEncodedUserDir, String serverName) {
        return RepositoryPathUtility.buildServerTuple(hostName, urlEncodedUserDir, serverName);
    }

    public static final String buildInstallDirPath(String hostName, String type, String wlpInstallDir) {
        StringBuilder path = new StringBuilder(HOST_REPOSITORY_PATH);
        path.append(hostName.toLowerCase());
        path.append("/installdirs/");
        if (type == null || type.length() == 0) {
            type = "other";
        }
        path.append(type);
        if (!wlpInstallDir.startsWith("/")) {
            path.append("/");
        }
        path.append(wlpInstallDir);
        path.append("/");
        return path.toString();
    }

    public static final String buildUserDirPath(String hostName, String wlpUserDir) {
        StringBuilder path = new StringBuilder(HOST_REPOSITORY_PATH);
        path.append(hostName.toLowerCase());
        if (wlpUserDir.startsWith("/")) {
            path.append("/userdirs");
        } else {
            path.append("/userdirs/");
        }
        path.append(wlpUserDir);
        path.append("/");
        return path.toString();
    }

    private static void isValidString(String method, String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException(method + ": " + name + " is null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException(method + ": " + name + " is empty");
        }
    }

    public static String[] splitServerTuple(String tuple) {
        return RepositoryPathUtility.getServerTupleComponents(tuple);
    }

    public static String[] splitRuntimeTuple(String tuple) {
        if (tuple == null) {
            return null;
        }
        int firstComma = tuple.indexOf(44);
        String[] tupleComponents = new String[]{tuple.substring(0, firstComma), tuple.substring(firstComma + 1)};
        return tupleComponents;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(RepositoryPathUtility.class);
    }
}

