/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.security.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.ROLES;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSBatchAuthServiceImpl
implements WSBatchAuthService {
    public static final String BATCH_AUTH_ID = "com.ibm.ws.batch";
    private static final Logger logger = Logger.getLogger(WSBatchAuthServiceImpl.class.getCanonicalName(), "com.ibm.ws.jbatch.security.resources.BatchSecurityMessages");
    private IPersistenceManagerService persistenceManagerService;
    private BatchSecurityHelper batchSecurityHelper;
    private static final String SecurityServiceReferenceName = "securityService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    static final long serialVersionUID = 6620402543704632695L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSBatchAuthServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "<init>", new Object[0]);
        }
        this.batchSecurityHelper = null;
        this.securityServiceRef = new AtomicServiceReference(SecurityServiceReferenceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(name="securityService", service=SecurityService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setSecurityService", new Object[]{reference});
        }
        this.securityServiceRef.setReference(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setSecurityService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetSecurityService", new Object[]{reference});
        }
        this.securityServiceRef.unsetReference(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetSecurityService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext cc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "activate", new Object[]{cc});
        }
        this.securityServiceRef.activate(cc);
        logger.log(Level.INFO, "BATCH_SECURITY_ENABLED");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "deactivate", new Object[]{cc});
        }
        logger.log(Level.INFO, "BATCH_SECURITY_DISABLED");
        this.securityServiceRef.deactivate(cc);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AuthorizationService getAuthorizationService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getAuthorizationService", new Object[0]);
        }
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authorizationService = securityService != null ? securityService.getAuthorizationService() : null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            authorizationService = authorizationService;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getAuthorizationService", authorizationService);
        }
        return authorizationService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        this.batchSecurityHelper = batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setIPersistenceManagerService", new Object[]{pms});
        }
        this.persistenceManagerService = pms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        if (this.batchSecurityHelper == batchSecurityHelper) {
            this.batchSecurityHelper = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIPersistenceManagerService(IPersistenceManagerService pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetIPersistenceManagerService", new Object[]{pms});
        }
        if (this.persistenceManagerService == pms) {
            this.persistenceManagerService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedInstanceRead(long instanceId) throws JobSecurityException, NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedInstanceRead", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        if (!this.isAdmin(this.runAsSubject()) && !this.isMonitor(this.runAsSubject())) {
            if (this.isSubmitter(this.runAsSubject())) {
                if (!this.batchSecurityHelper.getRunAsUser().equals(submitter)) {
                    throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
                }
            } else {
                throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_NO_BATCH_ROLES", new Object[]{this.getRunAsUser()}, "CWWKY0303W: User {0} is not authorized to perform any batch operations."));
            }
        }
        long l = instanceId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedInstanceRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedExecutionRead(long executionId) throws JobSecurityException, NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedExecutionRead", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        this.authorizedInstanceRead(instanceId);
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedExecutionRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRunAsUser() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getRunAsUser", new Object[0]);
        }
        String string = this.batchSecurityHelper.getRunAsUser();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getRunAsUser", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void authorizedJobSubmission() throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobSubmission", new Object[0]);
        }
        if (!this.isAdmin(this.runAsSubject()) && !this.isSubmitter(this.runAsSubject())) {
            throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_TO_START_JOB", new Object[]{this.getRunAsUser()}, "CWWKY0304W: User {0} is not authorized to start batch jobs."));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobSubmission");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobRestartByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByExecution", new Object[]{executionId});
        }
        long l = this.authorizedJobStopRestartByExecution(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobRestartByInstance(long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobStopRestartByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobStopByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByExecution", new Object[]{executionId});
        }
        long l = this.authorizedJobStopRestartByExecution(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobStopByInstance(long instanceId) throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobStopRestartByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobStopRestartByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByExecution", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        this.authorizedJobStopRestart(submitter, instanceId);
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobStopRestartByInstance(long instanceId) throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByInstance", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        this.authorizedJobStopRestart(submitter, instanceId);
        long l = instanceId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void authorizedJobStopRestart(String submitter, long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestart", new Object[]{submitter, instanceId});
        }
        if (this.isAdmin(this.runAsSubject())) {
            logger.finer("Current user " + this.getRunAsUser() + " is admin, so always authorized");
        } else if (this.isSubmitter(this.runAsSubject())) {
            if (!this.batchSecurityHelper.getRunAsUser().equals(submitter)) {
                throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
            }
        } else {
            if (this.isMonitor(this.runAsSubject())) {
                throw new JobSecurityException("Current user " + this.getRunAsUser() + " with role batch_monitor is not authorized to stop or restart jobs.");
            }
            throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_NO_BATCH_ROLES", new Object[]{this.getRunAsUser()}, "CWWKY0303W: User {0} is not authorized to perform any batch operations."));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobPurgeByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobPurgeAbandonByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobAbandonByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobAbandonByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobPurgeAbandonByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobAbandonByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobPurgeAbandonByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeAbandonByInstance", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        boolean unAuthFlag = false;
        if (this.isInAnyBatchRole()) {
            if (this.isAdmin()) {
                logger.finer("Current user " + this.getRunAsUser() + " is admin, so always authorized");
            } else if (this.getRunAsUser().equals(submitter)) {
                if (!this.isSubmitter()) {
                    unAuthFlag = true;
                }
            } else {
                unAuthFlag = true;
            }
            if (unAuthFlag) {
                throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
            }
            long l = instanceId;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                l = l;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeAbandonByInstance", l);
            }
            return l;
        }
        throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_NO_BATCH_ROLES", new Object[]{this.getRunAsUser()}, "CWWKY0303W: User {0} is not authorized to perform any batch operations."));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAdmin() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", new Object[0]);
        }
        boolean bl = this.isAdmin(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isSubmitter() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", new Object[0]);
        }
        boolean bl = this.isSubmitter(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isMonitor() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", new Object[0]);
        }
        boolean bl = this.isMonitor(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInAnyBatchRole() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", new Object[0]);
        }
        boolean bl = this.isInAnyBatchRole(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAuthorizedInstanceRead(long instanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        if (!this.isAdmin(this.runAsSubject()) && !this.isMonitor(this.runAsSubject())) {
            if (this.batchSecurityHelper.getRunAsUser().equals(submitter)) {
                if (!this.isInAnyBatchRole(this.runAsSubject())) {
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", bl);
                    }
                    return bl;
                }
            } else {
                logger.finer("Current user " + this.getRunAsUser() + " does not match the tag of record");
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAuthorizedExecutionRead(long executionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedExecutionRead", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        boolean bl = this.isAuthorizedInstanceRead(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedExecutionRead", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedStepExecutionRead(long stepExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedStepExecutionRead", new Object[]{stepExecutionId});
        }
        long instanceId = this.persistenceManagerService.getStepExecutionTopLevel(stepExecutionId).getJobExecution().getJobInstance().getInstanceId();
        this.authorizedInstanceRead(instanceId);
        long l = stepExecutionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedStepExecutionRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Subject runAsSubject() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "runAsSubject", new Object[0]);
        }
        Subject subject = this.batchSecurityHelper.getRunAsSubject();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            subject = subject;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "runAsSubject", subject);
        }
        return subject;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isAdmin(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchAdmin);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSubmitter(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchSubmitter);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isMonitor(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchMonitor);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isInBatchRole(Subject runAsSubject, ROLES batchRole) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", new Object[]{runAsSubject, batchRole});
        }
        AuthorizationService authzService = this.getAuthorizationService();
        if (authzService != null) {
            boolean bl = authzService.isAuthorized(BATCH_AUTH_ID, new HashSet<String>(Arrays.asList(batchRole.toString())), runAsSubject);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isInAnyBatchRole(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", new Object[]{runAsSubject});
        }
        AuthorizationService authzService = this.getAuthorizationService();
        if (authzService != null) {
            boolean bl = authzService.isAuthorized(BATCH_AUTH_ID, new HashSet<String>(Arrays.asList(ROLES.batchAdmin.toString(), ROLES.batchSubmitter.toString(), ROLES.batchMonitor.toString())), runAsSubject);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getFormattedMessage(String msgId, Object[] fillIns, String defaultMsg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getFormattedMessage", new Object[]{msgId, fillIns, defaultMsg});
        }
        String string = TraceNLS.getFormattedMessage(WSBatchAuthServiceImpl.class, (String)logger.getResourceBundleName(), (String)msgId, (Object[])fillIns, (String)defaultMsg);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getFormattedMessage", string);
        }
        return string;
    }
}

