/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.metadata.AddressingFeatureInfo;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.MTOMFeatureInfo;
import com.ibm.ws.jaxws.metadata.RespectBindingFeatureInfo;
import com.ibm.ws.jaxws.metadata.ServiceModeInfo;
import com.ibm.ws.jaxws.metadata.builder.AbstractEndpointInfoConfigurator;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoConfigurator;
import com.ibm.ws.jaxws.metadata.builder.HandlerChainInfoBuilder;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import javax.xml.ws.Service;
import org.apache.cxf.common.util.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={EndpointInfoConfigurator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=false, property={"service.vendor=IBM"})
public class AnnotationEndpointInfoConfigurator
extends AbstractEndpointInfoConfigurator {
    private static final TraceComponent tc = Tr.register(AnnotationEndpointInfoConfigurator.class);
    static final long serialVersionUID = 1611799169985004799L;

    public AnnotationEndpointInfoConfigurator() {
        super(EndpointInfoConfigurator.Phase.PROCESS_ANNOTATION);
    }

    @Override
    public void prepare(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) {
        InfoStore infoStore = context.getInfoStore();
        ClassInfo implBeanClassInfo = infoStore.getDelayableClassInfo(endpointInfo.getImplBeanClassName());
        endpointInfo.setServiceEndpointInterface(JaxWsUtils.getSEIClassNameFromAnnotation(implBeanClassInfo));
    }

    @Override
    public void config(EndpointInfoBuilderContext context, EndpointInfo endpointInfo) {
        InfoStore infoStore = context.getInfoStore();
        ClassInfo implBeanClassInfo = infoStore.getDelayableClassInfo(endpointInfo.getImplBeanClassName());
        String seiClassName = endpointInfo.getServiceEndpointInterface();
        endpointInfo.setTargetNamespaceURL(JaxWsUtils.getImplementedTargetNamespace(implBeanClassInfo));
        endpointInfo.setInterfaceTragetNameSpaceURL(JaxWsUtils.getInterfaceTargetNamespace(implBeanClassInfo, seiClassName, endpointInfo.getTargetNamespaceURL(), infoStore));
        endpointInfo.setWsdlService(JaxWsUtils.getServiceQName(implBeanClassInfo, seiClassName, endpointInfo.getTargetNamespaceURL()));
        endpointInfo.setWsdlPort(JaxWsUtils.getPortQName(implBeanClassInfo, seiClassName, endpointInfo.getTargetNamespaceURL()));
        endpointInfo.setPortComponentName(JaxWsUtils.getPortComponentName(implBeanClassInfo, seiClassName, infoStore));
        if (endpointInfo.getAddresses().length == 0) {
            endpointInfo.addAddress("/" + JaxWsUtils.getServiceName(implBeanClassInfo));
        }
        endpointInfo.setWsdlLocation(JaxWsUtils.getWSDLLocation(implBeanClassInfo, seiClassName, infoStore));
        this.configMTOMFeatureInfo(implBeanClassInfo, seiClassName, infoStore, endpointInfo);
        this.configAddressingFeatureInfo(implBeanClassInfo, seiClassName, infoStore, endpointInfo, context);
        this.configRespectBindingFeatureInfo(implBeanClassInfo, seiClassName, infoStore, endpointInfo);
        this.configProtocolBinding(implBeanClassInfo, seiClassName, infoStore, endpointInfo);
        this.configServiceMode(implBeanClassInfo, seiClassName, infoStore, endpointInfo);
        HandlerChainInfoBuilder handlerChainBuilder = new HandlerChainInfoBuilder(JaxWsUtils.getModuleInfo(context.getContainer()).getClassLoader());
        endpointInfo.setHandlerChainsInfo(handlerChainBuilder.buildHandlerChainsInfoFromAnnotation(implBeanClassInfo, seiClassName, infoStore, endpointInfo.getWsdlPort(), endpointInfo.getWsdlService(), endpointInfo.getProtocolBinding()));
    }

    private void configMTOMFeatureInfo(ClassInfo implClassInfo, String seiClassName, InfoStore infoStore, EndpointInfo endpointInfo) {
        AnnotationInfo anno = implClassInfo.getAnnotation("javax.xml.ws.soap.MTOM");
        if (null == anno) {
            if (!StringUtils.isEmpty((String)seiClassName)) {
                anno = infoStore.getDelayableClassInfo(seiClassName).getAnnotation("javax.xml.ws.soap.MTOM");
            }
            if (null == anno) {
                return;
            }
        }
        endpointInfo.setMTOMFeatureInfo(new MTOMFeatureInfo(anno.getBoolean("enabled"), anno.getValue("threshold").getInteger()));
    }

    private void configAddressingFeatureInfo(ClassInfo implClassInfo, String seiClassName, InfoStore infoStore, EndpointInfo endpointInfo, EndpointInfoBuilderContext ctx) {
        AnnotationInfo anno = implClassInfo.getAnnotation("javax.xml.ws.soap.Addressing");
        if (null == anno) {
            if (!StringUtils.isEmpty((String)seiClassName)) {
                anno = infoStore.getDelayableClassInfo(seiClassName).getAnnotation("javax.xml.ws.soap.Addressing");
            }
            if (null == anno) {
                this.configAddressingFeatureInfoFromWsdl(implClassInfo, ctx, endpointInfo);
                return;
            }
        }
        endpointInfo.setAddressingFeatureInfo(new AddressingFeatureInfo((boolean)anno.getBoolean("enabled"), (boolean)anno.getBoolean("required"), anno.getValue("responses") == null ? "ALL" : anno.getValue("responses").getEnumValue()));
    }

    /*
     * Exception decompiling
     */
    private void configAddressingFeatureInfoFromWsdl(ClassInfo implClassInfo, EndpointInfoBuilderContext ctx, EndpointInfo endpointInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void configRespectBindingFeatureInfo(ClassInfo implClassInfo, String seiClassName, InfoStore infoStore, EndpointInfo endpointInfo) {
        AnnotationInfo anno = implClassInfo.getAnnotation("javax.xml.ws.RespectBinding");
        if (null == anno) {
            if (!StringUtils.isEmpty((String)seiClassName)) {
                anno = infoStore.getDelayableClassInfo(seiClassName).getAnnotation("javax.xml.ws.RespectBinding");
            }
            if (null == anno) {
                return;
            }
        }
        endpointInfo.setRespectBindingFeatureInfo(new RespectBindingFeatureInfo(anno.getBoolean("enabled")));
    }

    private void configProtocolBinding(ClassInfo implClassInfo, String seiClassName, InfoStore infoStore, EndpointInfo endpointInfo) {
        AnnotationInfo anno = implClassInfo.getAnnotation("javax.xml.ws.BindingType");
        if (null == anno) {
            if (!StringUtils.isEmpty((String)seiClassName)) {
                anno = infoStore.getDelayableClassInfo(seiClassName).getAnnotation("javax.xml.ws.BindingType");
            }
            if (null == anno) {
                return;
            }
        }
        endpointInfo.setProtocolBinding(JaxWsUtils.getProtocolByToken(anno.getValue("value").getStringValue(), true));
    }

    private void configServiceMode(ClassInfo implClassInfo, String seiClassName, InfoStore infoStore, EndpointInfo endpointInfo) {
        AnnotationInfo anno = implClassInfo.getAnnotation("javax.xml.ws.ServiceMode");
        if (null == anno) {
            if (!StringUtils.isEmpty((String)seiClassName)) {
                anno = infoStore.getDelayableClassInfo(seiClassName).getAnnotation("javax.xml.ws.ServiceMode");
            }
            if (null == anno) {
                endpointInfo.setServiceModeInfo(new ServiceModeInfo(Service.Mode.PAYLOAD));
                return;
            }
        }
        endpointInfo.setServiceModeInfo(new ServiceModeInfo(anno.getValue("value").getEnumValue()));
    }
}

